<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
    $(document).ready(function() {
      	var table = $('#result').removeAttr('width').DataTable({
           	dom: 'rtip',
            buttons: ['excel'],
    		scrollY: '45vh',
    		scrollX: '100%',
        	scrollCollapse: true,
    		fixedHeader: false,
    		"ordering": false,
        	paging: false,
    		"pageLength": 100,
    		responsive: true,
    		"autoWidth": false,
    		"language": {
        		"info": "Registros visualizados: _MAX_",
    			"search": "Buscar:",
    			"zeroRecords": "No se han encontrado registros",
    			"decimal": ",",
    	  		"thousands": ".",
    			"paginate": {
    		    	"first":      "Primera",
    	      		"last":       "Ultima",
    	      		"next":       "Siguiente",
    	      		"previous":   "Anterior"
        		}
        	}
      	});

    	$("#rut").autocomplete({
          	source: function(request, response) {
              	$.ajax({
                  	url: "./vta/tnd_buscaClienteRut.php",
                  	dataType: "json",
                  	data: {
                      	term: request.term
                  	},
                  	success: function(data) {
                      	response(data);
                  	}
              	});
          	},
          	minLength: 2,
          	select: function(event, ui) {
          		var cli = ui.item;
          		$('#rut').val(cli.LicTradNum);
          		$('#razonsocial').val(cli.CardName + " - " + cli.SlpName);
          		$("#cardcode").val(cli.CardCode);
              	return false;
          	},
          	open: function() {
              	$(this).removeClass("ui-corner-all").addClass("ui-corner-top");
          	},
          	close: function() {
              	$(this).removeClass("ui-corner-top").addClass("ui-corner-all");
          	}
      	});
      	$('#rut').data("ui-autocomplete")._renderItem = function(ul, item) {
          	return $("<li>").append("<a>" + item.LicTradNum + " - " + item.CardCode + "</a>").appendTo(ul);
      	};

      	$("#razonsocial").autocomplete({
          	source: function(request, response) {
              	$.ajax({
                  	url: "./vta/tnd_buscaClienteName.php",
                  	dataType: "json",
                  	data: {
                      	term: request.term
                  	},
                  	success: function(data) {
                      	response(data);
                  	}
              	});
          	},
          	minLength: 4,
          	select: function(event, ui) {
          		var cli = ui.item;
          		$('#rut').val(cli.LicTradNum);
          		$('#razonsocial').val(cli.CardName + " - " + cli.SlpName);
          		$("#cardcode").val(cli.CardCode);
              	return false;
          	},
          	open: function() {
              	$(this).removeClass("ui-corner-all").addClass("ui-corner-top");
          	},
          	close: function() {
              	$(this).removeClass("ui-corner-top").addClass("ui-corner-all");
          	}
      	});
      	$('#razonsocial').data("ui-autocomplete")._renderItem = function(ul, item) {
          	return $("<li>").append("<a>" + item.CardName + " - " + item.SlpName + "</a>").appendTo(ul);
      	};
    });

    function LimpiaCardCode2()
	{
    	$("#vista-cliente").addClass("d-none");
    	$('#rut').val("");
    	$('#razonsocial').val("");
		if (document.getElementById('cardcode').value == '' || document.getElementById('cardcode').value == 'nada'){
			document.getElementById('cardcode').value = '';
		}
	}
</script>
<style>
	.bg-azul {
	   background-image: linear-gradient(-90deg, rgba(0,40,72,1), rgba(0,75,122,1));
	   color: #FFFFFF;
	}
	.bg-amarillo {
	   background-color: rgba(249, 236, 0, 1);
	   color: rgba(0, 125, 80, 1);
	}
	.bg-naranja {
	   background-color: #fdb819;
	   color: rgba(0, 125, 80, 1);
	}
	.bg-gris {
	   background-color: rgba(238, 238,238, 1);
	   color: rgba(0, 0, 0, 1);
	}
	.head-titulo{
	   font-weight: bold;
	   color: #808080;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-azul">
	      <h5 class="card-title">Alta de Clientes</h5>
	    </div>
	    <div class="card-body">
	    	<form action="./vta/tnd_getCliente.php" method="POST" id="form1" name="form1">
    	    	<div class="row">
    	    		<div class="col-md-2 col-lg-2 col-sm-4 offset-md-1 offset-lg-1">
    	    			<input type="text" class="form-control" pattern="([\d]{7,8}[-]?[0-9kK]{1})" required id="rut" name="rut"  placeholder="RUT (ej: 756854891)"  onFocus="LimpiaCardCode2()">
                		<input type="hidden" name="cardcode" id="cardcode" >
    	    		</div>
    	    		<div class="col-md-7 col-lg-7 col-sm-8">
    	    			<input type="text" required class="form-control " id="razonsocial" name="razonsocial"  placeholder="Razón Social"  onFocus="LimpiaCardCode2()">
    	    		</div>
    	    		<div class="col-md-1 col-lg-1 col-sm-12">
                    	<button class="btn bg-amarillo fw-bold" id="btnSend" >Buscar</button>
	    			</div>
	    		</div>
	    	</form>
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
	    			<hr>
	    		</div>
	    	</div>
	    	<div class="d-none" id="vista-cliente">
	    		<div class="row py-2">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
    					<div class="card">
                    	    <div class="card-header bg-azul">
                    	      <h5 class="card-title">Datos del Cliente</h5>
                    	    </div>
                    	    <div class="card-body">
                    	    	<div id="msg-OK" class="alert alert-success d-none alert-dismissible" role="alert">
                    	    		El cliente ha sido activado satisfactoriamente en la tienda en l&iacute;nea.
                    	    		<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    	    	</div>
                    	    	<div id="msg-noOK" class="alert alert-success d-none alert-dismissible" role="alert">
                    	    		El cliente ha sido inhabilitado para ingresar a la tienda en l&iacute;nea.
                    	    		<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    	    	</div>
                    	    	<div id="msg-exist" class="alert alert-success d-none alert-dismissible" role="alert">
                    	    		El cliente ha sido reactivado en la tienda.
                    	    		<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    	    	</div>
                    	    	<div id="msg-error" class="alert alert-danger d-none alert-dismissible" role="alert">
                    	    		Ha ocurrido un error al registrar al cliente. Comun&iacute;quese con el administrador.
                    	    		<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    	    	</div>
                    	    	<div id="msg-alerta" class="alert alert-danger d-none alert-dismissible" role="alert">
                    	    		El cliente no tiene registrado un correo electr&oacute;nico v&aacute;lido, por lo que no puede ser activado en la tienda en l&iacute;nea
                    	    		<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    	    	</div>
                    	    	<div class="row py-1">
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold">RUT :</label>
                    	    		</div>
                    	    		<div class="col-md-1 col-lg-1 col-sm-12">
                    	    			<label id="rut-cli"></label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12 offset-md-6 offset-lg-6">
                    	    			<label class="fw-bold">C&oacute;digo Cliente :</label>
                    	    		</div>
                    	    		<div class="col-md-1 col-lg-1 col-sm-12 text-end">
                    	    			<label id="code-cli"></label>
                    	    		</div>
                    	    	</div>
                    	    	<div class="row py-1">
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold">Raz&oacute;n Social :</label>
                    	    		</div>
                    	    		<div class="col-md-6 col-lg-6 col-sm-12">
                    	    			<label id="nombre-cli"></label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold" id="cabe-correo">Correo Electr&oacute;nico :</label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12 text-end">
                    	    			<label id="correo-cli"></label>
                    	    		</div>
                    	    	</div>
                    	    	<div class="row py-1">
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold">Vendedor :</label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label id="vendedor-cli"></label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold">Lista de Precios :</label>
                    	    		</div>
                    	    		<div class="col-md-3 col-lg-3 col-sm-12">
                    	    			<label id="lista-cli"></label>
                    	    		</div>
                    	    		<div class="col-md-2 col-lg-2 col-sm-12">
                    	    			<label class="fw-bold">Cliente Web :</label>
                    	    		</div>
                    	    		<div class="col-md-1 col-lg-1 col-sm-12  text-end">
                    	    			<label id="web-cli"></label>
                    	    		</div>
                    	    	</div>
                    	    </div>
                    	    <div class="card-header bg-azul">
                    	      	<h5 class="card-title">Direcciones</h5>
                    	    </div>
                    	    <div class="card-body">
    							<div class="row py-1">
    								<h5 class="head-titulo">Facturaci&oacute;n</h5>
    								<hr>
    							</div>
    							<div class="row bg-gris py-1">
                    	    		<div class="col-md-3 col-lg-3 col-sm-12">
                    	    			<label class="fw-bold" id="id-dir-fact-cli"></label>
                    	    		</div>
                    	    		<div class="col-md-9 col-lg-9 col-sm-12">
                    	    			<label id="dir-fact-cli"></label>
                    	    		</div>
                    	    	</div>
                    	    	<br>
                    	    	<div class="row py-1">
    								<h5 class="head-titulo">Despacho</h5>
    								<hr>
    							</div>
    							<div id="lista-dir-desp">
    							</div>
                    	    </div>
                    	</div>
    	    		</div>
	    		</div>
	    		<div class="row py-2">
    	    		<div class="col-md-12 col-lg-12 col-sm-12 text-end">
        	    		<button class="btn btn-success" id="btnUpload" onClick="updCliente();"><i class="fa fa-cloud-upload" aria-hidden="true"></i> Activar en Tienda</button>
        	    		<button class="btn btn-danger" id="btnDownload" onClick="deactCliente();"><i class="fa fa-cloud-download" aria-hidden="true"></i> Inactivar en Tienda</button>
        	    	</div>
    	    	</div>
	    	</div>
	    </div>
    </div>
	</div>
	<script>
        $('#form1').submit(function (ev) {
        	ev.preventDefault();
        	$.ajax({
                type: $('#form1').attr('method'),
                dataType: "json",
                url: $('#form1').attr('action'),
                data: $('#form1').serialize(),
                success: function (resp) {
                    if(resp != '0'){
                        var cli = resp[0];
                        $("#msg-OK").addClass("d-none");
                        $("#rut-cli").text(cli.LicTradNum);
                        $("#code-cli").text(cli.CardCode);
                        $("#nombre-cli").text(cli.CardName);
                        if(cli.E_Mail == ''){
                        	$("#msg-alerta").removeClass("d-none");
                        	$("#cabe-correo").removeClass("text-dark");
							$("#cabe-correo").addClass("text-danger");
							$("#btnUpload").prop("disabled", true);
                        } else {
                        	$("#msg-alerta").addClass("d-none");
                        	$("#cabe-correo").addClass("text-dark");
                        	$("#cabe-correo").removeClass("text-danger");
                        	$("#btnUpload").prop("disabled", false);
                        }
                        $("#correo-cli").text(cli.E_Mail);
                        $("#vendedor-cli").text(cli.SlpName);
                        $("#lista-cli").text(cli.ListName);
                        var web = "";
                        if(cli.U_ClienteWeb == 'Y'){
							web = "Activado";
							$("#btnUpload").addClass("d-none");
							$("#btnDownload").removeClass("d-none");
                        } else {
							web = "No Activado";
							$("#btnUpload").removeClass("d-none");
							$("#btnDownload").addClass("d-none");
                        }
                        $("#web-cli").text(web);

						$.ajax({
							type: "POST",
							dataType: "json",
							url: "./vta/tnd_getDirFactCliente.php",
							data: {
								cardcode: cli.CardCode
							},
							success: function(dfact) {
								var dirFact = dfact[0];
								$("#id-dir-fact-cli").text(dirFact.Address);
								$("#dir-fact-cli").text(dirFact.Street + " " + dirFact.Block + ", " + dirFact.County + ", " + dirFact.City);
							}
						});

						$.ajax({
							type: "POST",
							dataType: "json",
							url: "./vta/tnd_getDirDespCliente.php",
							data: {
								cardcode: cli.CardCode
							},
							success: function(ddesp) {
								var codigo = "";
								for(var x = 0; x < ddesp.length; x++){
									if(x % 2 == 0){
										codigo += "<div class=\"row bg-gris py-1\">";
									} else {
										codigo += "<div class=\"row py-1\">";
									}
                	    			codigo += "<div class=\"col-md-3 col-lg-3 col-sm-12\">";
                	    			codigo += "<label class=\"fw-bold\" id=\"id-dir-desp-cli-"+x+"\">"+ddesp[x].Address+"</label>";
                	    			codigo += "</div>";
                	    			codigo += "<div class=\"col-md-9 col-lg-9 col-sm-12\">";
                	    			codigo += "<label id=\"dir-fact-cli-"+x+"\">"+ddesp[x].Street + " " + ddesp[x].Block + ", " + ddesp[x].County + ", " + ddesp[x].City+"</label>";
                	    			codigo += "</div>";
                	    			codigo += "</div>";
								}
								$("#lista-dir-desp").html(codigo);
							}
						});

						$("#vista-cliente").removeClass("d-none");
                    }
            	}
            });
        });
    </script>
    <script>
		function updCliente(){
			var Cliente = $("#code-cli").text();
			$.ajax({
				type: 'POST',
				dataType: "json",
				url: './vta/tnd_updCliente.php',
				data: {
					cardcode: Cliente
				},
				success: function(resp){
					switch (resp.code) {
    					case 0:
    						//Cliente ya registrado
    						$("#msg-exist").removeClass("d-none");
        					$("#btnUpload").addClass("d-none");
        					$("#btnDownload").removeClass("d-none");
        					$("#web-cli").text("Activado");
    						break;
    					case 1:
    						// Cliente correctamente registrado
    						$("#msg-OK").removeClass("d-none");
        					$("#btnUpload").addClass("d-none");
        					$("#btnDownload").removeClass("d-none");
        					$("#web-cli").text("Activado");
    						break;
    					case 2:
    						//Error al crear el usuario
    						$("#msg-error").removeClass("d-none");
        					$("#btnUpload").removeClass("d-none");
        					$("#btnDownload").addClass("d-none");
        					$("#web-cli").text("No Activado");
    						break;
					}
				}
			});
		}

		function deactCliente(){
			var Cliente = $("#code-cli").text();
			$.ajax({
				type: 'POST',
				dataType: "json",
				url: './vta/tnd_deactCliente.php',
				data: {
					cardcode: Cliente
				},
				success: function(resp){
					$("#msg-noOK").removeClass("d-none");
					$("#btnUpload").removeClass("d-none");
					$("#btnDownload").addClass("d-none");
					$("#web-cli").text("No Activado");
				}
			});
		}
    </script>

</div>