<?php
    include("./lib/nusoap/0.9.5/nusoap.php");
    $client = new nusoap_client('https://tienda.jriveros.cl/jrws/tndWS.php?wsdl','wsdl');
    $param = array();
    $items = $client->call('getSKUProductos', $param);
    $listaItems = array();
    foreach($items as $item){
        $listaItems[] = $item['sku'];
    }
    $lista = "'".implode("','",$listaItems)."'";
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script type="text/javascript">
	$(document).ready(function() {
		var table = $('#listaPrecios').removeAttr('width').DataTable({
		 	dom: 'Brtip',
		  buttons: ['excel'],
				scrollY: '50vh',
				scrollX: '100%',
		  scrollCollapse: true,
				fixedHeader: false,
				"ordering": false,
		  paging: false,
				"pageLength": 100,
				responsive: true,
				"autoWidth": false,
				"language": {
		  	"info": "Registros visualizados: _TOTAL_ de _MAX_",
					"search": "Buscar:",
					"zeroRecords": "No se han encontrado registros",
					"decimal": ",",
			  	"thousands": ".",
					"paginate": {
				    "first":      "Primera",
			      "last":       "Ultima",
			      "next":       "Siguiente",
			      "previous":   "Anterior"
		  	}
		  }
		});
	});
</script>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	      <h5 class="card-title">Actualizaci&oacute;n Masiva de Precios</h5>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row">
    	    		<div class="col-md-6 col-lg-6 col-sm-12">
    					<span class="d-none">Fecha de lista: </span>
    					<span class="d-none">fecha</span>
    	    		</div>
    	    		<div class="col-md-6 col-lg-6 col-sm-12 text-end">
    					<button class="btn btn-sm btn-success" onClick="updPrices();"><i class="fa fa-cloud-upload" aria-hidden="true"></i> Actualizar Productos Tienda</button>
    	    		</div>
    	    	</div>
    	    	<div class="row py-2">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
    					<table class="table table-hover table-sm table-striped" id="listaPrecios">
    						<thead>
    							<tr>
    								<th class="text-center" width="5%">ItemCode</th>
    								<th class="text-center" width="40%">Descripci&oacute;n</th>
    								<th class="text-center" width="5%">Stock</th>
    								<th class="text-center" width="12%">Cliente Final (Oficial)</th>
    								<th class="text-center" width="12%">Desc. Especial 30 D&iacute;as</th>
    								<th class="text-center" width="12%">Desc. Especial Transferencia</th>
    								<th class="text-center" width="14%">Estado</th>
    							</tr>
    						</thead>
    						<tbody>
    							<?php
        							$qrylistaprod = "SELECT ItemCode, ItemName, CodeBars, Stock, [1], [35], [36]
                                        FROM (
                                        	SELECT a.ItemCode, a.ItemName, a.CodeBars, (b.OnHand - b.IsCommited)[Stock], c.PriceList, c.Price
                                        	FROM OITM a
                                        		INNER JOIN OITW b on a.ItemCode = b.ItemCode AND b.WhsCode = '1'
                                        		INNER JOIN ITM1 c on a.ItemCode = c.ItemCode AND c.PriceList IN (1, 35, 36)
                                        	WHERE a.ItemCode IN ($lista)
                                        ) tabla
                                        PIVOT (
                                        	max(Price)
                                        	FOR PriceList IN ([1], [35], [36])
                                        ) pvt
                                        order by ItemCode";
        							$params = array();
        							$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
        							$stmt = sqlsrv_query($GLOBALS['conn'], $qrylistaprod , $params, $options);
        							while($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
    							    ?>
    							    <tr>
    							    	<td class="text-start"><?=$fila['ItemCode'] ?></td>
    							    	<td class="text-start"><?=utf8_encode($fila['ItemName']) ?></td>
    							    	<td class="text-end"><?=number_format($fila['Stock'], 0, ',','.') ?></td>
    							    	<td class="text-end">$ <?=number_format($fila['1'], 0, ',','.') ?></td>
    							    	<td class="text-end">$ <?=number_format($fila['35'], 0, ',','.') ?></td>
    							    	<td class="text-end">$ <?=number_format($fila['36'], 0, ',','.') ?></td>
    							    	<td class="text-center" id="tblEstado<?=$fila['ItemCode'] ?>"></td>
    							    </tr>
    							    <?php
    							}
    							?>
    						</tbody>
    					</table>
    	    		</div>
    	    	</div>
    	    </div>
    	</div>
	</div>
</div>
<script>
	function updPrices(){
		var filas = $('#listaPrecios tbody tr').length;
		var progreso = 100/filas;
		var avance = 0;
		var cuenta = 0;
		$('#modalCarga').modal('show');
		$('#total').text(filas);
        //reset progress bar
        $('#barra-pr').css('width', '0%');
        $('#barra-pr').text('0%');
        $('#barra-pr').attr('aria-valuenow', '0');

		$('#listaPrecios tbody tr').each(function (){
			var item = $(this).find('td:first-child').text();
			var stock = $(this).find('td:nth-child(3)').text().replace(".","");
			var precio1 = $(this).find('td:nth-child(4)').text().replace("$ ","").replace(".","");
			var precio2 = $(this).find('td:nth-child(5)').text().replace("$ ","").replace(".","");
			var precio3 = $(this).find('td:nth-child(6)').text().replace("$ ","").replace(".","");

			$.ajax({
				async:true,
                cache:false,
			    type: 'post',
			    url: './vta/tnd_updActPrecios.php',
			    data: {
			      codItem : item,
			      stk: stock,
			      prc1: precio1,
			      prc2: precio2,
			      prc3: precio3
			    },
			    success: function (resp) {
				    if(resp == '0'){
				    	$('#tblEstado'.item).text('Producto no procesado');
				    } else if (resp == '1') {
					    $('#tblEstado'+item).text('Procesado');
				    } else if (resp == '2') {
						alert("Error de conexin a la tienda\rIntente nuevamente.");
						return;
				    } else if (resp == '3') {
				    	$('#tblEstado'.item).text('Error al procesar');
				    } else if (resp == '4') {
				    	$('#tblEstado'.item).text('Producto no existente');
				    }
					cuenta++;
					avance = avance + progreso;
					if(cuenta == filas){
						avance = 100;
					}
					$('#barra-pr').css('width', avance+'%');
		            $('#barra-pr').text(avance.toFixed(2) + '%');
		            $('#barra-pr').attr('aria-valuenow', avance);
		            $('#cuenta').text(cuenta);
		            if (avance == 100) {
		            	$('#modalCarga').modal('hide');
		            }
			    }
			});
		});

	}
</script>