<?php
    date_default_timezone_set('UTC');
    setlocale(LC_ALL, "es_CL.UTF-8");
    $mes = strftime("%B de %Y");
    $datos = fn_getGrafStockFilNac();
    $factores = fn_getUltimoFactorStockFilNac();
    $stkactual = fn_getStockFilNacActual();
    $buffer = fn_getSumaBufferVtaStockFilNac();
    $fmi = 0;
    $fma = 0;
    $dias = array();
    $stock = array();
    $buff_min = array();
    $buff_max = array();
    while ($fila = $datos->fetch_assoc()){
        array_push($dias, $fila['fecha']);
        array_push($stock, intval($fila['stock']));
        array_push($buff_min, intval($buffer*$fila['factor_min']));
        array_push($buff_max, intval($buffer*$fila['factor_max']));
    }
    if (isset($_GET['fmi'])){
        $fmi = $_GET['fmi'];
    } else {
        $fmi = $factores['factor_min'];
    }
    if (isset($_GET['fma'])){
        $fma =$_GET['fma'];
    } else {
        $fma = $factores['factor_max'];
    }
    array_push($dias, date('d-m'));
    array_push($stock, intval($stkactual));
    array_push($buff_min, intval($buffer*$fmi));
    array_push($buff_max, intval($buffer*$fma));
?>
<script>
function newCalc(){
	var fmi = $('#fact_min').val();
	var fma = $('#fact_max').val();

	$.ajax({
	    type: 'GET',
	    url: 'api/hlp/hlpGuardaGraficoVentasDia.php',
	    data: {
	      fmi : fmi,
	      fma : fma
	    },
	    success: function (data) {
	    	$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&fmi='+fmi+'&fma='+fma);
	    }
	  });
}
</script>
<div class="row">
    <div class="col-md-10 col-lg-10 col-sm-12 offset-md-1 offset-lg-1">
        <div class="card">
            <div class="card-header bg-success">
            	<h5 class="card-title">Stock Filtros Nacionales</h5>
            </div>
            <div class="card-body">
                	<?php
                        if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])) {
                    ?>
                <div class="row d-flex align-items-end">
                    <div class="col-md-2 col-lg-2 col-sm-6 offset-md-3 offset-lg-3">
                        <label for="fact_min" class="col-form-label">Factor M&iacute;nimo</label>
                        <input type="number" class="form-control form-control-sm" id="fact_min" min="0" step="0.1" value="<?=$fmi ?>">
                    </div>
                    <div class="col-md-2 col-lg-2 col-sm-6">
                        <label for="fact_max" class="col-form-label">Factor M&aacute;ximo</label>
                        <input type="number" class="form-control form-control-sm" id="fact_max" min="0" step="0.1" value="<?=$fma ?>">
                    </div>
                    <div class="col-md-2 col-lg-2 col-sm-12">
                    	<button class="btn btn-success btn-sm align-middle" onClick="newCalc();"><i class="fa fa-calculator" aria-hidden="true"></i> Calcular</button>
                    </div>
                </div>
                    <?php
                    	}
                    ?>
                <div class="row py-3">
                    <div class="col-md-12 col-lg-12 col-sm-12">
                    	<div id="container"></div>
                    </div>
                </div>
                <?php
                    $totindica = fn_totindica();
                    $linea = sqlsrv_fetch_array( $totindica, SQLSRV_FETCH_ASSOC);
                    $VtaEspMensual = $linea['VtaEspMensual'];
                    $VtaPotM1 = $linea['VtaPotM1'];
                    $TotalCerosXLinea15 = $linea['TotalCerosXLinea15'];
                    $stklindisp = fn_stockxlineadisp($VtaEspMensual);
                    $ItemStockCero = 0;
                    $CantItem = 0;
                    while($row11 = sqlsrv_fetch_array( $stklindisp, SQLSRV_FETCH_ASSOC)){
                        $ItemStockCero +=  $row11['ItemStockCero'];
                        $CantItem += $row11['CantItem'];
                    }
                ?>
                <div class="row">
                    <div class="col-md-4 col-lg-4 col-sm-12 text-center">
						<p><strong>Items Sin Stock: <?=$ItemStockCero?></strong></p>
                    </div>
                    <div class="col-md-4 col-lg-4 col-sm-12 text-center">
						<p><strong>Estimaci&oacute;n Venta Perdida 30 dias: $ <?=number_format($VtaPotM1, 0, ',', '.')?></strong></p>
                    </div>
                    <div class="col-md-4 col-lg-4 col-sm-12 text-center">
						<p><strong>Prioridad Corte 15 dias: <?=number_format($CantItem - $TotalCerosXLinea15, 0, ',', '.')?></strong></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
Highcharts.chart('container', {
	  chart: {
	    zoomType: 'xy'
	  },
	  title: {
	    text: '<?=ucfirst($mes) ?>',
	    align: 'center'
	  },
	  xAxis: [{
	    categories: <?=json_encode($dias) ?>,
	    crosshair: true
	  }],
	  yAxis: [{ // Primary yAxis
	    title: {
	      text: ''
	    },
	    min: 0,
	    max: 500000,
	    visible: false
	  }, { // Secondary yAxis
	    title: {
	      text: 'Stock'
	    },
	    min: 0,
	    max: 500000,
	    opposite: false
	  }],
	  tooltip: {
	    shared: true
	  },
	  legend: {
	    floating: false,
	    backgroundColor:
	      Highcharts.defaultOptions.legend.backgroundColor || // theme
	      'rgba(255,255,255,0.25)'
	  },
	  series: [
		  {
	    name: 'Stock',
	    type: 'column',
	    yAxis: 1,
	    data:<?=json_encode($stock) ?>
	  },
	  {
	    name: 'Meta Minima',
	    type: 'spline',
	    color: 'rgb(255,0,0)',
	    marker: {
	        enabled: false,
	        states: {
	          hover: {
	            enabled: true
	          }
	        }
	      },
	    data: <?=json_encode($buff_min) ?>
	  },
	  {
	    name: 'Meta Maxima',
	    type: 'spline',
	    color: 'rgb(0,0,0)',
	    marker: {
	        enabled: false,
	        states: {
	          hover: {
	            enabled: true
	          }
	        }
	      },
	    data: <?=json_encode($buff_max) ?>
	  }]
	});
</script>