<script>
$(document).ready(function() {

	$("#txtCodigo").autocomplete({
      	source: function(request, response) {
          	$.ajax({
              	url: "./api/buscaritem_cod.php",
              	dataType: "json",
              	data: {
                  	term: request.term
              	},
              	success: function(data) {
                  	response(data);
              	}
          	});
      	},
      	minLength: 2,
      	select: function(event, ui) {
      		var prod = ui.item;
      		limpia();
      		$('#txtCodigo').val(prod.ItemCode);
      		$('#txtCodHid').val(prod.ItemCode);
      		$('#txtDescr').val(prod.producto);
      		busca();
          	return false;
      	},
      	open: function() {
          	$(this).removeClass("ui-corner-all").addClass("ui-corner-top");
      	},
      	close: function() {
          	$(this).removeClass("ui-corner-top").addClass("ui-corner-all");
      	}
  	});
  	$('#txtCodigo').data("ui-autocomplete")._renderItem = function(ul, item) {
      	return $("<li>").append("<a>" + item.ItemCode +  "</a>").appendTo(ul);
  	};

  	$("#txtDescr").autocomplete({
      	source: function(request, response) {
          	$.ajax({
              	url: "./api/buscaritem_desc.php",
              	dataType: "json",
              	data: {
                  	term: request.term
              	},
              	success: function(data) {
                  	response(data);
              	}
          	});
      	},
      	minLength: 2,
      	select: function(event, ui) {
      		var prod = ui.item;
      		limpia();
      		$('#txtCodigo').val(prod.ItemCode);
      		$('#txtCodHid').val(prod.ItemCode);
      		$('#txtDescr').val(prod.producto);
      		busca();
          	return false;
      	},
      	open: function() {
          	$(this).removeClass("ui-corner-all").addClass("ui-corner-top");
      	},
      	close: function() {
          	$(this).removeClass("ui-corner-top").addClass("ui-corner-all");
      	}
  	});
  	$('#txtDescr').data("ui-autocomplete")._renderItem = function(ul, item) {
      	return $("<li>").append("<a>" + item.producto +  "</a>").appendTo(ul);
  	};
  	$("[id^='ui-id-']").css('z-index', '9999');
	$('#datosFiltro').addClass('d-none');
});
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	      <h5 class="card-title">Ficha de Producto</h5>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row">
    	    		<form id="buscaFiltro" method="POST" action="./vta/slv_respProdCard.php">
        	    		<div class="col-md-12 col-lg-12 col-sm-12">
        					<div class="row py-1">
                	    		<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="txtCodigo" class="label-form">C&oacute;d. Interno: </label>
                	    		</div>
                	    		<div class="col-md-2 col-lg-2 col-sm-12">
                	    			<input type="text" id="txtCodigo" class="form-control form-control-sm form-control-input">
                	    			<input type="hidden" id="txtCodHid" name="txtCodHid">
                	    		</div>
                	    		<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="txtDescr" class="label-form">Descripci&oacute;n: </label>
                	    		</div>
                	    		<div class="col-md-8 col-lg-8 col-sm-12">
                	    			<input type="text" id="txtDescr" class="form-control form-control-sm form-control-input">
                	    		</div>
                	    	</div>
                	    	<div class="row py-1 d-none">
								<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="cboMarca" class="label-form">Marca: </label>
                	    		</div>
                	    		<div class="col-md-2 col-lg-2 col-sm-12">
                	    			<input type="text" id="cboMarca" class="form-control form-control-sm form-control-input">
                	    		</div>
                	    		<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="cboModelo" class="label-form">Modelo: </label>
                	    		</div>
                	    		<div class="col-md-2 col-lg-2 col-sm-12">
                	    			<input type="text" id="cboModelo" class="form-control form-control-sm form-control-input">
                	    		</div>
                	    		<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="cboVersion" class="label-form">Versi&oacute;n: </label>
                	    		</div>
                	    		<div class="col-md-2 col-lg-2 col-sm-12">
                	    			<input type="text" id="cboVersion" class="form-control form-control-sm form-control-input">
                	    		</div>
                	    		<div class="col-md-1 col-lg-1 col-sm-12">
									<label for="cboAnnio" class="label-form">A&ntilde;o: </label>
                	    		</div>
                	    		<div class="col-md-2 col-lg-2 col-sm-12">
                	    			<input type="text" id="cboAnnio" class="form-control form-control-sm form-control-input">
                	    		</div>
                	    	</div>
                	    	<div class="row py-1">
                	    		<div class="col-md-4 col-lg-4 col-sm-12 offset-md-4 offset-lg-4">
                	    			<div class="row">
                	    				<div class="col text-center d-none">
                	    					<button type="submit" class="btn btn-sm btn-success"><i class="fa fa-search" aria-hidden="true"></i> Buscar</button>
                	    				</div>
                	    				<div class="col text-center">
											<button type="reset" class="btn btn-sm btn-danger" onClick="limpia();"><i class="fa fa-eraser" aria-hidden="true"></i> Limpiar</button>
                	    				</div>
                	    			</div>
                	    		</div>
                	    	</div>
        	    		</div>
    	    		</form>
    	    	</div>
    	    	<div class="row"  id="datosFiltro">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
            	    	<hr>
            	    	<div class="row">
            	    		<div class="col-md-12 col-lg-12 col-sm-12">
    							<div class="row py-1">
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold">C&oacute;digo</span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span id="itemcode"></span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold">C&oacute;d. Alternativo</span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span id="codebars"></span>
    								</div>
    							</div>
    							<div class="row py-1">
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold">Descripci&oacute;n</span>
    								</div>
    								<div class="col-sm-12 col-md-10 col-lg-10">
    									<span id="itemname"></span>
    								</div>
    							</div>
    							<div class="row py-1">
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold text-capitalize">Procedencia</span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span id="u-desc1"></span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold">Stock</span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span id="stock" class="fs-6 fw-bold"></span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span class="fw-bold">M&uacute;ltiplo Venta</span>
    								</div>
    								<div class="col-sm-12 col-md-2 col-lg-2">
    									<span id="u-min" class="fs-6 fw-bold"></span>
    								</div>
    							</div>
    							<div class="row py-1">
    								<div class="col-md-10 col-lg-10 col-sm-12 offset-md-1 offset-lg-1">
    									<table class="table table-sm table-hover table-striped" id="listaPrecios">
    										<thead>
    											<tr>
    												<th>Lista de Precios</th>
    												<th>Descripci&oacute;n</th>
    												<th>Precio Neto</th>
    											</tr>
    										</thead>
    										<tbody></tbody>
    									</table>
									</div>
    							</div>
            	    		</div>
            	    	</div>
            	    </div>
            	</div>
    	    </div>
   		</div>
	</div>
</div>
<script>
	function busca() {
    	$.ajax({
            type: $('#buscaFiltro').attr('method'),
            url: $('#buscaFiltro').attr('action'),
            data: $('#buscaFiltro').serialize(),
            dataType: "json",
            success: function (data) {
                if(data.resultado == 1){
            		$('#datosFiltro').removeClass('d-none');
            		var cab = data.cabecera;
					$('#itemcode').text(cab.ItemCode);
					$('#codebars').text(cab.CodeBars);
					$('#itemname').text(cab.ItemName);
					$('#u-desc1').text(cab.U_Descripcion1);
					if(isNaN(parseInt(cab.Stock))){
						$('#stock').text('0');
						$('#stock').removeClass('text-success');
						$('#stock').addClass('text-danger fw-bold');
					} else {
						$('#stock').text(parseInt(cab.Stock));
						$('#stock').removeClass('text-danger');
						$('#stock').addClass('text-success fw-bold');
					}
					$('#u-min').text(cab.U_Minimo);

					var list = data.lista;
					for (var lista of list){
						var valor = parseInt(lista.Price);
						var valCL = new Intl.NumberFormat("es-CL").format(valor);
						if(lista.PriceList == 1){
							$('#listaPrecios tbody').append('<tr><td>'+lista.PriceList+'</td><td>'+lista.ListName+'</td><td class="text-end">$ '+valCL+'</td></tr>');
							$('#listaPrecios tbody').append('<tr><td colspan="3" class="text-start"><button id="btnCOPEC" class="btn btn-sm btn-success" onClick="muestraCOPEC();">Clientes con convenio COPEC</button></td></tr>');
						} else {
							$('#listaPrecios tbody').append('<tr id="prc'+lista.PriceList+'" class="d-none"><td>'+lista.PriceList+'</td><td>'+lista.ListName+'</td><td class="text-end">$ '+valCL+'</td></tr>');
						}
					}
                } else {

                }
        	}
        });
    };

    function muestraCOPEC(){
    	var linea = $("[id^='prc']");
    	if(linea.hasClass('d-none')){
			linea.removeClass('d-none');
			$('#btnCOPEC').text('Ocultar');
    	} else {
			linea.addClass('d-none');
			$('#btnCOPEC').text('Clientes con convenio COPEC');
    	}
    };

	function limpia(){
		$('#datosFiltro').addClass('d-none');
		$('#itemcode').text('');
		$('#codebars').text('');
		$('#itemname').text('');
		$('#u-desc1').text('');
		$('#stock').text('');
		$('#stock').removeClass('text-success text-danger fw-bold');
		$('#u-min').text('');
		$('#listaPrecios tbody tr').remove();
		$('#btnCOPEC').text('Clientes con convenio COPEC');
	};
</script>