<?php
    ob_start();
    include_once('../lib/dompdf/autoload.inc.php');
    use Dompdf\Dompdf;
    use Dompdf\Exception as DOMException;
    date_default_timezone_set("America/Santiago");
    setlocale(LC_TIME, 'es_CL','esp');
	$DateAndTime = date('d-m-Y h:i:s a', time());
	$FechaActual = date('d-m-Y', time());
	//$slpmail = $_SESSION['Email'];
	$idcot = $_POST['idcot'];
	include("../api/conn.php");
	$conn = ConnIntra();
	$connMS = Connect();
	$tsql = "SELECT T0.razonsocial, T0.rut, T0.fecha, T0.totalcot, T1.Name, T0.vendedor, T0.cardcode, T0.Discount, T0.correo, T0.Despacho
		FROM cotiza_cab T0 LEFT OUTER JOIN vendors T1 ON T0.vendedor = T1.SlpCode WHERE T0.id = $idcot";
	$res = $conn->query($tsql);
	$row = $res->fetch_assoc();
	$date = date_create($row['fecha']);
	$cardcode = $row['cardcode'];
	$Discount = $row['Discount'];
	$rut = $row['rut'];
	$correoCli = $row['correo'];
	$Despacho = $row['Despacho'];
	$qry = "SELECT T0.CardCode,(SELECT TOP 1 T1.Street + ' ' + T1.County + ' ' + T1.City FROM CRD1 T1
		WHERE T1.CardCode = T0.CardCode AND T1.Address = '$Despacho')[FAC1], (SELECT TOP 1 T2.FirstName FROM OCPR T2
		WHERE T2.Active = 'Y' AND T2.CardCode = T0.CardCode ORDER BY T2.CntctCode ASC)[CONT1]
		FROM OCRD T0 WHERE T0.CardType = 'C' AND T0.CardCode = '$cardcode'";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$resultados = sqlsrv_query( $connMS, $qry , $params, $options );
	$fac1 = '';
	$cont1 = '';
	if(sqlsrv_num_rows($resultados) > 0){
	   $rs = sqlsrv_fetch_array($resultados, SQLSRV_FETCH_ASSOC);
	   $fac1 = $rs['FAC1'];
	   $cont1 = $rs['CONT1'];
	}
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<style><?=include_once '../lib/bootstrap/css/bootstrap.min.css';?></style>
		<style type="text/css">
			html {
			  margin: 0;
			}
			body {
			  font-family: "Times New Roman", serif;
			  margin: 4mm 4mm 4mm 4mm;
			}
			body,td,th {
			    font-size: 12px;
			}
			#footer {
			  position:fixed;
			  bottom: 30px;
			  left: 10px;
			  right: 5px;
			  height: 100px;
			  text-align: left;
			  background-color: white;
			  border-top: 2px solid gray;
			}
			.pagenum:before {
			  content: counter(page);
			}
			.page-break {
			        page-break-after: always;
			    }
			table.paginas {page-break-inside: auto;}
		</style>
	</head>
	<body>
		<table width="700" border="0" align="center" cellpadding="0" cellspacing="0">
			<tr>
				<td align="left">
					<table width="100%" border="0">
					  <tbody>
					    <tr>
					      <td width="11%">&nbsp;</td>
					      <td width="89%">&nbsp;</td>
				      </tr>
					    <tr>
					      <td>CLIENTE:</td>
					      <td>&nbsp;<strong><?=utf8_encode($row['razonsocial'])?></strong></td>
				      </tr>
					    <tr>
					      <td>RUT:</td>
					      <td>&nbsp;<strong><?=$row['rut']?></strong></td>
				      </tr>
					    <tr>
					      <td>CONTACTO:</td>
					      <td>&nbsp;<strong><?=utf8_encode($cont1)?></strong></td>
				      </tr>
					    <tr>
					      <td>DIRECCION:</td>
					      <td>&nbsp;<strong><?=$fac1?></strong></td>
				      </tr>
					    <tr>
					      <td>VENDEDOR:</td>
					      <td>&nbsp;<strong><?=$row['Name']?></strong></td>
				      </tr>
					    <tr>
					      <td>FECHA:</td>
					      <td>&nbsp;<strong><?=date_format($date, 'd-m-Y')?></strong></td>
				      </tr>
				    </tbody>
				  </table>
				</td>
				<td width="41%" align="center">
					<strong>
						<h1>COTIZACION #&nbsp;<?=$idcot?></h1>
					</strong>
				</td>
			  <td width="30%" align="right">
					<p>
						<img src="./logo75_2.png" width="200" height="78" alt=""/>
					</p>
			    <p>
						<img src="./logo_mann_filter.png" width="200" height="96" alt=""/>
					</p>
				</td>
			</tr>
			<tr>
			  <td colspan="3" align="center"></td>
		  </tr>
		</table>
		<table width="700" border="1" align="center" cellpadding="0" cellspacing="0" class="paginas">
			<thead>
				<tr>
				  	<th width="67" height="35" align="center">#</th>
					<th width="87" align="center">Código</th>
					<th width="287" align="center">Descripción</th>
					<th width="86" align="center">Cantidad</th>
					<th width="87" align="center">P.Unitario</th>
					<th width="72" align="center">Total</th>
				</tr>
			</thead>
			<tbody>
				<?php
					$tsql2 = "SELECT T0.* FROM cotiza_det T0 WHERE T0.idcot = $idcot order by LineNum asc";
					$res2 = $conn->query($tsql2);
					$num = 1;
					while($row2 = $res2->fetch_assoc()) {
				?>
				<tr>
					<td height="16" align="center"><?=$num?></td>
					<td align="center"><?=$row2['ItemCode']?></td>
					<td align="left"><?=utf8_encode($row2['ItemName'])?></td>
					<td align="right"><?=number_format($row2['Cantidad'], 0, ',', '.')?>&nbsp;</td>
				    <td align="right"><?=number_format($row2['Precio'], 0, ',', '.')?>&nbsp;</td>
				    <td align="right"><?=number_format($row2['Cantidad']*$row2['Precio'], 0, ',', '.')?>&nbsp;</td>
				</tr>
						<?php
							$num = $num +1;
					}
				?>
			</tbody>
		</table>
		<br>
		<table width="700" border="1" align="center" cellpadding="0" cellspacing="0" >
			<tbody>
				<?php
					$tsql20 = "SELECT T0.* FROM cotiza_det T0 WHERE T0.idcot = $idcot";
					$res20 = $conn->query($tsql20);
					$subtotal = 0;
					while($row20 = $res20->fetch_assoc())	{
						$subtotal = $subtotal + ($row20['Cantidad']*$row20['Precio']);
					}
					$tsql_1 = "SELECT CardCode FROM OCRD WHERE CardType = 'C' AND LicTradNum LIKE '%$rut%' ";
					$params = array();
					$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
					$query = sqlsrv_query($connMS, $tsql_1 , $params, $options);
					$row_count = sqlsrv_num_rows($query);
				?>
    			<tr>
    			    <td width="441" rowspan="5" align="left">
    					<p>-Cotizaci&oacute;n v&aacute;lida por 2 dias</p>
    					<p>-Cotización no incluye fletes
    							<?php
    								if($row_count == 0){
    							?>
    		        	ni descuentos asociados a forma de pago</p>
    							<?php
    							  }
    							?>
    				</td>
    			    <td width="173" align="right">SUB TOTAL</td>
    			    <td width="72" align="right">$ <?=number_format($subtotal, 0, ',', '.')?></td>
    		    </tr>
    			<tr>
    			    <td align="right">DESCUENTO (<?=number_format($Discount, 0, ',', '.')?>%)</td>
    			    <td align="right">$ <?=number_format(($subtotal * ($Discount/100)), 0, ',', '.')?></td>
    		    </tr>
    				<?php
    					$TotalNeto = ($subtotal - ($subtotal * ($Discount/100)));
    				?>
    			<tr>
    			    <td align="right">TOTAL NETO</td>
    			    <td align="right">$ <?=number_format($TotalNeto, 0, ',', '.')?></td>
    		    </tr>
    			<tr>
    			    <td align="right">IVA</td>
    			    <td align="right">$ <?=number_format(($TotalNeto*19)/100, 0, ',', '.')?></td>
    		    </tr>
    			<tr>
    			    <td align="right">TOTAL</td>
    			    <td align="right">$ <?=number_format($TotalNeto+(($TotalNeto*19)/100), 0, ',', '.')?></td>
    		    </tr>
			</tbody>
		</table>
	</body>
</html>
<?php
	$html = ob_get_clean();
	//echo $html;
	include '../lib/phpmailer/PHPMailerAutoload.php';
	// creo el objeto phpmailer
	$mail = new phpmailer();
	// asigno el envío por SMTP mucho más rápido y fiable
	$mail->Mailer = "smtp";
	// mi servidor requiere autentificación
	$mail->SMTPAuth = true;
	// utilizo constantes almacenadas fuera del script para darle más seguridad a los datos, aparte de así poder reutilizar los mismos
	$mail->CharSet = 'UTF-8';

	$mail->SMTPAuth = true;
	$mail->SMTPSecure = 'tls'; //seguridad
	$mail->Port = 587; //puerto

//	$mail->Username = 'jriverosdomain@gmail.com';
	$mail->Username = 'info@jriveros.cl';
	$mail->Host = 'smtp.gmail.com';
	$mail->Password = 'ReRoute,4,#2';
	$mail->setFrom('info@jriveros.cl','JRIVEROS - Cotizacin');


	// aumentar el timeout es recomendable si estas en un hosting gratuito
	$mail->Timeout=30;
	// creo el objeto DOMPDF

	$dompdf = new Dompdf();
	$options = $dompdf->getOptions();
	$options->set('isHtml5ParserEnabled', true);
	$options->set('isRemoteEnabled', TRUE);
	$options->set('isPhpEnabled', true);	//esto no hace nada
	$dompdf->setOptions($options);
	$dompdf->setPaper('letter','Landscape');
	$dompdf->loadHtml($html);
	$dompdf->render();
	$archivo = $dompdf->output();
	$nombre_archivo = "jrcotizacion ".$idcot.".pdf";

	file_put_contents('../tmp/'.$nombre_archivo, $archivo);
	// las siguientes 2 lineas son imprescindibles si envias varios correos a la vez, por ejemplo dentro de un bucle while, así garantizas que solo se envíe este fichero al recipiente de correo destinatario

	$mail->ClearAllRecipients();
	$mail->ClearAttachments();

	// añado el usuario de destino y otras configuraciones

//	$mail->addBCC('luis.perez@jriveros.cl');
//  $mail->AddAddress('juan.corral@jriveros.cl');
//	$mail->AddAddress('hugo.munizaga@jriveros.cl');
	//$mail->AddAddress($slpmail);
	$mail->AddAddress($correoCli);
	$mail->Subject = "JRiveros - Cotización #".$idcot;
	$mail->Body = 'Se Adjunta Cotización #'.$idcot;

	// nombre_adjunto es el nombre que verá el usuario cuando reciba el mail como nombre del archivo
	$mail->AddAttachment('../tmp/'.$nombre_archivo, $nombre_archivo);
	// texto alternativo por si el usuario no admite html

	$mail->AltBody = " ";

	$exito = $mail->Send();

	unlink('../tmp/'.$nombre_archivo);
	if(!$exito){
	    echo $correoCli;
		echo "Problemas enviando correo electrónico";
		echo "
		".$mail->ErrorInfo;
		$final[] = array('idcot' => $idcot, 'enviado'=>0);
	} else {
	    $final[] = array('idcot' => $idcot, 'enviado'=>1);
	}
	return json_encode($final);
?>