<?php
$data1 = fn_getRotacionVentas();
$cabeceras = array();
$datos = array();
while($fila = $data1->fetch_assoc()){
    $datInner = array();
    foreach($fila as $key => $value){
        if (!in_array($key, $cabeceras, true)){
            array_push($cabeceras, trim($key));
        }
        if (is_numeric($value)){
            array_push($datInner, $value);
        }
    }
    $datos[$fila['Linea']]= $datInner;
}

$mg = fn_getMargenesVentas();
$cabmar = array();
$datmar = array();
while($filamg = sqlsrv_fetch_array( $mg, SQLSRV_FETCH_ASSOC)){
    $datInner = array();
    foreach($filamg as $key => $value){
        if (!in_array($key, $cabmar, false)){
            array_push($cabmar, trim($key));
        }
        if (is_null($value)){
            $value = 0;
        }
        if (is_numeric($value)){
            array_push($datInner, $value);
        }
    }
    $datmar[$filamg['Linea']]= $datInner;
}
?>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12 ">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	      <h5 class="card-title">M&aacute;rgenes y Rotaci&oacute;n</h5>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row py-1">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
    	    			<div class="card">
                    	    <div class="card-header bg-success">
                    	      <h5 class="card-title">Rotaci&oacute;n</h5>
                    	    </div>
                    	    <div class="card-body">
        						<table class="table table-sm table-hover table-striped">
        							<thead>
                						<tr>
                							<?php
                							foreach($cabeceras as $item){
                							?>
                    						<th class="text-center"><?=ucfirst(utf8_encode(trim($item))) ?></th>
                    						<?php
                							}
                							?>
                						</tr>
                					</thead>
                					<tbody>
                					<?php
        								foreach($datos as $linea => $contenido){
        						    ?>
                						<tr>
        					    			<th class="text-start"><?=$linea ?></th>
        					    			<?php
        					    			foreach($contenido as  $value){
        					    			  ?>
        					    			<td class="text-center"><?=number_format($value, 2, ',', '.') ?></td>
        					    			  <?php
        					    			}
        					    			?>
        					    		</tr>
        					    		<?php
        									}
        								?>
                					</tbody>
        						</table>
        					</div>
        				</div>
    	    		</div>
    	    	</div>
    	    	<div class="row py-1">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
    	    			<div class="card">
                    	    <div class="card-header bg-success">
                    	      <h5 class="card-title">M&aacute;rgenes</h5>
                    	    </div>
                    	    <div class="card-body">
        						<table class="table table-sm table-hover table-striped">
        							<thead>
                						<tr>
                						<?php
                						    foreach($cabmar as $item){
                							?>
                    						<th class="text-center"><?=ucfirst(utf8_encode(trim($item))) ?></th>
                    						<?php
                							}
                							?>
                						</tr>
                					</thead>
                					<tbody>
                						<?php
                						foreach($datmar as $linea => $contenido){
        						    ?>
                						<tr>
        					    			<th class="text-start"><?=$linea ?></th>
        					    			<?php
        					    			foreach($contenido as  $value){
        					    			  ?>
        					    			<td class="text-center"><?=number_format($value, 2, ',', '.') ?></td>
        					    			  <?php
        					    			}
        					    			?>
        					    		</tr>
        					    		<?php
        									}
        								?>
                					</tbody>
        						</table>
        					</div>
        				</div>
    	    		</div>
    	    	</div>
    	    </div>
    	</div>
	</div>
</div>