<?php
    $data1 = fn_getGraficoVentas();
    $datos = array();
    $datInner = array();
    $cabeceras = array();
    $totales_linea = array(0,0,0,0,0,0,0);
    $totales_mes = array(0,0,0,0,0,0,0,0,0,0,0,0);
    while($fila = sqlsrv_fetch_array($data1, SQLSRV_FETCH_ASSOC)){
        $datInner = array();
        foreach($fila as $key => $value){
            if (!in_array($key, $cabeceras, true)){
                array_push($cabeceras, trim($key));
            }
            if (is_numeric($value)){
                array_push($datInner, $value);
            }
        }
        $datos[$fila['Linea']]= $datInner;
    }
?>
<style>
.container{
    width: 100% !important;
}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Ventas Por Categor&iacute;a</h5>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
					<div class="card">
                		<div class="card-content">
                			<div id="grafico1" class="py-3"></div>
            				<div class="row">
            					<div class="col-md-12 col sm-12 col-lg-12 text-center">
            						<div class="highcharts-description">
                        				<table class="table table-sm table-hover table-striped" style="font-size: 12px">
                        					<thead>
                        						<tr>
                        							<?php
                        							foreach($cabeceras as $item){
                        							?>
                            						<th><?=ucfirst(utf8_encode(trim($item))) ?></th>
                            						<?php
                        							}
                        							?>
                        							<th>Total</th>
                        							<th>%</th>
                        						</tr>
                        					</thead>
                        					<tbody>
											<?php
											    $guia = 0;
    											foreach($datos as $linea => $contenido){
    											    $sum = 0;
    											    for ($ind = 0; $ind <= 11; $ind++){
    											        $totales_mes[$ind] += $contenido[$ind];
    											    }
										    ?>
										    		<tr>
										    			<th><?=$linea ?></th>
										    			<?php
										    			foreach($contenido as  $value){
										    			  ?>
										    			  	<td><?=number_format($value, 0, ',', '.') ?></td>
										    			  <?php
										    			  $sum += $value;
										    			}
										    			$totales_linea[$guia] += $sum;

										    			?>
										    			<th><?=number_format($totales_linea[$guia], 0, ',', '.') ?></th>
										    			<td id="part<?=$guia?>"></td>
										    		</tr>
										    <?php
										            $guia++;
    											}
											?>
                        					</tbody>
                        					<tfoot>
                        						<tr>
                        							<th>Totales</th>
                        							<?php
                        							$total_completo = 0;
                        							for ($x=0;$x<=11;$x++){
                        							    echo '<th>'.number_format($totales_mes[$x], 0, ',', '.').'</th>';
                        							    $total_completo += $totales_mes[$x];
                        							}
                        							?>
                        							<th><?=number_format($total_completo, 0, ',', '.') ?></th>
                        							<th>&nbsp;</th>
                        						</tr>
                        					</tfoot>
                        				</table>
                        			</div>
            					</div>
            				</div>
                		</div>
                	</div>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>
<?php
$data2= fn_getPeriodoGraficoVentas();
$pie = array();
while($fila2 = sqlsrv_fetch_array($data2, SQLSRV_FETCH_ASSOC)){
    array_push($pie, ucfirst($fila2['fa']));
}
?>
<script>
$(document).ready(function(){
	var totlin = <?=json_encode($totales_linea) ?>;
	var totfin = <?=$total_completo ?>;

	for(var x = 0; x<=11;x++){
		var porc = (totlin[x]*100) / totfin;
		$('#part'+x).text(porc.toFixed(1)+' %');
	}

	const contenedor = document.querySelector('#contenedor-ppal');
	contenedor.removeAttribute('class');
	contenedor.setAttribute('class','container-flex p-3');
});
</script>
<script>
	var dat1 = <?= json_encode($datos) ?>;
	var cabe = <?= json_encode($pie) ?>;

	Highcharts.addEvent(Highcharts.Point, 'click', function () {
		if (this.series.options.className.indexOf('popup-on-click') !== -1) {
    	    const chart = this.series.chart;
    	    const date = Highcharts.dateFormat('%A, %b %e, %Y', this.x);
    	    const text = `<b>${date}</b><br/>${this.y} ${this.series.name}`;
    	    const anchorX = this.plotX + this.series.xAxis.pos;
    	    const anchorY = this.plotY + this.series.yAxis.pos;
    	    const align = anchorX < chart.chartWidth - 200 ? 'left' : 'right';
    	    const x = align === 'left' ? anchorX + 10 : anchorX - 10;
    	    const y = anchorY - 30;
    	    if (!chart.sticky) {
    	      	chart.sticky = chart.renderer
    	        	.label(text, x, y, 'callout',  anchorX, anchorY)
    	        	.attr({
    	        		align,
    	        		fill: 'rgba(0, 0, 0, 0.75)',
    	        		padding: 10,
    	        		zIndex: 7 // Above series, below tooltip
    	        	})
    	        	.css({
    		        	color: 'white'
    		    	})
    		    	.on('click', function () {
    		        	chart.sticky = chart.sticky.destroy();
    		    	})
    		    	.add();
    		} else {
    		    chart.sticky
    		    	.attr({ align, text })
    			    .animate({ anchorX, anchorY, x, y }, { duration: 250 });
    		}
    	}
	});

	$(function() {
		var grafico2 = new Highcharts.chart({
			chart: {
			    type: 'column',
			    renderTo: 'grafico1',
			    inverted: false
			},
			title: {
			    text: ''
			},
			xAxis: {
				categories: cabe,
				reversed: false,
				labels: {
					rotation: -30
				}
			},
			yAxis: {
				min: 0,
				reversedStacks: false,
				title: {
					text: 'Venta'
				}
			},
			tooltip: {
		        pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.1f}%)<br/>',
		        shared: true
		    },
			plotOptions: {
			    column: {
				    stacking: 'normal',
				    dataLabels: {
						enabled: false,
						color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
						style: {
							textShadow : '0 0 1px black'
						}
				    }
				}
			}
		});

		for (linea in dat1){
			var datos = [];
	        for(var x = 0;x <= 11; x++){
	        	datos.push(parseInt(dat1[linea][x]));
	        }

	        var poin = new Highcharts.Series();
	        poin = {
	       		name: linea,
	       		data: datos
	       	};
	        grafico2.addSeries(poin);
		}
	    grafico2.redraw();
	});
</script>