<?php
    include("../liblist.php");
    $conn = Connect();
    $qry = "(select a.DocEntry, a.CardCode, a.CardName, b.SlpName, 'FV' TipoDoc, a.FolioNum, a.DocTotal, a.DocDate
                    from OINV a
                    	inner join OSLP b on a.SlpCode = b.SlpCode
                    where a.DocDate = CONVERT(varchar,getdate(),3)  and CANCELED = 'N' and a.FolioNum is not NULL AND a.FolioPref = 'FE'
                    )
                    union
                    (select a.DocEntry, a.CardCode, a.CardName, b.SlpName, 'NC' TipoDoc, a.FolioNum, a.DocTotal, a.DocDate
                    from ORIN a
                    	inner join OSLP b on a.SlpCode = b.SlpCode
                    where a.DocDate = CONVERT(varchar,getdate(),3)  and CANCELED = 'N' and a.FolioNum is not NULL AND a.FolioPref = 'NC'
                    )
                    order by DocEntry desc";
					//echo $qry;
    $params = array();
    $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
    $stmt = sqlsrv_query($conn, $qry , $params, $options);
?>
<div class="modal-header">
	<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header bg-success">
                	<h5 class="card-title">Resumen de Facturaci&oacute;n</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                    	<div class="col-md-12 col-lg-12 col-sm-12">
							<table class="table table-sm table-hover table-striped" id="result-mod">
								<thead>
									<tr>
										<th class="text-center">Folio Doc.</th>
										<th class="text-center">Tipo Doc.</th>
										<th class="text-center">CardCode</th>
										<th class="text-center">Cliente</th>
										<th class="text-center">Total</th>
										<th class="text-center">Vendedor</th>
									</tr>
								</thead>
								<tbody>
    								<?php
    								while($lineas = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
    								?>
									<tr>
										<td class="text-center"><?=number_format($lineas['FolioNum'],0,',','.')?></td>
										<td class="text-center"><?=$lineas['TipoDoc']?></td>
										<td class="text-center"><?=$lineas['CardCode']?></td>
										<td class="text-start"><?=utf8_encode($lineas['CardName'])?></td>
										<td class="text-end">$ <?=number_format($lineas['DocTotal'],0,',','.')?></td>
										<td class="text-start"><?=$lineas['SlpName']?></td>
									</tr>
									<?php
                                    }
                                    ?>
								</tbody>
							</table>
                    	</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>