<?php
    include("../liblist.php");
    $slp = $_GET['slp'];
    date_default_timezone_set("America/Santiago");
    setlocale(LC_TIME, 'es_CL','esp');
?>

<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
    var table = $('#result').removeAttr('width').DataTable({
       	dom: 'rtip',
        buttons: ['excel'],
    	scrollY: '45vh',
    	scrollX: '100%',
        scrollCollapse: true,
    	fixedHeader: false,
    	"ordering": true,
        paging: false,
    	"pageLength": 100,
    	responsive: true,
    	"autoWidth": false,
    	"language": {
        	"info": "Registros visualizados: _MAX_",
    		"search": "Buscar:",
    		"zeroRecords": "No se han encontrado registros",
    		"decimal": ",",
    	  	"thousands": ".",
    		"paginate": {
    		    "first":      "Primera",
        		"last":       "Ultima",
        		"next":       "Siguiente",
        		"previous":   "Anterior"
    		}
        }
    });

    table.columns().every( function () {
        var that = this;
        $( 'input', this.header() ).on( 'keyup change', function () {
        	that
            .search( this.value )
            .draw();
        });
    });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
    tbody td{
        margin-left: 5px;
        margin-right: 5px;
        width: auto;
    }
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		<table id="result" class="display compact stripe hover">
			<thead>
    			<tr>
    				<th class="text-center d-none">C&oacute;digo Vendedor</th>
    				<th class="text-center d-none">Nombre Vendedor</th>
    				<th class="text-center">C&oacute;digo Cliente</th>
    				<th class="text-center">Nombre Cliente</th>
    				<th class="text-center">RUT</th>
    				<th class="text-center">Ciudad</th>
    				<th class="text-center">Comuna</th>
    				<th class="text-center">Direcci&oacute;n</th>
    				<th class="text-center">Tel&eacute;fono 1</th>
    				<th class="text-center">Tel&eacute;fono 2</th>
    				<th class="text-center">Cond. Pago</th>
    				<th class="text-center">Activo</th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-12 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-11 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-10 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-9 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-8 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-7 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-6 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-5 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-4 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-3 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-2 month'))?></th>
    				<th class="text-center text-capitalize"><?=strftime('%h %Y', strtotime('-1 month'))?></th>
    				<th class="text-center">Vta. Prom. 12 Meses</th>
    				<th class="text-center">Vta. Prom. 24 Meses</th>
    				<th class="text-center">Vta. Prom. 36 Meses</th>
    				<th class="text-center">Deuda Vencida</th>
    				<th class="text-center">Venta Ult. 3 Meses</th>
    				<th class="text-center">Cod. Transporte</th>
    				<th class="text-center">Nom. Transporte</th>
    			</tr>
			</thead>
			<tbody>
				<?php
				$cart = fn_getCartera($slp);
				while($row = sqlsrv_fetch_array($cart, SQLSRV_FETCH_ASSOC)){
                ?>
                <tr>
                	<td class="text-center d-none"><?=$row['SlpCode'] ?></td>
    				<td class="text-start d-none"><?=utf8_encode($row['Nombre Vendedor']) ?></td>
    				<td class="text-center"><?=$row['Codigo Cliente'] ?></td>
    				<td class="text-start"><?=utf8_encode($row['Nombre Cliente']) ?></td>
    				<td class="text-start"><?=$row['Rut'] ?></td>
    				<td class="text-start"><?=utf8_encode($row['Ciudad']) ?></td>
    				<td class="text-start"><?=utf8_encode($row['Comuna']) ?></td>
    				<td class="text-start"><?=utf8_encode($row['Direccion']) ?></td>
    				<td class="text-center"><?=($row['Tel1'] != '0')?$row['Tel1']:'' ?></td>
    				<td class="text-center"><?=($row['Tel2'] != '0')?$row['Tel2']:'' ?></td>
    				<td class="text-start"><?=utf8_encode($row['Cond. Pago']) ?></td>
    				<td class="text-center"><?=$row['ActivoEnSistema'] ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes12']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes11']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes10']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes9']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes8']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes7']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes6']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes5']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes4']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes3']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes2']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['VtaMes1']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['Venta Promedio 12 MESES']), 0, ',', '.')?></td>
    				<td class="text-end"><?=number_format(intval($row['Venta Promedio 24 MESES']), 0, ',', '.')?></td>
    				<td class="text-end"><?=number_format(intval($row['Venta Promedio 36 MESES']), 0, ',', '.')?></td>
    				<td class="text-end"><?=number_format(intval($row['Deuda Vencida']), 0, ',', '.') ?></td>
    				<td class="text-end"><?=number_format(intval($row['Venta Ult. 3 Meses']), 0, ',', '.') ?></td>
    				<td class="text-center"><?=$row['Cod_Transporte'] ?></td>
    				<td class="text-start"><?=utf8_encode($row['Nom_Transporte']) ?></td>
    			</tr>
                <?php
				}
				?>
			</tbody>
		</table>
	</div>
</div>