<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
    $('#result').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'excel'
        ],
		scrollY:        '50vh',
        scrollCollapse: true,
        paging:         false,
		"language": {
            "info": "",
			"search":         "Buscar:",
			"zeroRecords":    "No se han encontrado registros",
			"decimal": ".",
            "thousands": ","
        }
    } );
} );
</script>

<style type="text/css">
body {
	background-color: #FFF;
}
a:link {
    color: #000000;
}
a:visited {
    color: #000000;
}
a:hover {
    color: #000000;
}
a:active {
    color: #000000;
}
.container { width: 1300px; }
</style>
<div class="row py-1">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Total General Filtros Importados</h5>
	    </div>
	    <div class="card-body">
				<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
						<table id="result" class="display compact" width="100%">
       				<thead>
            		<tr>
              		<th width="17%">L&iacute;nea</th>
              		<th width="5%">C&oacute;digo</th>
	                <th width="57%">Descripci&oacute;n</th>
	                <th width="4%">Buffer</th>
	                <th width="4%">Stock</th>
	                <th width="8%">Dias para quiebre</th>
	                <th width="8%">Margen</th>
                </tr>
        			</thead>
        			<tbody>
							<?php
							$stmt = fn_qry8();
							while( $row = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC) ) {
							?>
								<tr>
								  <td><?=$row['FirmName']?></td>
								  <td><?=$row['ItemCode']?></td>
									<td><?=$row['ItemName']?></td>
									<td align="right"><?=$row['BufferVta']?></td>
									<td align="right"><?=number_format($row['Stock'], 0, ',', '.')?></td>
							<?php
								if($row['Stock'] == 0 && $row['BufferVta'] == 0){
							?>
									<td align="right">0</td>
							<?php
								}else{
									if($row['Stock'] > 0 && $row['BufferVta'] == 0){
							?>
									<td align="right">999</td>
							<?php
									}else{
							?>
									<td align="right"><?=number_format(($row['Stock']*21)/$row['BufferVta'], 0, ',', '.')?></td>
							<?php
									}
								}
							?>
									<td align="right"><?=number_format($row['Margen'], 0, ',', '.')?>%</td>
								</tr>
							<?php
							}
							?>
							</tbody>
    				</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>