<?php
	include("../liblist.php");
?>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );

  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    	scrollCollapse: true,
		fixedHeader: true,
		"ordering": true,
		"order": [[3, 'asc'],[4, 'asc'],[5, 'asc'], [7, 'asc']],
    	paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": true,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  		"thousands": ".",
			"paginate": {
		    	"first":      "Primera",
	      		"last":       "Ultima",
	      		"next":       "Siguiente",
	      		"previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

});
</script>
<table id="result" class="table table-hover table-sm table-striped">
    <thead>
        <tr>
            <th class="text-center">OF</th>
            <th class="text-center">C&oacute;digo</th>
            <th class="text-center">Descripci&oacute;n</th>
            <th class="text-center">Nivel 1</th>
            <th class="text-center">Nivel 2</th>
            <th class="text-center">Nivel 3</th>
            <th class="text-center">Prioridad</th>
            <th class="d-none">Orden Prioridad</th>
            <th class="text-center">Stock</th>
            <th class="text-center">Cantidad</th>
            <th class="text-center">Ciclo Completo</th>
            <th class="text-center">Fecha</th>
            <th class="text-center">C&oacute;digo QR</th>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td class="d-none"></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
    </thead>
    <tbody>
    <?php
    $param = fn_getParametrosCalculo('prd')->fetch_assoc();
    $fact = ($param['mesesprodalt'] + (($param['mesesprod'] * $param['segfactor'])/100));
    $detOF = fn_getDetalleOrdenesFabricacionDespiece();
    while ($sap =  sqlsrv_fetch_array( $detOF, SQLSRV_FETCH_ASSOC)){
        $niveles = fn_getNivelesXSupervisor($_GET['sp']);
        while($nivel = $niveles->fetch_assoc()){
            if( ($sap['U_Nivel2'] == $nivel['nivel2']) && ($sap['U_Nivel3'] == $nivel['nivel3']) ){
                $descripcion = fn_getNombreItem($sap['ItemCode']);
                $OF = fn_getMonitorPlanta960($sap['ItemCode']);

                if(mysqli_num_rows($OF) > 0){
                    while($fila = $OF->fetch_assoc()){
                        ?>
                <tr>
                	<td class="text-center"><?=number_format($sap['DocNum'], 0, ',', '.') ?></td>
                	<td class="text-center"><?=$sap['ItemCode'] ?></td>
                	<td class="text-start"><?=$descripcion?></td>
                	<td class="text-center"><?=$sap['U_Nivel1'] ?></td>
                	<td class="text-center"><?=$sap['U_Nivel2'] ?></td>
                	<td class="text-center"><?=$sap['U_Nivel3'] ?></td>
                	<td class="text-center"><?=$fila['prioridad'] ?></td>
                	<td class="d-none">0<?=$fila['prioridad'] ?></td>
                	<td class="text-end"><?=number_format(fn_getStockDespieceItem($sap['ItemCode']), 0, ',', '.') ?></td>
                	<td class="text-end"><?=number_format($sap['enOF'], 0, ',', '.') ?></td>
                	<td class="text-end"><?=number_format($fila['cantnecesaria'], 0, ',', '.') ?></td>
                	<td class="text-center"><?=date('d-m-Y', strtotime($sap['fecha'])) ?></td>
					<td class="text-center" title="Ver c&oacute;digo QR">
						<button class="btn btn-link" onClick="cargaModal(<?=$sap['DocNum']?>);">
                			<i class="bi bi-qr-code text-dark" style="font-size: 2rem;"></i>
						</button>
					</td>
                </tr>
        	            <?php
        	        }
        	    } else {
        	        ?>
                <tr>
                	<td class="text-center"><?=number_format($sap['DocNum'], 0, ',', '.') ?></td>
                	<td class="text-center"><?=$sap['ItemCode'] ?></td>
                	<td class="text-start"><?=$descripcion?></td>
                	<td class="text-center"><?=$sap['U_Nivel1'] ?></td>
                	<td class="text-center"><?=$sap['U_Nivel2'] ?></td>
                	<td class="text-center"><?=$sap['U_Nivel3'] ?></td>
                	<td class="text-center">Sin asignar</td>
                	<td class="d-none">9999</td>
                	<td class="text-end"><?=number_format(fn_getStockDespieceItem($sap['ItemCode']), 0, ',', '.') ?></td>
                	<td class="text-end"><?=number_format($sap['enOF'], 0, ',', '.') ?></td>
                	<td class="text-center">No definido</td>
                	<td class="text-center"><?=date('d-m-Y', strtotime($sap['fecha'])) ?></td>
                	<td class="text-center" title="Ver c&oacute;digo QR">
                		<button class="btn btn-link" onClick="cargaModal(<?=$sap['DocNum']?>);">
                			<i class="bi bi-qr-code text-dark" style="font-size: 2rem;"></i>
						</button>
					</td>
                </tr>
        	            <?php
        	    }
            }
        }
	}
	?>
	</tbody>
</table>
<div class="row">
	<div class="col-sm-12 col-md-2 col-lg-2 offset-md-10 offset-lg-10 text-center">
		<button type="button" class="btn btn-success" onClick="archivo();"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Exportar</button>
	</div>
</div>
<script>
	function cargaModal(id){
		var addr = './prod/showQR.php?id='+id;
		$('#modalDatosMD').find('.modal-content').load(addr, function(resp, stat, xhr){
			if(stat == 'success'){
				//alert("OK");
				$('#modalDatosMD').modal('show');
			} else {
				alert("Error: " + xhr.status + ": " + xhr.statusText);
			}
		});
	}
</script>