<?php
  $plansindesp = fn_plansindesp();
  $plancondesp = fn_plancondesp();
  $liberahoy = fn_liberahoy();
  $entregahoy = fn_entregahoy();
  $prod30dias = fn_prod30dias();
  $row1 = sqlsrv_fetch_array( $plansindesp, SQLSRV_FETCH_ASSOC);
  $row2 = sqlsrv_fetch_array( $plancondesp, SQLSRV_FETCH_ASSOC);
  $row3 = sqlsrv_fetch_array( $liberahoy, SQLSRV_FETCH_ASSOC);
  $row4 = sqlsrv_fetch_array( $entregahoy, SQLSRV_FETCH_ASSOC);
  $row5 = sqlsrv_fetch_array( $prod30dias, SQLSRV_FETCH_ASSOC);
?>
<!-- jQuery Autocompletar -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>

<link rel="stylesheet" href="css/modal1.css">
<script type="text/javascript">
  $(document).ready(function() {
    $("#buscaritem").autocomplete({
      source: function(request, response) {
        $.ajax({
          url: "api/buscaritem.php",
          dataType: "json",
          data: {
            term: request.term
          },
          success: function(data) {
            response(data);
          }
        });
      },
      minLength: 2,
      select: function(event, ui) {
        var producto = ui.item ? ui.item.label : '';
        var arrayProducto = producto.split(":");
        $('#buscaritem').val(arrayProducto[0]);
	      $('#itemcode').val(arrayProducto[1]);
          return false;
        },
        open: function() {
          $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
        },
        close: function() {
          $(this).removeClass("ui-corner-top").addClass("ui-corner-all");
        }
      }).autocomplete("instance")._renderItem = function(ul, item) {
        return $("<li>").append("<a>" + item.label.split(":")[0] +  "</a>").appendTo(ul);
      };
  });

  function ActivaGrafico(){
  	document.getElementById("btn-modal1").checked = true;
  }
</script>
<style type="text/css">
  .highcharts-figure, .highcharts-data-table table {
    min-width: 310px;
    max-width: 900px;
    margin: 1em auto;
  }
  #container {
    height: 300px;
  }
  .highcharts-data-table table {
  	font-family: Verdana, sans-serif;
  	border-collapse: collapse;
  	border: 1px solid #EBEBEB;
  	margin: 10px auto;
  	text-align: center;
  	width: 100%;
  	max-width: 500px;
  }
  .highcharts-data-table caption {
    padding: 1em 0;
    font-size: 1.2em;
    color: #555;
  }
  .highcharts-data-table th {
  	font-weight: 600;
    padding: 0.5em;
  }
  .highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
    padding: 0.5em;
  }
  .highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
    background: #f8f8f8;
  }
  .highcharts-data-table tr:hover {
    background: #f1f7ff;
  }
</style>
<div class="row">
  <div class="col-lg-12 col-md-12 col-sm-12">
      <div class="card">
        <div class="card-header bg-success">
          <h5 class="card-title">Estado Ordenes de Fabricaci&oacute;n - Planta 912</h5>
        </div>
        <div class="card-body">
          <table align="center" width="100%" class="table table-condensed table-hover table-striped" >
            <tr>
            	<td>&nbsp;</td>
            	<td>&nbsp;</td>
            	<td align="right">Cantidad</td>
            	<td>&nbsp;</td>
            </tr>
            <tr>
            	<td><p class="font-weight-bold">Planificadas sin despiece (<a href="?sys=prod&pg=detplandesp&con=0" target="_self">ver detalle</a>)</P></td>
            	<td>&nbsp;</td>
            	<td align="right"><p class="font-weight-bold"><?=number_format($row1['PlanificadoS'], 0, ',', '.')?></p></td>
            	<td rowspan="2" align="center" style="vertical-align: middle;"><a href="?sys=prod&pg=detdesp960" target="_self">
            		<button type="button" class="btn btn-warning">Detalle Despieces Pta.960</button></a></td>
            </tr>
            <tr>
              <td><p class="font-weight-bold">Planificadas con despiece (<a href="?sys=prod&pg=detplandesp&con=1" target="_self">ver detalle</a>) (<a href="?sys=prod&pg=detplandesp&con=2" target="_self">Al 70%</a>)</p></td>
            	<td>&nbsp;</td>
              <td align="right"><p class="font-weight-bold"><?=number_format($row2['PlanificadoC'], 0, ',', '.')?></p></td>
              </tr>
            <tr>
            	<td><p class="font-weight-bold">Liberadas a la fecha (<a href="?sys=prod&pg=liberahoy" target="_self">ver detalle</a>)</p></td>
            	<td>&nbsp;</td>
              	<td align="right"><p class="font-weight-bold"><?=number_format($row3['PlannedQty'], 0, ',', '.')?></p></td>
              	<td>&nbsp;</td>
            </tr>
            <tr>
              <td><p class="font-weight-bold">Entregadas hoy (<a href="?sys=prod&pg=entregahoy" target="_self">ver detalle</a>)</p></td>
            	<td>&nbsp;</td>
              <td align="right"><p class="font-weight-bold"><?=number_format($row4['Quantity'], 0, ',', '.')?></p></td>
              <td rowspan="2" align="center" style="vertical-align: middle;">
                <button type="button" class="btn btn-warning" onClick="ActivaGrafico()">Ver Grafico</button>
              </td>
            </tr>
            <tr>
              <td><p class="font-weight-bold">Producci&oacute;n entregada &uacute;ltimos 30 d&iacute;as (<a href="?sys=prod&pg=entrega30d" target="_self">ver detalle</a>)</p></td>
            	<td>&nbsp;</td>
              <td align="right"><p class="font-weight-bold"><?=number_format($row5['cantidad'], 0, ',', '.')?></p></td>
            </tr>
            <tr>
              <td colspan="4"><p class="font-weight-bold">Prioridades de producci&oacute;n ( <a href="?sys=prod&pg=priofabfil&kind=1">Filtros Nacionales</a> - <a href="?sys=prod&pg=priofabfil&kind=2">Filtros Importados</a>  - <a href="?sys=prod&pg=priofabfil&kind=3">Filtros Especiales</a> - <a href="?sys=prod&pg=priofabfil&kind=4">Filtros Descontinuados</a> )</p></td>
            </tr>
          </table>
        </div>
      </div>
  </div>
</div>
<div class="row">
  <div class="col-lg-12 col-md-12 col-sm-12">
      <div class="card">
        <div class="card-header bg-success">
          <h5 class="card-title">Busqueda de Filtro</h5>
        </div>
        <div class="card-body">
        	<table class="table">
            <form action="?sys=prod&pg=ordstatus" method="post">
            	<tr>
            		<td colspan="4" align="left" valign="middle">
                  <input name="buscaritem" type="text" class="form-control form-control-sm" id="buscaritem" placeholder="Busca tu producto">
                  <input type="hidden" name="itemcode" id="itemcode" >
                </td>
            		<td width="16%" align="center">
                  <input name="button2" type="submit" class="btn btn-warning" id="button2" value="Buscar Filtro">
                </td>
          		</tr>
              <?php
                if(isset($_POST['itemcode'])) {
                  if (!empty($_POST['itemcode'])) {
                    $itemcode = $_POST['itemcode'];
                    $buscafiltro = fn_filtrobusca($itemcode);
                    if (sqlsrv_num_rows($buscafiltro) > 0 ){
                    $row7 = sqlsrv_fetch_array( $buscafiltro, SQLSRV_FETCH_ASSOC);
              ?>
              <tr>
                <td width="6%" align="left" valign="middle"><?=$row7['ItemCode']?></td>
                <td width="50%" align="center"><?=$row7['ItemName']?></td>
                <td width="19%" align="center"><?=$row7['U_Descripcion2']?></td>
                <td width="9%" align="center">Prioridad <?=$row7['Num']?></td>
                <td align="center">Stock Bod.1: <?=$row7['OnHand']?></td>
              </tr>
              <?php
                    } else {
                    	echo '<td colspan="5" align="center">No se han encontrado detalles para el c&oacute;digo seleccionado.</td>';
                    }
                  }
                }
                 ?>
            </form>
          </table>
          <div class="table-responsive">
            <table class="table">
            	<thead class="thead-light">
              	<tr>
              		<th align="center" scope="col">OF</th>
              		<th align="center" scope="col">Fecha OF</th>
              		<th align="center" scope="col">Estado</th>
              		<th align="center" scope="col">Fecha Liberado</th>
              		<th align="center" scope="col">Cantidad Planificada</th>
              		<th align="center" scope="col">Cantidad Pendiente</th>
              		<th align="center" scope="col">Origen</th>
              	</tr>
            	</thead>
            	<tbody>
                <?php
                  if(isset($_POST['itemcode'])) {
                    if (!empty($_POST['itemcode'])) {
                      $itemcode = $_POST['itemcode'];
                      $detbuscado = fn_detbuscado($itemcode);
                      if (sqlsrv_num_rows($detbuscado) > 0 ) {
                      $row6 = sqlsrv_fetch_array( $detbuscado, SQLSRV_FETCH_ASSOC);
                ?>
                <tr>
              	  <td align="center"><?=$row6['DocNum']?></td>
              	  <td align="center"><?=date_format($row6['PostDate'], 'd-m-Y')?></td>
              	  <td align="center"><?=$row6['DocStatus']?></td>
              	  <td align="center"><?=is_null($row6['RlsDate']) ? "" : date_format($row6['RlsDate'], 'd-m-Y')?></td>
              	  <td align="center"><?=number_format($row6['PlannedQty'], 0, ',', '.')?></td>
              	  <td align="center"><?=number_format($row6['Pendiente'], 0, ',', '.')?></td>
              	  <td align="center"><?=$row6['Origen']?></td>
            	  </tr>
                <?php
                      } else {
                      	echo '<td colspan="7" align="center">No se han encontrado detalles para el c&oacute;digo seleccionado.</td>';
                      }
                    }
                  }
                   ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
  </div>
</div>
<div class="container">
  <input type="checkbox" id="btn-modal1">
	<label for="btn-modal1" class="lbl-modal1"></label>
	<div class="modal1">
		<div class="contenedor1">
			<header>Cantidad de Filtros Producidos &uacute;ltimos 30 d&iacute;as</header>
			<label for="btn-modal1">X</label>
			<div class="contenido1">
				<figure class="highcharts-figure">
					<div id="container5"></div>
		    </figure>
			</div>
		</div>
	</div>
</div>
<script src="lib/highcharts/highcharts.js"></script>
<script src="lib/highcharts/series-label.js"></script>
<script src="lib/highcharts/exporting.js"></script>
<script src="lib/highcharts/export-data.js"></script>
<script src="lib/highcharts/accessibility.js"></script>
<script>
Highcharts.chart('container5', {
  chart: {
        type: 'line'
  },
  title: {
    text: 'Cantidad de Filtros Producidos Ultimos 30 d&iacute;as'
  },

  yAxis: [{
        min: 0,
        title: {
            text: 'Cant. Filtros Producidos (Miles) '
        }
    }, {
		min: 0,
        title: {
            text: 'Filtros Producidos en $$$'
        },
        opposite: true
    }],

  xAxis: {
    categories: [
		<?php
		$resx = fn_catgrafico();
		while ($rowresx = sqlsrv_fetch_array($resx, SQLSRV_FETCH_ASSOC)) {
		?>
		'<?=date_format($rowresx['Expr1'], 'd-m-Y')?>',
		<?php
		}
		?>
	]
  },

  legend: {
    layout: 'vertical',
    align: 'right',
    verticalAlign: 'middle'

  },

  plotOptions: {
    series: {
      label: {
        connectorAllowed: false
      }

    },

  },

  series: [{
    name: '# Filtros',
    data: [

		<?php
		$resy = fn_serie1grafico();
		while ($rowresy = sqlsrv_fetch_array($resy, SQLSRV_FETCH_ASSOC)) {
		?>
		<?=$rowresy['cantidad']?>,
		<?php
		}
		?>
	]
  },{
    name: '$ Filtros',
    color: 'rgba(248,161,63,1)',
    data: [

		<?php
		$resy = fn_serie2grafico();
		while ($rowresy = sqlsrv_fetch_array($resy, SQLSRV_FETCH_ASSOC)) {
		?>
		<?=$rowresy['cantidad']?>,
		<?php
		}
		?>
	],
	  yAxis: 1
  }

		  ],

  responsive: {
    rules: [{
      condition: {
        maxWidth: 1000

      },
      chartOptions: {
        legend: {
          layout: 'horizontal',
          align: 'center',
          verticalAlign: 'bottom'
        }
      }
    }]
  }

});
</script>
