<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );

  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: true,
		"ordering": true,
    	paging: true,
		"pageLength": 25,
		responsive: true,
		"autoWidth": true,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

});
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	      <h5 class="card-title">Monitor de Producci&oacute;n</h5>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row">
    	    		<div class="col-md-12 col-lg-12 col-sm-12">
    	    			<table class="table table-sm table-hover table-striped" id="result" style="width: 100%">
                			<thead>
                				<tr>
                					<th class="text-center">OF.</th>
                					<th class="text-center">Cod. Dimensionado</th>
                					<th class="text-center">Descripci&oacute;n</th>
                					<th class="text-center">Requerido</th>
                					<th class="text-center">Completado</th>
                					<th class="text-center">Faltante</th>
                					<th class="text-center">Bobina Madre</th>
                					<th class="text-center">Cant. Bobina Madre Requerida</th>
                				</tr>
                			</thead>
                			<tbody>
                				<?php
                				$datos = fn_getMonitorPapeles();
                				while($linea = sqlsrv_fetch_array( $datos, SQLSRV_FETCH_ASSOC)){
                				  ?>
                				    <tr>
                    					<td class="text-center"><?= number_format($linea['O_F'], 0, ',','.') ?></td>
                    					<td class="text-center"><?= $linea['Cod_Dimensionado'] ?></td>
                    					<td class="text-center"><?= $linea['Descripcion_Dimensionado'] ?></td>
                    					<td class="text-center"><?= number_format($linea['Requerido'], 2, ',','.') ?></td>
                    					<td class="text-center"><?= number_format($linea['Completado'], 2, ',','.') ?></td>
                    					<td class="text-center"><?= number_format($linea['Faltante'], 2, ',','.') ?></td>
                    					<td class="text-center"><?= $linea['Cod_Bobina_Madre'] ?></td>
                    					<td class="text-center"><?= number_format($linea['Cant_Bobina_Madre_Requerida'], 2, ',','.') ?></td>
                    				</tr>
                				    <?php
                				}
                				?>
                			</tbody>
                		</table>
    	    		</div>
    	    	</div>
    	    </div>
    	</div>
	</div>
</div>