<?php
	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _TOTAL_ de _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ".",
	  	"thousands": ",",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

  const valores = window.location.search;
	const urlParams = new URLSearchParams(valores);
	if (urlParams.get('ms') !== null){
		$('#txtCorte').val(urlParams.get('ms'));
		$('#txtDiasProd').val(urlParams.get('dp'));
	}
});
</script>
<script>
	function updDatos(){
		muestraProc();
		var ms = $('#txtCorte').val();
		var dp = $('#txtDiasProd').val();
		$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&ms='+ms+'&dp='+dp);
	}
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
  <div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Despiece Interno</h5>
	    </div>
	    <div class="card-body">
    		<div class="row py-1">
	    		<div class="col-md-3 col-lg-3 col-sm-12 text-end">
						<label for="txtCorte" class="form-label">Meses de Corte: </label>
	    		</div>
	    		<div class="col-md-2 col-lg-2 col-sm-12">
	    			<?php
	    			if (!isset($_GET['ms'])){
	    			?>
						<input type="number" class="form-control form-control-sm" step="0.1" id="txtCorte" name="txtCorte" value="<?=$params['corte_prod']?>">
						<?php
	    			} else {
	    			?>
	    			<input type="number" class="form-control form-control-sm" step="0.1" id="txtCorte" name="txtCorte">
	    			<?php
	    			}
	    			?>
	    		</div>
	    		<div class="col-md-3 col-lg-3 col-sm-12 text-end">
						<label for="txtDiasProd" class="form-label">D&iacute;as de Producci&oacute;n: </label>
	    		</div>
	    		<div class="col-md-2 col-lg-2 col-sm-12">
	    			<?php
	    			if (!isset($_GET['dp'])){
	    			?>
						<input type="number" class="form-control form-control-sm" id="txtDiasProd" name="txtDiasProd" value="<?=$params['dias_proceso']?>">
						<?php
	    			} else {
	    			?>
	    			<input type="number" class="form-control form-control-sm" id="txtDiasProd" name="txtDiasProd">
	    			<?php
	    			}
	    			?>
	    		</div>
	    		<div class="col-md-2 col-lg-2 col-sm-12">
						<button class="btn btn-sm btn-success" onClick="updDatos();"><i class="fa fa-check" aria-hidden="true"></i> Validar</button>
	    		</div>
    		</div>
	    	<div class="row py-1">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
			    	<table id="result" class="display compact stripe hover" >
							<thead>
								<tr>
									<th align="center" width="5%">C&oacute;digo</th>
									<th align="center" width="15%">Descripci&oacute;n</th>
									<th align="center" width="5%">Despiece Requerido</th>
									<th align="center" width="3%">Stock Disponible</th>
									<th align="center" width="3%">Diferencia</th>
									<th align="center" width="3%">Estado</th>
								</tr>
								<tr>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
								</tr>
							</thead>
							<tbody>
							<?php
								if (isset($_GET['ms'])){
									if ($_GET['ms'] != 0 || $_GET['ms'] != ''){
										$despiece = fn_getDispDespiece('I', $_GET['ms'], $_GET['dp']);
										while($rows = $despiece->fetch_assoc()) {
											$stock = fn_getStockDespieceItem($rows['codigo']);
											?>
											<tr>
												<td align="center"><a class="li-modal" data-bs-target="#modalDatos" data-bs-toggle="modal" href="plan/showfildesp2.php?hj=<?=$rows['codigo']?>&stk=<?=$stock?>&rq=<?=$rows['piezas']?>"><?=$rows['codigo']?></a></td>
												<td align="left"><?=$rows['itemname']?></td>
												<td align="right"><?=number_format($rows['piezas'], 0, ',', '.')?></td>
								        <td align="right"><?=number_format($stock, 0, ',', '.')?></td>
								        <td align="right"><?=number_format($stock-$rows['piezas'], 0, ',', '.')?></td>
								        <td align="right"><?=($stock > $rows['piezas'])?'':'Incompleto'?></td>
											</tr>
											<?php
										}
									}
								}
							?>
							</tbody>
						</table>
					</div>
	    	</div>
			</div>
	  </div>
	</div>
</div>