<?php
	include("../liblist.php");
	$param = fn_getParametrosCalculo('960')->fetch_assoc();
?>
<script type="text/javascript">
	$(document).ready(function() {
		$('#result3 thead td').each( function () {
	      var title = $('#result3 thead td').eq( $(this).index() ).text();
	      $(this).html( '<input class="form-control form-control-sm" type="text" />' );
	  } );
		var table3 = $('#result3').removeAttr('width').DataTable({
		 	dom: 'Brtip',
		 		buttons: ['excel'],
				scrollY: '45vh',
				scrollX: '100%',
		 		 scrollCollapse: false,
				fixedHeader: false,
				"ordering": true,
		 		paging: false,
				 
				
				"pageLength": 100,
				responsive: true,
				"autoWidth": false,
				"language": {
		  			"info": "Registros visualizados: _MAX_",
					"search": "Buscar:",
					"zeroRecords": "No se han encontrado registros",
					"decimal": ",",
			  		"thousands": ".",
					"paginate": {
				    "first":      "Primera",
			      "last":       "Ultima",
			      "next":       "Siguiente",
			      "previous":   "Anterior"
		  	}
		  }
		});
		
		table.columns().every( function () {
          var that = this;
          $( 'input', this.header() ).on( 'keyup change', function () {
            that
              .search( this.value )
              .draw();
          });
        });

		

	});
</script>
<div class="row">
    <div class="col-md-12 col-lg-12 col-sm-12">
      <table id="result3" class="display compact stripe hover">
    		<thead>
    			<tr>
    				<th class="text-center" width="1px"><input type="checkbox" id="checkAll" name="checkAll" value="" onclick="toggleCheckboxes()"></th>
    				<th class="text-start d-none">Nivel</th>
    				<th class="text-center" width="5px">Despiece</th>
    				<th class="text-center" width="25px">Descripci&oacute;n</th>
    				<th class="text-center" width="10px">L&iacute;nea</th>
    				<th class="text-center" width="5xp">Unidades Necesitadas</th>
    				<th class="text-center" width="5px">Cumple Stock</th>
    				<th class="text-center" width="5px">Cantidad Requerida Completa</th>
    				<th class="text-center" width="5px">Cant. en Bodega</th>
    				<?php
    					if($_GET['nv'] == 0){
    				?>
    				<th class="text-center" width="5px">En OF</th>
    				<?php
    					} elseif($_GET['nv'] == 1){
    				?>
    				<th class="text-center" width="5px">En OC</th>
    				<?php
    					} elseif($_GET['nv'] == 2){
    				?>
    				<th class="text-center" width="5px">En OF/OC</th>
    				<?php
    					}
    				?>
    				<th class="text-center" width="5px">Unidades a Fabricar</th>
    				<th class="text-center" width="5px">Prioridad</th>
    				<th class="text-center" width="5px">Nivel 2</th>
    				<th class="text-center" width="5px">Nivel 3</th>
    			</tr>
				<!--<tr>
					<td></td>
					<td class="text-start d-none"></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
    			</tr>-->
    		</thead>
    		<tbody>
    		<?php
    		$cuentaunid = 0;
    		$contador = 0;
    		$cuentanocumple = 0;
    		$fec_1 = Date('Y-m-d H:i:s');
    		$fec_hoy = new DateTime($fec_1);
    		$meses_ultima_fab = $param['techo_fab']-$param['piso_fab'];
    		$datos = fn_getDespieceSecuencia($_GET['nv'], $_GET['usr']);
    		while($fila = $datos->fetch_array()){
    			// Secci�n en la que se calcula el stock por ciclos del despiece
    			// Se calcula en base al stock actual del despiece dividido entre la suma de los buffer que utilizan el despiece
    			$stk_ciclo = fn_getStockDespieceItem($fila['itemcode']) / fn_getBufferDespieceCiclo($fila['itemcode']);
    			$activador = $fila['X'] + $param['fact_activa'];

    			$fec = fn_getUltimaFabricacionDespiece($fila['itemcode']);
    			$fec_ultimo = new DateTime($fec->format('Y-m-d H:i:s'));
    			$diff = $fec_ultimo->diff($fec_hoy);
                $ultima_fab = ($diff->days) /30;

        			//if($cantnec['Y'] > 0){
            			if($fila['cantnecesaria2'] >= $fila['cantnecesaria'] ){
            				$cant_mayor = $fila['cantnecesaria2'];
            			} else {
            				$cant_mayor = $fila['cantnecesaria'];
            			}

            			$enOF = 0;
            			$enOC = 0;
            			$totBod = $fila['stockbodega'];

            			$cumple = '';
            			if ($fila['cantnecesaria'] <= $totBod){
            			    $cumple = 'Sí';
            			} else {
            			    $cumple = 'No';
            			    $cuentanocumple++;
            			}

            			if($_GET['nv'] == 0){
            				$enOF = fn_getOrdenesFabricacionDespiece($fila['itemcode']);
            				$totBod += $enOF;
            			} elseif($_GET['nv'] == 1){
            				$enOC = fn_getOrdenesCompraDespiece($fila['itemcode']);
            				$totBod += $enOC;
            			} elseif($_GET['nv'] == 2){
            				$enOF = fn_getOrdenesFabricacionDespiece($fila['itemcode']);
            				$enOC = fn_getOrdenesCompraDespiece($fila['itemcode']);
            				$val = ($fila['U_Nivel1']=='410')?$enOF:$enOC;
            				$totBod += $val;
            			}
            			?>
            			<tr>
            				<td class="text-center"><input type="checkbox" name="ordenes[]" value="<?=$fila['itemcode']?>"></td>
            				<td class="text-start d-none"><?=$fila['U_Nivel1']?></td>
            				<td class="text-start"><?=$fila['itemcode']?></td>
            				<td class="text-start"><?=$fila['ItemName']?></td>
            				<td class="text-start"><?=fn_getNombreLinea($fila['linea'])?></td>
            				<td class="text-end"><?=number_format(abs($fila['cantnecesaria']), 0, ',', '.')?></td>
            				<td class="text-center"><?=$cumple?></td>
            				<td class="text-end"><?=number_format($fila['cantnecesaria2'], 0, ',', '.')?></td>
            				<td class="text-end"><?=number_format(fn_getStockDespieceItem($fila['itemcode']), 0, ',', '.')?></td>
								<?php
									if($_GET['nv'] == 0){
								?>
            				<td class="text-end"><?=number_format($enOF, 0, ',', '.')?></td>
								<?php
									} elseif($_GET['nv'] == 1){
								?>
            				<td class="text-end"><?=number_format($enOC, 0, ',', '.')?></td>
								<?php
									} elseif($_GET['nv'] == 2){
								?>
            				<td class="text-end"><?=number_format(($fila['U_Nivel1']=='410')?$enOF:$enOC, 0, ',', '.')?></td>
            					<?php
            						}
									$aFab = 0;
									$valFact = $cant_mayor * $param['corte_prod'];
									$aFab = $valFact;
									if($fila['U_Nivel1']=='410'){
										$menos = $enOF;
									} else {
										$menos = $enOC;
									}
									if (($stk_ciclo <= $activador)){// || ($ultima_fab >= $meses_ultima_fab)){
										if ($fila['Z']-$totBod<=0){
											$aFabricar = 0;
										} else {
											$aFabricar = $fila['Z']-$totBod;
										}
									} else {
										$aFabricar = 0;
									}
								?>
            				<td class="text-end" id="cantidad"><?=number_format($aFabricar, 0, ',', '.')?></td>
            				<td class="text-end"><?=$fila['prioridad']?></td>
            				<td class="text-end"><?=$fila['U_Nivel2']?></td>
            				<td class="text-end"><?=$fila['U_Nivel3']?></td>
            			</tr>
            			<?php
            			if ($aFabricar > 0){
            			    $cuentaunid += $aFabricar;
            			    $contador++;
            			}
        			//}
    		}
    		?>
    		</tbody>
    		<tfoot>
    			<tr>
        			<td colspan="7" class="text-end fw-bold">No Cubre Stock : </td>
        			<td class="text-end fw-bold"><?=number_format($cuentanocumple, 0, ',', '.')?></td>
        			<td colspan="3" class="text-end fw-bold">Total Despieces a Fabricar : </td>
        			<td class="text-end fw-bold"><?=number_format($contador, 0, ',', '.')?></td>
        			<td class="text-end">&nbsp;</td>
    			</tr>
    			<tr>
    				<td colspan="11" class="text-end fw-bold">Total Unidades a Fabricar : </td>
        			<td class="text-end fw-bold"><?=number_format($cuentaunid, 0, ',', '.')?></td>
        			<td class="text-end">&nbsp;</td>
    			</tr>
    		</tfoot>
    	</table>
    </div>
</div>
<div class="row">
	<div class="col-md-5 col-lg-5 col-sm-12 offset-md-7 offset-lg-7 text-end">
		<button class="btn btn-success btn-sm" onClick="expSinCab(3);" ><i class="fa fa-file-excel-o" aria-hidden="true"></i> Generar Excel</button>
		<button class="btn btn-success btn-sm" onClick="genPDF3();"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Generar PDF</button>
		<button class="btn btn-success btn-sm" onClick="genFile3();"><i class="fa fa-file-text" aria-hidden="true"></i> Exportar TXT</button>
	</div>
</div>
<script>
function genFile3() {
	var arr = new Array();;
	$('#result3 tr').each(function (){
		if($(this).find('td:first-child input').prop('checked') == true){
			var dat = new Array($(this).find('td:first-child input').val(), $(this).find('td:nth-last-child(4)').text(), $(this).find('td:nth-last-child(3)').text(), $(this).find('td:nth-last-child(10)').text());
			arr.push(dat);

		}
	});
	/*
	$.ajax({
    type: 'post',
    url: 'plan/genExpTXT.php',
    data: {
      fec : $('#fecha').val(),
      usr : $('#udt').val(),
      ordenes : arr
    },
    success: function (data) {*/
    	$.ajax({
    	    type: 'post',
    	    url: 'api/hlp/hlpGuardaMonitor960.php',
    	    data: {
    	      ordenes : arr
    	    },
    	    success: function (data) {
    	    	console.log("OK");
    	    }
    	  });/*
    }
  });*/
}

function genPDF3() {
	var arr = new Array();;
	$('#result3 tr').each(function (){
		if($(this).find('td:first-child input').prop('checked') == true){
			var dat = new Array($(this).find('td:first-child input').val(), $(this).find('td:nth-last-child(4)').text());
			arr.push(dat);
		}
	});
	$.ajax({
    type: 'post',
    url: './files/prntGenDespiece.php',
    data: {
      fec : $('#fecha').val(),
      usr : $('#udt').val(),
      ordenes : arr
    },
    success: function (data) {
    	window.open('./tmp/'+data, '_blank');
    }
  });
}


$('#checkAll').on('change', function(){
		var check = $(this).is(':checked');
		if(check){
			$('#result3 tr td:first-child input').each(function (){
				$(this).prop('checked', true);
			});
		} else {
			$('#result3 tr td:first-child input').each(function (){
				$(this).prop('checked', false);
			});
		}
	});

</script>
<script>
function toggleCheckboxes() {
    // Obtén todos los elementos checkbox dentro de la tabla
    const checkboxes = document.querySelectorAll("#result3 tbody input[type='checkbox']");

    // Verifica si al menos un checkbox está marcado
    let atLeastOneChecked = false;
    checkboxes.forEach(checkbox => {
        if (checkbox.checked) {
            atLeastOneChecked = true;
        }
    });

    // Activa o desactiva todos los checkboxes en función del estado del primer checkbox
    checkboxes.forEach(checkbox => {
        checkbox.checked = !atLeastOneChecked;
    });
}
</script>