<?php
	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
	if(isset($_GET['res'])){
		if($_GET['res'] == 'true'){
			?>
				<div class="alert alert-dismissible alert-success text-center" role="alert">
					<button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
					  <i class="fa fa-times" aria-hidden="true"></i>
					</button>
					<p class="text-success">Los datos han sido guardados correctamente.</p>
				</div>
				<br>
			<?php
		} else {
			?>
				<div class="alert alert-danger text-center" role="alert">
					<button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
					  <i class="fa fa-times" aria-hidden="true"></i>
					</button>
					<p class="text-danger">Ha ocurrido un error almacenando los datos.</p>
					<p class="text-danger">Verifique la informaci&oacute;n ingresada.</p>
				</div>
				<br>
			<?php
		}
	}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/fixedcolumns/4.1.0/js/dataTables.fixedColumns.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'Brtip',
    buttons: ['excel'],
		scrollY: '55vh',
		scrollX: '100%',
    scrollCollapse: true,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		fixedHeader: true,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": "."
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		      <h5 class="card-title">Estado de Ordenes Pendientes</h5>
		    </div>
		    <div class="card-body">
    			<div class="row">
    				<div class="col-md-12 col-lg-12 col-sm-12">
    					<table id="result" width="100%" class="display compact stripe hover" >
								<thead>
									<tr>
										<th align="center" width="5%">L&iacute;nea Unif.</th>
										<th align="center" width="10%">L&iacute;nea</th>
										<th align="center" width="5%">C&oacute;digo</th>
										<th align="center" width="25%">Descripci&oacute;n</th>
										<th align="center" width="2%">Unidades Recomendadas</th>
										<th align="center" width="7%">Estado</th>
										<th align="center" width="2%">Tiempo Estimado Item</th>
									</tr>
									<tr>
										<td align="center">L&iacute;nea Unif.</td>
										<td align="center">L&iacute;nea</td>
										<td align="center">C&oacute;digo</td>
										<td align="center">Descripci&oacute;n</td>
										<td align="center">Unidades Recomendadas</td>
										<td align="center">Estado</td>
										<td align="center">Tiempo Estimado Item</td>
									</tr>
								</thead>
								<tbody>
									<?php
									$datos = fn_getCalculoIntermedio(date("W"));
										$lin = '';
										while($rows = $datos->fetch_assoc()) {
											if ($rows['meses_stk_minimo'] <= $params['corte_prod']){
												$capa = fn_getCapacidadLinea($rows['unif'])->fetch_assoc();
												$reqOF = fn_getOrdenesFabricacionItem($rows['ItemCode']);
												$stock_seguridad = ($rows['stock'] - ($rows['base_calc_mensual'] * $params['mesesmin']));
												$meses_minimo = $stock_seguridad / $rows['base_calc_mensual'];
												if (sqlsrv_num_rows($reqOF) == 0){
													$isOF = sqlsrv_fetch_array($reqOF, SQLSRV_FETCH_ASSOC);
													$tmoItem = $rows['und_a_producir'] / $capa['cap_linea'];
												?>
													<tr>
														<td align="center"><?=number_format($rows['unif'], 0, ',', '.')?></td>
														<td align="center"><?=fn_getNombreLinea($capa['unif'])?></td>
														<td align="center"><?=$rows['ItemCode']?></td>
														<td align="left"><?=$rows['ItemName']?></td>
														<td align="right"><?=number_format($rows['und_a_producir'], 0, ',', '.')?></td>
														<?php
															if (fn_getValidaOrdenGenerada($rows['ItemCode'], $rows['und_a_producir'], $_SESSION['USERID'])){
																echo '<td align="center">Emitida</td>';
															} elseif (fn_getConsultaPiezasItem($rows['ItemCode'], $rows['und_a_producir'])){
																echo '<td align="center">Generar</td>';
																//echo '<td align="center"><a href="api/genofprod.php?itm='.$rows['ItemCode'].'&qty='.$rows['und_prod_ciclo'].'&usr='.$_SESSION['USERID'].'" class="btn btn-success btn-xs" role="button">Generar</a></td>';
															} else {
																echo '<td align="center"><a class="li-modal" href="plan/showdesp.php?itm='.$rows['ItemCode'].'&cnt='.$rows['und_a_producir'].'" rel="modal:open">Despiece Incompleto</a></td>';
															}
														?>
														<td align="right"><?=number_format($tmoItem, 2, ',', '.')?></td>
													</tr>
												<?php
												}
											}
										}
									?>
								</tbody>
							</table>
          	</div>
		    	</div>
		    </div>
	    </div>
	</div>
</div>