
<!-- DataTables CSS -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

<!-- Buttons CSS -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.dataTables.min.css">

<!-- DataTables JS -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

<!-- Buttons JS -->
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>

<script>
$(document).ready(function() {
	$('#result9 thead td').each( function () {
        var title = $('#result9 thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );

  var table = $('#result9').removeAttr('width').DataTable({
   	dom: 'frtip',
		scrollY: '55vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: true,
		"ordering": true,
    paging: false,
		"order": [[ 5, 'asc' ]],
		"pageLength": 25,
		responsive: true,
		"autoWidth": true,
		"language": {
			"info": "Registros visualizados: _TOTAL_ de _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    	"first":      "Primera",
				  "last":       "Ultima",
				"next":       "Siguiente",
				"previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

});
</script>
<div class="modal-header">
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
	<?php
	include("../liblist.php");
	$item = $_GET['itm'];
  $pendiente = $_GET['pendiente'];
  $stock_despiece=fn_getStockDespieceItem($item);
  
	$cabe = fn_getCabeceraRecetaItem($item)->fetch_assoc();
  $cant=0;
	?>
	<div class="row">
	  <div class="col-lg-12 col-md-12 col-sm-12">
      <div class="card">
      <div class="card-header bg-success row ">
        <div class="col-lg-9 col-md-9 col-sm-9">
            <h5 class="card-title">Detalle Filtros, para el Despiece C&oacute;digo <?=$item?></h5>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-3 text-right">
        <button type="button" class="btn btn-success btn-sm upd-modal" onClick="expSinCab(9);">
            <i class="fa fa-file-excel-o" aria-hidden="true"></i> Exportar
        </button>
        
        <button onClick="actualizarStockHijo()" type="button" class="btn btn-success btn-sm upd-modal">
            <i aria-hidden="true"></i> Calcular Stock
        </button>
    </div>
    </div>
        <div class="card-body">
          <table width="100%" align="center">
            <tr>
              <td>
            	  <table align="center" class="table-bordered">
                  <tr>
                     <td align="right" class="bg-success"><strong>C&oacute;digo Item : </strong></td>
                     <td colspan="3">&nbsp;<?=$cabe['padre']?></td>
                  </tr>
                  <tr>
                    <td align="right" bgcolor="#DFF0D8"><strong>Descripci&oacute;n : </strong></td>
                    <td colspan="3">&nbsp;<?=$cabe['itemname']?></td>
                  </tr>
                  <tr>
            		    <td width="20%" align="right" bgcolor="#DFF0D8"><strong>Cantidad base : </strong></td>
                    <td width="20%">&nbsp;<?=number_format($cabe['cant_padre'], 0, ',', '.')?></td>
                    <td width="20%" align="right" bgcolor="#DFF0D8"><strong>Pendiente : </strong></td>
                    <td width="20%">&nbsp;<?=number_format($pendiente, 0, ',', '.')?></td>
                    <td width="20%" align="right" bgcolor="#DFF0D8"><strong>Stock : </strong></td>
                    <td width="20%">&nbsp;<?=number_format($stock_despiece, 0, ',', '.')?></td>
                  </tr>
            	  </table>
            	  <br>
                <table id="result9" class="display" style="width:100%">
            	  
                <thead>
                  <tr>
                    <th width="10%" class="bg-success"><strong>Código</strong></th>
                    <th width="45%" class="bg-success"><strong>Descripción</strong></th>
                    
                    <th width="15%" class="bg-success"><strong>Buffer</strong></th>
                    <th width="15%" class="bg-success"><strong>Stock</strong></th>
                    <th width="15%" class="bg-success"><strong>Cantidad Requerida</strong></th>
                    <th width="15%" class="bg-success"><strong>Días para <br>Activación</strong></th>
                    <th width="15%" class="bg-success"><strong>Stock Hijo</strong></th>
                  </tr>
                  <tr>
                      <td></td>
                      <td></td>
                      <td></td>
                      <td></td>
                      <td></td>
                      <td></td>
                      <td></td>
                     
		            </tr>
                </thead>
                <tbody>
                  <?php
                  
                  $rec = fn_getRecetaItemHijoPadre($item);
                  $cant_requerida=0;
                  $param_despiece = obtenerParametros($item);
                  // "<script>console.log('ciclo_produccion ". $item." : ".$param_despiece['ciclo_produccion']."')</script>";
                  while ($row = $rec->fetch_assoc()) {
                      //// INICIO PROCESO CANTIDA REQUERIDA CICLO COMPLETO
                     // echo "<script>console.log('Padre  de ". $item." : ".$row['padre']."')</script>";
                      $parametros_padre = obtenerParametros($row['padre']);
                      $sum_req_ciclo=0;
                      $DiasActivacion=0;
                    // INICIO FUNCION SQL MUESTRA LOS ITEMCODES PADRE SEGUN EL ITEMCODE HIJO 
                        //$cant_req_ciclo=consultaCantReqCiclo($item, $row['padre'], $parametros_padre['ciclo_produccion'], $parametros_padre['und_redondeo'], $param_despiece['und_redondeo']);
                        //if($cant_req_ciclo){
                       //   foreach ($cant_req_ciclo as $padreCiclo) {
                        //    $sum_req_ciclo=$sum_req_ciclo + $padreCiclo;
                         // }
                          
                        //echo "<script>console.log('result9adospadre : ".json_encode($result9adospadre)."')</script>";
                        // FIN  CONSULTA SQL PARA CARCULAR CANT. REQUERIDA CICLO 

                        //// INICIO Días para Activación fn_getStockItem
                        $DiaAct=(((fn_getStockDespieceItem($row['padre']) + fn_getOrdenesFabricacionPapelLiberadas($row['padre']))/ fn_getBufferVentas3($row['padre']) ) - $parametros_padre['punto_activacion'] + 0 ) * 21 ; //$param['segfactor']
                        if (is_nan($DiaAct) || is_infinite($DiaAct)) {
                          $DiaAct = 0;
                        }
                        $DiasActivacion=round($DiaAct,2);

                    // FIN FUNCION SQL MUESTRA LOS ITEMCODES PADRE SEGUN EL ITEMCODE HIJO 
                    //// FIN PROCESO CANTIDA REQUERIDA CICLO COMPLETO

                   // $cant_requerida=$sum_req_ciclo;
                   $cant_requerida=fn_getreqciclo_mysql($row['padre']);
                    $req = 1; // Calculate $req value here
                    //$stk = fn_getStockDespieceItem($row['padre']);
                    $stock_buffer_padre=fn_GoStockBufferDespieceItem($row['padre']);
                    list($stock_padre, $buffer_padre) = explode('|', $stock_buffer_padre);
	
                   // $rowClass = ($stk < $req) ? '' : '';//bg-danger text-white
                   if ($cant_requerida != 0) {
                  ?>
                    <tr>
                      <td><?= $row['padre'] ?></td>
                      <td><?= $row['ItemName'] ?></td>
                      <td class="text-end"><?= number_format($buffer_padre, 0, ',', '.') ?></td>
                      <td class="text-end"><?= number_format($stock_padre, 0, ',', '.') ?></td>
                      <td class="text-end"><?= number_format($cant_requerida, 0, ',', '.') ?></td>
                      <td class="text-end"><?= number_format(is_numeric($DiasActivacion) ? $DiasActivacion : 0, 2, ',', '.') ?></td>
                      <td class="text-end">0</td>
                      
                    </tr>
                  <?php
                        }
                  }
                  ?>
                </tbody>
              </table>
              </td>
            </tr>
          </table>
        </div>
      </div>
	  </div>
	</div>
</div>

<script>



  function quitarPuntosYDarFormatoMil(valor) {
    // Eliminar puntos y dar formato de mil
    return valor.replace(/\./g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
  }

  function actualizarStockHijo() {

    
    // Obtener la tabla
    var table = document.getElementById("result9");
    
    // Obtener todas las filas, excluyendo la primera (encabezados)
    var rows = table.rows;
    
    // Iterar sobre las filas de datos
    for (var i = 2; i < rows.length; i++) {
      var stockHijo=0;
      if(i==2){stockHijo = <?= $stock_despiece?>;}else{
        StockHijoCell = rows[i-1].cells[6];
        stockHijo = StockHijoCell.innerText;
        
        console.log(' STOCK ACTUALIZADO : '+stockHijo);
      }
      var cantidadRequeridaCell = rows[i].cells[4];
      var cantidadRequerida = quitarPuntosYDarFormatoMil(cantidadRequeridaCell.innerText);
      var cleanedNumber = cantidadRequerida.replace(/[.,]/g, '');
      cantidadRequerida = parseInt(cleanedNumber, 10);

      
      //console.log(stockHijo);
      
      // Restar la cantidad requerida según los días para activación
      var nuevaCantidadStockHijo = stockHijo - cantidadRequerida;
      
      console.log('NUEVO VALOR: '+nuevaCantidadStockHijo+' CANTREQ: '+cantidadRequerida+' STOCKHIJO: '+stockHijo+' I :'+i);
      // Dar formato de mil y actualizar el valor en la celda
      var stockHijoCellNext = rows[i].cells[6];
      stockHijoCellNext.innerText = nuevaCantidadStockHijo.toFixed(0);
      
    }
  }
  
  
</script>
