<?php
	include("../liblist.php");
	$param = fn_getParametrosCalculo('prd')->fetch_assoc();
?>
<style>
	.text-start {
		white-space: nowrap;
		overflow: hidden;
		text-overflow: ellipsis;
	}
</style>
<script type="text/javascript">
	$(document).ready(function() {
		$('#result3 thead td').each( function () {
	      var title = $('#result3 thead td').eq( $(this).index() ).text();
	      $(this).html( '<input class="form-control form-control-sm" type="text" />' );
	  	});
		var table3 = $('#result3').removeAttr('width').DataTable({
		 	dom: 'Bfrtip',
		    buttons: ['excel'],
			scrollY: '45vh',
			scrollX: '100%',
			scrollCollapse: false,
			fixedHeader: true,
			"order": [[ 10, 'asc' ], [ 11, 'asc' ],[ 12, 'asc' ]],
			"ordering": true,
			paging: false,
			"pageLength": 100,
			responsive: true,
			"autoWidth": false,
			"language": {
				"info": "Registros visualizados: _MAX_",
				"search": "Buscar:",
				"zeroRecords": "No se han encontrado registros",
				"decimal": ",",
				"thousands": ".",
				"paginate": {
					"first":      "Primera",
					"last":       "Ultima",
					"next":       "Siguiente",
					"previous":   "Anterior"
				}
			}
		});
		$('#result3 tr').each(function (){
			if($(this).find('td:nth-last-child(4)').text() != '0'){
				$(this).find('td:first-child input').prop('checked', true);
			}
		});
	});
</script>
<div class="row">
    <div class="col-md-12 col-lg-12 col-sm-12">
      <table id="result3" class="display compact stripe hover">
    		<thead>
    			<tr>
    				<th class="text-center" width="5%"><input type="checkbox" id="checkAll" name="checkAll" onclick="toggleCheckboxes()"></th>
    				<th class="text-center d-none">Nivel</th>
    				<th class="text-center" width="5%">Despiece</th>
    				<th class="text-start" width="20%">Descripci&oacute;n</th>
    				<th class="text-center" width="5%">Cant.<br>Requerida</th>
    				<th class="text-center" width="5%">Cumple<br>Stock</th>       
    				<th class="text-center" width="5%">Cant.<br>Requerida<br>Ciclo</th>
    				<th class="text-center" width="5%">Cant.<br>en<br>Bodega</th>
    				<?php
    				if($_GET['nv'] == 0){
    				?>
    				<th class="text-center" width="5%">En OF</th>
    				<?php
    				} elseif($_GET['nv'] == 1){
    				?>
    				<th class="text-center" width="5%">En OC</th>
    				<?php
    				} elseif($_GET['nv'] == 2){
    				?>
    				<th class="text-center" width="5%">En OF/OC</th>
    				<?php
    				}
    				?>
    				<th class="text-center" width="5%">Prioridad</th>
    				<th class="text-center" width="5%">Nivel 2</th>
    				<th class="text-center" width="5%">Nivel 3</th>
					<th class="text-center" width="10%">Propietario</th>
					<th class="text-center" id="dfaltantes" width="5%">Faltante<br>Proximos<br> días</th>
    			</tr>
    		</thead>
    		<tbody>
    		<?php
				$cuentaunid = 0;
				$contador = 0;
				$cuentanocumple = 0;
				$fec_1 = Date('Y-m-d H:i:s');
				$fec_hoy = new DateTime($fec_1);
				$meses_ultima_fab = $param['techo_fab']-$param['piso_fab'];
				$datos = fn_getDespieceSecuencia($_GET['nv'], $_GET['usr']);
				while($fila = $datos->fetch_array()){
					$iParametros = fn_listitem($fila['itemcode']);
					$itemsParametros = $iParametros->fetch_array();
					$stk_ciclo = fn_getStockDespieceItem($fila['itemcode']) / fn_getInsumoSumaBufferStock($fila['itemcode']);		
					$buff_ciclo = fn_getInsumoSumaBufferStock($fila['itemcode']);	
					$unidades = fn_getDespieceUnidades($fila['itemcode']);	
					$cant_requerida=$buff_ciclo * ($param['mesesprod'] * ($unidades  + ($param['segfactor']/100)));
					$activador = $fila['X'] + $param['fact_activa'];
					$fec = fn_getUltimaFabricacionDespiece($fila['itemcode']);
					$fec_ultimo = new DateTime($fec->format('Y-m-d H:i:s'));
					$diff = $fec_ultimo->diff($fec_hoy);
					$ultima_fab = ($diff->days) /30;
					if($fila['cantnecesaria2'] >= $fila['cantnecesaria'] ){
						$cant_mayor = $fila['cantnecesaria2'];
					} else {
						$cant_mayor = $fila['cantnecesaria'];
					}
					$enOF = 0;
					$enOC = 0;
					$totBod = $fila['stockbodega'];
					$cumple = '';
					if ($fila['cantnecesaria'] <= $totBod){
						$cumple = 'Sí';
					} else {
						$cumple = 'No';
						$cuentanocumple++;
					}
					if($_GET['nv'] == 0){
						$enOF = fn_getOrdenesFabricacionDespiece($fila['itemcode']);
						$totBod += $enOF;
					} elseif($_GET['nv'] == 1){
						$enOC = fn_getOrdenesCompraDespiece($fila['itemcode']);
						$totBod += $enOC;
					} elseif($_GET['nv'] == 2){
						$enOF = fn_getOrdenesFabricacionDespiece($fila['itemcode']);
						$enOC = fn_getOrdenesCompraDespiece($fila['itemcode']);
						$val = ($fila['U_Nivel1']=='410')?$enOF:$enOC;
						$totBod += $val;
					}
					$stock_bodegas =fn_getStockDespieceItem($fila['itemcode']);
					$faltante=($fila['cantnecesaria'] - $stock_bodegas);
					if($faltante < 0){
						$faltante=0;
					}
			?>
				<tr>
					<td class="text-start"><input type="checkbox" name="ordenes[]" value="<?=$fila['itemcode']?>"></td>
					<td class="text-start d-none"><?=$fila['U_Nivel1']?></td>
					<td class="text-center"><?=$fila['itemcode']?></td>
					<td class="text-start"><?=$fila['ItemName']?></td>
					<td class="text-end"><?=number_format(abs($fila['cantnecesaria']), 0, ',', '.')?></td>
					<td class="text-center"><?=$cumple?></td>
					<td class="text-end"><?=number_format(($cant_requerida), 0, ',', '.')?></td>
					<td class="text-end"><?=number_format(($stock_bodegas), 0, ',', '.')?></td>
					<?php
					if($_GET['nv'] == 0){
					?>
						<td id="enOF_<?=$fila['itemcode']?>"  class="text-end"><?=number_format($enOF, 0, ',', '.')?></td>
					<?php
					} elseif($_GET['nv'] == 1){
					?>
						<td id="enOC_<?=$fila['itemcode']?>"  class="text-end"><?=number_format($enOC, 0, ',', '.')?></td>
					<?php
					} elseif($_GET['nv'] == 2){
					?>
						<td id="enFC<?=$fila['itemcode']?>"  class="text-center"><?=number_format(($fila['U_Nivel1']=='410')?$enOF:$enOC, 0, ',', '.')?></td>
					<?php
					}
					
					?>
					<td class="text-center"><?=$fila['prioridad']?></td>
					<td class="text-center"><?=$fila['U_Nivel2']?></td>
					<td class="text-center"><?=$fila['U_Nivel3']?></td>
					<td class="text-center"><?=$fila['propietario']?></td>
					<td class="text-center" width="5%"><?=number_format(($faltante), 0, ',', '.')?></td>
				</tr>
            	<?php	
    				}
    			?>
    		</tbody>
    	</table>
    </div>
</div>
<div class="row">
	<div class="col-md-5 col-lg-5 col-sm-12 offset-md-7 offset-lg-7 text-end">
		<button class="btn btn-success btn-sm" onClick="expSinCab(3);" ><i class="fa fa-file-excel-o" aria-hidden="true"></i> Generar Excel</button>
		<!--<button class="btn btn-success btn-sm" onClick="genPDF3();"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Generar PDF</button>-->
	</div>
</div>
<script>
	
		var div = document.getElementById("div_loading");
            div.style.display = "none";

	w
	function genPDF3() {
		console.log('DTLT : '.dtlt)
		var arr = new Array();
		$('#result3 tr').each(function (){
			if($(this).find('td:first-child input').prop('checked') == true){
				var dat = new Array($(this).find('td:first-child input').val(), $(this).find('td:nth-last-child(1)').text());
				console.log("Contenido del array:", dat);
				arr.push(dat);
			}
		});
		$.ajax({
		type: 'post',
		url: './files/segprntGenDespiece.php',
		data: {
		dtlt: dtlt,
		fec : $('#fecha').val(),
		usr : $('#udt').val(),
		ordenes : arr
		},
		success: function (data) {
			window.open('./tmp/'+data, '_blank');
		}
	});
	} 
	function toggleCheckboxes() {
		// Obtén todos los elementos checkbox dentro de la tabla
		const checkboxes = document.querySelectorAll("#result3 tbody input[type='checkbox']");

		// Verifica si al menos un checkbox está marcado
		let atLeastOneChecked = false;
		checkboxes.forEach(checkbox => {
			if (checkbox.checked) {
				atLeastOneChecked = true;
			}
		});

		// Activa o desactiva todos los checkboxes en función del estado del primer checkbox
		checkboxes.forEach(checkbox => {
			checkbox.checked = !atLeastOneChecked;
		});
	}
</script>
