<?php
	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$('#result thead td').each( function () {
	      var title = $('#result thead td').eq( $(this).index() ).text();
	      $(this).html( '<input class="form-control form-control-sm" type="text" />' );
	  } );
		var table = $('#result').removeAttr('width').DataTable({
		 	dom: 'Brtip',
		  buttons: ['excel'],
				scrollY: '45vh',
				scrollX: '100%',
		  scrollCollapse: true,
				fixedHeader: false,
				"ordering": false,
		  paging: false,
				"pageLength": 100,
				responsive: true,
				"autoWidth": false,
				"language": {
		  	"info": "Registros visualizados: _MAX_",
					"search": "Buscar:",
					"zeroRecords": "No se han encontrado registros",
					"decimal": ",",
			  	"thousands": ".",
					"paginate": {
				    "first":      "Primera",
			      "last":       "Ultima",
			      "next":       "Siguiente",
			      "previous":   "Anterior"
		  	}
		  }
		});

		table.columns().every( function () {
		  var that = this;
		  $( 'input', this.header() ).on( 'keyup change', function () {
		  	that
		      .search( this.value )
		      .draw();
		  });
		});
	});
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div id="resultado" class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		    	<div class="row">
		    		<div class="col-md-10 col-sm-12 col-lg-10 text-start">
		      		<h5 class="card-title">Secuencia Semanal</h5>
		      	</div>
		      	<div class="col-md-2 col-sm-12 col-lg-2 text-end">
		      		<a class="btn btn-success btn-sm upd-modal" role="button" id="updBase" onClick="archivo();"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Exportar</a>
		      	</div>
					</div>
		    </div>
		    <div class="card-body">
    			<div class="row">
    				<div class="col-md-12 col-lg-12 col-sm-12">
    					<table id="result" class="display compact stripe hover" >
								<thead>
									<tr>
										<th align="center" width="2%">L&iacute;nea Unif.</th>
										<th align="center" width="2%">Correlativo</th>
										<th align="center" width="2%">L&iacute;nea</th>
										<th align="center" width="5%">C&oacute;digo</th>
										<th align="center" width="25%">Descripci&oacute;n</th>
										<th align="center" width="5%">Stock</th>
										<th align="center" width="5%">Buffer</th>
										<th align="center" width="3%">Base C&aacute;lculo Mensual (Und.)</th>
										<th align="center" width="5%">Meses Stock Sobre M&iacute;nimo</th>
										<th align="center" width="3%">Capacidad de L&iacute;nea</th>
										<th align="center" width="3%">P&eacute;rdida Ingresos Semana</th>
										<th align="center" width="7%">Unidades a Producir</th>
										<th align="center" width="7%">Estado</th>
										<th align="center" width="7%">Tiempo Estimado Item</th>
										<th align="center" width="7%">Tiempo Acumulado L&iacute;nea</th>
									</tr>
									<tr>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
									</tr>
								</thead>
								<tbody>
									<?php
									$datos = fn_getCalculoHistorico();
									$lin = '';
									$tmoLin = 0;
									while($rows = $datos->fetch_assoc()) {
										if ($lin != $rows['linea_unif']){
											$tmoLin = 0;
											$correlativo = 1;
										}
										if ($rows['estado'] != 'Despiece Incompleto'){
											$tmoLin += $rows['tmo_item'];
										}
										/*$buffer = 0;
										if(fn_getBuffer($rows['ItemCode']) != 0){
										    $buffer = fn_getBuffer($rows['ItemCode']);
										} else {*/
										    $buffer = fn_getBufferVentas2($rows['ItemCode']);
										//}
										?>
											<tr>
												<td align="center"><?=number_format($rows['linea_unif'], 0, ',', '.')?></td>
												<td align="center"><?=number_format($correlativo, 0, ',', '.')?></td>
												<td align="center"><?=fn_getNombreLinea($rows['linea_unif'])?></td>
												<td align="center"><?=$rows['ItemCode']?></td>
												<td align="left"><?=$rows['ItemName']?></td>
												<td align="right"><?=number_format($rows['OnHand'], 0, ',', '.') ?></td>
												<td align="right"><?=number_format($buffer, 0, ',', '.') ?></td>
												<td align="right"><?=number_format($rows['base_calc_mensual'], 0, ',', '.')?></td>
												<td align="right"><?=number_format($rows['meses_sobre_minimo'], 2, ',', '.')?></td>
								        <td align="right"><?=number_format($rows['capa_linea'], 0, ',', '.')?></td>
								        <td align="right"><?=number_format($rows['perdida_ingresos_semana'], 0, ',', '.')?></td>
												<td align="right"><?=number_format($rows['und_a_producir'], 0, ',', '.')?></td>
												<td align="center"><?=$rows['estado']?></td>
												<td align="right"><?=number_format($rows['tmo_item'], 2, ',', '.')?></td>
												<td align="right"><?=number_format($tmoLin, 2, ',', '.')?></td>
											</tr>
										<?php
										$lin = $rows['linea_unif'];
										$correlativo++;
									}
								?>
							</tbody>
						</table>
          </div>
		    </div>
		  </div>
	  </div>
	</div>
</div>