<?php
	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
	if(isset($_GET['res'])){
		if($_GET['res'] == 'true'){
			?>
				<div class="alert alert-dismissible alert-success text-center" role="alert">
					<button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
					  <i class="fa fa-times" aria-hidden="true"></i>
					</button>
					<p class="text-success">Los datos han sido guardados correctamente.</p>
				</div>
				<br>
			<?php
		} else {
			?>
				<div class="alert alert-danger text-center" role="alert">
					<button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
					  <i class="fa fa-times" aria-hidden="true"></i>
					</button>
					<p class="text-danger">Ha ocurrido un error almacenando los datos.</p>
					<p class="text-danger">Verifique la informaci&oacute;n ingresada.</p>
				</div>
				<br>
			<?php
		}
	} else {
		fn_setCalculoIntermedio();
	}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'Brtip',
    buttons: ['excel'],
		scrollY: '50vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		      <h5 class="card-title">Programa de Producci&oacute;n Recomendado</h5>
		    </div>
		    <div class="card-body">
    			<div class="row">
    				<div class="col-md-12 col-lg-12 col-sm-12">
    					<table id="result" class="display compact stripe hover" >
								<thead>
									<tr>
										<th align="center" width="2%">L&iacute;nea Unif.</th>
										<th align="center" width="2%">Correlativo</th>
										<th align="center" width="2%">L&iacute;nea</th>
										<th align="center" width="5%">C&oacute;digo</th>
										<th align="center" width="25%">Descripci&oacute;n</th>
										<th align="center" width="5%">Stock</th>
										<th align="center" width="3%">Base C&aacute;lculo Mensual (Und.)</th>
										<th align="center" width="5%">Meses Stock</th>
										<th align="center" width="3%">Capacidad de L&iacute;nea</th>
										<th align="center" width="3%">P&eacute;rdida Ingresos Semana</th>
										<th align="center" width="7%">Unidades Recomendadas</th>
										<th align="center" width="7%">Tiempo Estimado Item</th>
										<th align="center" width="7%">Tiempo Acumulado L&iacute;nea</th>
									</tr>
									<tr>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
									</tr>
								</thead>
								<tbody>
									<?php
									$datos = fn_getCalculoIntermedio(date("W"));
										$lin = '';
										$tmoLin = 0;
										while($rows = $datos->fetch_assoc()) {
											$capa = fn_getCapacidadLinea($rows['unif'])->fetch_assoc();
											if ($lin != $capa['unif']){
												$tmoLin = 0;
												$correlativo = 1;
											}
											$tmoItem = $rows['und_a_producir'] / $capa['cap_linea'];
											$tmoLin += $tmoItem;
											?>
												<tr>
													<td align="center"><?=number_format($rows['unif'], 0, ',', '.')?></td>
													<td align="center"><?=number_format($correlativo, 0, ',', '.')?></td>
													<td align="center"><?=fn_getNombreLinea($capa['unif'])?></td>
													<td align="center"><?=$rows['ItemCode']?></td>
													<td align="left"><?=$rows['ItemName']?></td>
													<td align="right"><?=number_format($rows['stock'], 0, ',', '.') ?></td>
													<td align="right"><?=number_format($rows['base_calc_mensual'], 0, ',', '.')?></td>
													<td align="right"><?=number_format($rows['meses_stk_minimo'], 2, ',', '.')?></td>
									        <td align="right"><?=number_format($capa['cap_linea'], 0, ',', '.')?></td>
									        <td align="right"><?=number_format($rows['perdida_ingresos'], 0, ',', '.')?></td>
													<td align="right"><?=number_format($rows['und_recomendada'], 0, ',', '.')?></td>
													<td align="right"><?=number_format($tmoItem, 2, ',', '.')?></td>
													<td align="right"><?=number_format($tmoLin, 2, ',', '.')?></td>
												</tr>
											<?php
											$lin = $capa['unif'];
											$correlativo++;
										}
									?>
								</tbody>
							</table>
							<div class="row">
								<div class="col-md-12 col-sm-12 col-lg-12 text-end">
									<a class="btn btn-success" role="button" href="api/savesecuencia.php?usrID=<?=$_SESSION['USERID']?>"><i class="fa fa-floppy-o" aria-hidden="true"></i> Guardar</a>
								</div>
							</div>
          	</div>
		    	</div>
		    </div>
	    </div>
	</div>
</div>