<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
  $('#result').DataTable({
   	dom: 'Bfrtip',
    buttons: ['excel'],
		scrollY: '50vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
		order: [[0, 'asc'], [11, 'asc'], [9, 'asc'], [10, 'asc']],
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });
});

</script>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		      <h5 class="card-title">Secuencia Programada.</h5>
		    </div>
		    <div class="card-body">
		    	<?php
		    		$fecha = fn_getlastdate()->fetch_assoc()['fecha'];
		    		$res2 = fn_gethist($fecha);
		    			if(mysqli_num_rows($res2) > 0){
		    				$params = fn_getParametrosCalculo('prd')->fetch_assoc();
		    				$diasprod = $params['diasprod'];
		    		?>
		    			<hr>
		    			<div class="row">
		    				<div class="col-md-12 col-lg-12 col-sm-12">
		    					<table id="result" class="display compact stripe hover" >
										<thead>
											<tr>
												<th align="center" width="2%">L&iacute;nea Unif.</th>
												<th align="center" width="2%">Correl.</th>
												<th align="center" width="5%">C&oacute;digo</th>
												<th align="center" width="25%">Descripci&oacute;n</th>
												<th align="center" width="3%">Stock</th>
												<th hidden>x&#772; Und. Prod. Anual</th>
												<th align="center" width="3%">Venta Mensual</th>
												<th align="center" width="3%">Producci&oacute;n M&iacute;nima</th>
												<th align="center" width="3%">Capacidad de L&iacute;nea</th>
												<th align="center" width="3%">Meses Stock Sobre M&iacute;nimo</th>
												<th hidden>Secuencia</th>
												<th align="center" width="7%">Perdida Ingresos Prox. 5 Dias</th>
												<th align="center" width="7%">Unidades Sugeridas</th>
												<th align="center" width="7%">Estado</th>
												<th align="center" width="7%">Unidades en Proceso</th>
												<th align="center" width="7%">Unidades Terminadas</th>
												<th align="center" width="7%">Tiempo Estimado Item</th>
												<th align="center" width="7%">Tiempo Acumulado L&iacute;nea</th>
												<th hidden align="center" width="7%">Tiempo Estimado L&iacute;nea</th>
												<th hidden align="center" width="7%">Prog. <?=$params['diasprod']?> D&iacute;as</th>
											</tr>
										</thead>
										<tbody>
										<?php
										$lin = '';
										$tmolin = 0;

										while($rows = $res2->fetch_assoc()) {
											$dp = fn_getDiasProductivos();
											$stock10 = $rows['OnHand'] - (($rows['und_vta_mes']/$dp)*$diasprod);
											$qrymul = "SELECT und_redondeo FROM tb_plan_param_redondeo WHERE ItemCode = '".$rows['ItemCode']."'";
											$res1 = $GLOBALS['connmy']->query($qrymul);
											$reqOF = fn_getofitem($rows['ItemCode']);
											if (sqlsrv_num_rows($reqOF) > 0){
												$isOF = sqlsrv_fetch_array($reqOF, SQLSRV_FETCH_ASSOC);
												if (mysqli_num_rows($res1) > 0){
													$fact = $res1->fetch_assoc()['und_redondeo'];
													if (round($rows['und_prod_ciclo']-$stock10) % $fact > 0){
														$mod = round($rows['und_prod_ciclo']-$stock10) % $fact;
														$suma = $fact - $mod;
														$unidades = round($rows['und_prod_ciclo']-$stock10) + $suma;
													} else {
														$unidades = round($rows['und_prod_ciclo']-$stock10);
													}
												}
												if (($rows['und_prod_ciclo'] > 0) || (($isOF["PlannedQty"]-$isOF['CmpltQty']) > 0)){
													if ($lin != $rows['linea_unif']){
														$corr = 1;
														$tmolin = 0;
														$tmo = fn_getoldTMO($rows['linea_unif'], $rows['fecha'])->fetch_assoc()['TMO'];
													}
													$tiempo = ($isOF["PlannedQty"]-$isOF['CmpltQty']) / $rows['cap_linea'];
													$tmolin += $tiempo;
												?>
													<tr>
														<td align="center"><?=number_format($rows['linea_unif'], 0, ',', '.')?></td>
														<td align="center"><?=number_format($corr, 0, ',', '.')?></td>
														<td align="center"><?=$rows['ItemCode']?></td>
														<td align="left"><?=$rows['ItemName']?></td>
														<td align="right"><?=number_format($rows['OnHand'], 0, ',', '.')?></td>
														<td hidden align="right"><?=number_format($rows['und_prod_mes'], 0, ',', '.')?></td>
														<td align="right"><?=number_format($rows['und_vta_mes'], 0, ',', '.')?></td>
										        <td align="right"><?=number_format($rows['prod_min'], 0, ',', '.')?></td>
										        <td align="right"><?=number_format($rows['cap_linea'], 0, ',', '.')?></td>
														<td align="right"><?=number_format($rows['meses_stk_min'], 2, ',', '.')?></td>
														<td align="left" hidden><?=number_format($rows['sum_secuencia'], 0, ',', '.')?></td>
														<td align="right">$ <?=number_format($rows['perd_ing_sem'], 0, ',', '.')?></td>
														<td align="right"><?=number_format($unidades, 0, ',', '.')?></td>
														<?php
															if ($isOF['Status']=='P'){
																echo '<td align="center">Planificada</td>';
																echo '<td align="right">'.number_format($isOF["PlannedQty"]-$isOF['CmpltQty'], 0, ',', '.').'</td>';
																echo '<td align="right">'.number_format($isOF['CmpltQty'], 0, ',', '.').'</td>';
															} elseif ($isOF['Status']=='R') {
																echo '<td align="center">Liberada</td>';
																echo '<td align="right">'.number_format($isOF["PlannedQty"]-$isOF['CmpltQty'], 0, ',', '.').'</td>';
																echo '<td align="right">'.number_format($isOF['CmpltQty'], 0, ',', '.').'</td>';
															}
														}	else {
															if (fn_valgenerado($rows['ItemCode'], $rows['und_prod_ciclo'], $_SESSION['USERID'])){
																echo '<td align="center">Emitida</td>';
																echo '<td align="right">0</td>';
																echo '<td align="right">0</td>';
															} else {
																if (fn_consultapiezas($rows['ItemCode'], $rows['und_prod_ciclo'])){
																	echo '<td align="center">Generar</td>';
																	//echo '<td align="center"><a href="api/genofprod.php?itm='.$rows['ItemCode'].'&qty='.$rows['und_prod_ciclo'].'&usr='.$_SESSION['USERID'].'" class="btn btn-success btn-xs" role="button">Generar</a></td>';
																	echo '<td align="right">0</td>';
																	echo '<td align="right">0</td>';
																} else {
																	echo '<td align="center">Despiece Incompleto</td>';
																	echo '<td align="right">0</td>';
																	echo '<td align="right">0</td>';
																}
															}
														}
														?>
														<td align="right"><?=number_format($tiempo, 2, ',', '.')?></td>
														<td align="right"><?=number_format($tmolin, 2, ',', '.')?></td>
														<td hidden align="right"><?=number_format($tmo, 2, ',', '.')?></td>
														<td hidden align="right"><?=number_format($tmolin, 2, ',', '.')?></td>
													</tr>
												<?php
												$lin = $rows['linea_unif'];
												$corr += 1;
											}
										}
										?>
										</tbody>
									</table>
		    				</div>
	          	</div>
						<?php
		    			} else {
		    				?>
		    				<hr>
		    				<div class="row">
		    					<div class="col-md-12 col-lg-12 col-sm-12 text-center">
		    						<p>No existen registros para la fecha seleccionada.</p>
		    					</div>
	    					</div>
	    					<?php
		    			}
	          ?>
		    	</div>
		    </div>
    </div>
	</div>