<?php
	$params = fn_getParametrosCalculo('prd')->fetch_assoc();
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$('#result thead td').each( function () {
	      var title = $('#result thead td').eq( $(this).index() ).text();
	      $(this).html( '<input class="form-control form-control-sm" type="text" />' );
	  } );
		var table = $('#result').removeAttr('width').DataTable({
		 	dom: 'Brtip',
		  buttons: ['excel'],
				scrollY: '45vh',
				scrollX: '100%',
		  scrollCollapse: true,
				fixedHeader: false,
				"ordering": false,
		  paging: false,
				"pageLength": 100,
				responsive: true,
				"autoWidth": false,
				"language": {
		  	"info": "Registros visualizados: _MAX_",
					"search": "Buscar:",
					"zeroRecords": "No se han encontrado registros",
					"decimal": ",",
			  	"thousands": ".",
					"paginate": {
				    "first":      "Primera",
			      "last":       "Ultima",
			      "next":       "Siguiente",
			      "previous":   "Anterior"
		  	}
		  }
		});

		table.columns().every( function () {
		  var that = this;
		  $( 'input', this.header() ).on( 'keyup change', function () {
		  	that
		      .search( this.value )
		      .draw();
		  });
		});

		const valores = window.location.search;
		const urlParams = new URLSearchParams(valores);
		if (urlParams.get('date') !== null){
			var fecha = new Date(urlParams.get('date'));
			var anni = fecha.getFullYear();
			var texto = 'Secuencia programada para la semana ' + urlParams.get('wk') + ' de ' + anni;
			$('#textoFiltro').text(texto);
			$('#BuscaFecha').val(urlParams.get('date'));
		} else {
			var fecha = new Date();
			var dia = '';
			if (fecha.getDate() < 10){
				dia = '0'+fecha.getDate();
			} else {
				dia = fecha.getDate();
			}
			var mes = '';
			if (fecha.getMonth()+1 < 10){
				mes = '0'+(fecha.getMonth()+1);
			} else {
				mes = fecha.getMonth()+1;
			}
			var anni = fecha.getFullYear();
			var hoy = "".concat(anni,"-",mes,"-",dia);
			$('#BuscaFecha').val(hoy);
		}

	});
</script>
<script type="text/javascript">
	function buscaDatos(){
		$('#modalEspera').modal('show');
		var fecha = $('#BuscaFecha').val();
		var semana = weekNumber(fecha);
		$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&date='+fecha+'&wk='+semana);
	}

	function weekNumber(fecha){
		var date = new Date(fecha);
	  var firstJanuary = new Date(date.getFullYear(), 0, 1);
	  var dayNr = Math.floor((date - firstJanuary) / (24 * 60 * 60 * 1000));
	  var weekNr = Math.ceil(dayNr / 7);
	  return weekNr;
	}
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div id="resultado" class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		    	<div class="row">
		    		<div class="col-md-6 col-sm-12 col-lg-6 text-start">
		      		<h5 class="card-title">Secuencia Semanal</h5>
		      	</div>
		      	<div class="col-md-6 col-sm-12 col-lg-6 text-end">
		      		<p id="textoFiltro"></p>
		      	</div>
					</div>
		    </div>
		    <div class="card-body">
		    	<div class="row">
		    		<div class="col-md-2 col-lg-2 col-sm-6 offset-md-3 offset-lg-3 offset-sm-1 text-center">
							<label class="form-label">Seleccione fecha a buscar: <br><small>(Considera semana completa)</small></label>
		    		</div>
		    		<div class="col-md-2 col-lg-2 col-sm-4">
							<input class="form-control form-control-sm" type="date" id="BuscaFecha" >
						</div>
		    		<div class="col-md-1 col-lg-1 col-sm-12 text-center">
							<a class="btn btn-success btn-sm" role="button" onClick="buscaDatos();"><i class="fa fa-search" aria-hidden="true"></i> Buscar</a>
		    		</div>
		    	</div>
    			<div class="row py-2">
    				<div class="col-md-12 col-lg-12 col-sm-12">
    					<p>Con Stock por debajo de <?=$params['corte_prod']?> <?=($params['corte_prod']==1)?'Mes':'Meses' ?></p>
    					<table id="result" class="display compact stripe hover" >
								<thead>
									<tr>
										<th align="center" width="2%">L&iacute;nea Unif.</th>
										<th align="center" width="2%">Correlativo</th>
										<th align="center" width="2%">L&iacute;nea</th>
										<th align="center" width="5%">C&oacute;digo</th>
										<th align="center" width="25%">Descripci&oacute;n</th>
										<th align="center" width="5%">Stock</th>
										<th align="center" width="3%">Base C&aacute;lculo Mensual (Und.)</th>
										<th align="center" width="5%">Meses Stock Sobre M&iacute;nimo</th>
										<th align="center" width="3%">Capacidad de L&iacute;nea</th>
										<th align="center" width="3%">P&eacute;rdida Ingresos Semana</th>
										<th align="center" width="7%">Unidades a Producir</th>
										<th align="center" width="7%">Estado</th>
										<th align="center" width="7%">Tiempo Estimado Item</th>
										<th align="center" width="7%">Tiempo Acumulado L&iacute;nea</th>
									</tr>
									<tr>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
										<td align="center"></td>
									</tr>
								</thead>
								<tbody>
									<?php
									if (isset($_GET['wk'])){
										$datos = fn_getCalculoHistorico($_GET['wk']);
										$lin = '';
										$tmoLin = 0;
										while($rows = $datos->fetch_assoc()) {
											if ($rows['meses_stk_minimo'] <= $params['corte_prod']){
												if ($lin != $rows['linea_unif']){
													$tmoLin = 0;
													$correlativo = 1;
												}
												if ($rows['estado'] != 'Despiece Incompleto'){
													$tmoLin += $rows['tmo_item'];
												}
												?>
												<tr>
													<td align="center"><?=number_format($rows['linea_unif'], 0, ',', '.')?></td>
													<td align="center"><?=number_format($correlativo, 0, ',', '.')?></td>
													<td align="center"><?=fn_getNombreLinea($rows['linea_unif'])?></td>
													<td align="center"><?=$rows['ItemCode']?></td>
													<td align="left"><?=fn_getNombreItem($rows['ItemCode'])?></td>
													<td align="right"><?=number_format($rows['OnHand'], 0, ',', '.') ?></td>
													<td align="right"><?=number_format($rows['base_calc_mensual'], 0, ',', '.')?></td>
													<td align="right"><?=number_format($rows['meses_sobre_minimo'], 2, ',', '.')?></td>
									        <td align="right"><?=number_format($rows['capa_linea'], 0, ',', '.')?></td>
									        <td align="right"><?=number_format($rows['perdida_ingresos_semana'], 0, ',', '.')?></td>
													<td align="right"><?=number_format($rows['und_a_producir'], 0, ',', '.')?></td>
													<td align="center"><?=$rows['estado']?></td>
													<td align="right"><?=number_format($rows['tmo_item'], 2, ',', '.')?></td>
													<td align="right"><?=number_format($tmoLin, 2, ',', '.')?></td>
												</tr>
											<?php
											$lin = $rows['linea_unif'];
											$correlativo++;
											}
										}
									}
								?>
							</tbody>
						</table>
          </div>
		    </div>
		  </div>
	  </div>
	</div>
</div>