<?php
$ult = fn_getUltimaFechaCalculo()->fetch_assoc()['fec_get'];
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'Brtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
  <div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		      <h5 class="card-title">Secuencia de Despieces (Bodega).</h5>
		    </div>
		    <div class="card-body">
					<table id="result" class="display compact stripe hover" >
						<thead>
							<tr>
								<th align="center" width="5%">C&oacute;digo</th>
								<th align="center" width="25%">Descripci&oacute;n</th>
								<th  align="center" width="3%">Stock</th>
								<th  align="center" width="3%">Capacidad de L&iacute;nea</th>
								<th  align="center" width="3%">Meses Stock Sobre M&iacute;nimo</th>
								<th align="center" width="7%">Unidades a Producir</th>
							</tr>
							<tr>
								<td align="center"></td>
								<td align="center"></td>
								<td  align="center"></td>
								<td  align="center"></td>
								<td  align="center"></td>
								<td align="center"></td>
							</tr>
						</thead>
						<tbody>
						<?php
						$sec = fn_getSecuenciaCalculo($ult);
							while($rows = $sec->fetch_assoc()) {
								fn_getValidaDespieceItem($rows['ItemCode']);
								$capacidad = fn_getCapacidadLinea($rows['U_Nivel2'])->fetch_assoc()['cap_linea'];
								?>
									<tr>
										<td align="center"><a class="li-modal" href="plan/showdesp.php?itm=<?=$rows['ItemCode']?>&cnt=<?=$rows['und_a_producir']?>"><?=$rows['ItemCode']?></a></td>
										<td align="left">$ <?=$rows['ItemName']?></td>
										<td align="right"><?=number_format($rows['stock'], 0, ',', '.')?></td>
						        <td align="right"><?=number_format($capacidad, 0, ',', '.')?></td>
										<td align="right"><?=number_format($rows['meses_stk_minimo'], 2, ',', '.')?></td>
										<td align="right"><?=number_format($rows['und_a_producir'], 0, ',', '.')?></td>
									</tr>
								<?php
							}
						?>
						</tbody>
					</table>
				</div>
		  </div>
	</div>
</div>
