<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script type="text/javascript">
	$(document).ready(function() {

		$('#result thead td').each( function () {
	    	var title = $('#result thead td').eq( $(this).index() ).text();
	    	$(this).html( '<input class="form-control form-control-sm" type="text" />' );
	  	});

		var table = $('#result').removeAttr('width').DataTable({
		 	dom: 'rtip',
		  buttons: ['excel'],
				scrollY: '50vh',
				scrollX: '100%',
		  scrollCollapse: true,
				fixedHeader: false,
				loadingRecords: "Cargando...",
			      processing: "Procesando....",
				"ordering": false,
		  paging: false,
				"pageLength": 100,
				responsive: true,
				"autoWidth": false,
				"language": {
		  	"info": "Mostrando _TOTAL_ de _MAX_ registros",
					"search": "Buscar:",
					"zeroRecords": "No se han encontrado registros",
					"decimal": ",",
			  	"thousands": ".",
					"paginate": {
				    "first":      "Primera",
			      "last":       "Ultima",
			      "next":       "Siguiente",
			      "previous":   "Anterior"
		  	}
		  }
		});
		var filas = $('#result tr').length -1;
		if(filas > 1){
			$('#checkAll').prop('checked', true);
			$('#result tr td:first-child input').each(function (){
				$(this).prop('checked', true);
			});
		}

		var TabTrigger = document.querySelector('#filsel-tab');
		var tab = new bootstrap.Tab(TabTrigger);
		tab.show();

	});
</script>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		<div class="card">
	    	<div class="card-header bg-success">
	    		<div class="row">
	    			<div class="col-md-12 col-sm-12 col-lg-12">
	      				<h5 class="card-title">Secuencia Papeles</h5>
	      			</div>
				</div>
	    	</div>
	    	<div class="card-body">
	    		<div class="row">
	    			<div class="col-md-2 col-lg-2 col-sm-12 offset-md-2 offset-lg-2 text-center">
	    				<label class="form-label">Revisi&oacute;n de intervalo de</label>
	    			</div>
	    			<div class="col-md-1 col-lg-1 col-sm-12 text-center">
	    				<input class="form-control form-control-sm" type="number" id="intervalo" name="intervalo" min="1"/>
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12 text-center">
	    				<label class="form-label">d&iacute;as, a contar desde el d&iacute;a </label>
	    			</div>
	    			<div class="col-md-1 col-lg-1 col-sm-12 text-center">
	    				<input class="form-control form-control-sm" type="number" id="dia_inicial" name="dia_inicial"/>
	    			</div>
	    			<div class="col-md-1 col-lg-1 col-sm-12 text-center">
	    				<button class="btn btn-sm btn-success" onClick="cargaFiltros();"><i class="fa fa-search" aria-hidden="true"></i> Buscar</button>
	    			</div>
    			</div>
	    		<hr>
	    		<div class="row py-1">
	    			<div class="col-md-12 col-lg-12 col-sm-12">
	    				<ul class="nav nav-tabs" id="myTab" role="tablist">
                        	<li class="nav-item" role="presentation">
                            	<button class="nav-link link-success" id="filsel-tab" data-bs-toggle="tab" data-bs-target="#filtros_seleccionados" type="button" role="tab" aria-controls="filtros_seleccionados" aria-selected="false">Filtros Seleccionados</button>
                        	</li>
                        	<li class="nav-item" role="presentation">
                            	<button class="nav-link link-success" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">Detalle de  Papeles Seleccionados</button>
                        	</li>
                        </ul>
                        <div class="tab-content" id="tabContenido">
                        	<div class="tab-pane fade" id="filtros_seleccionados" role="tabpanel" aria-labelledby="filsel-tab">
                        		<div class="card">
            					    <div class="card-header bg-success">
            					    	<div class="row">
            					    		<div class="col-md-12 col-sm-12 col-lg-12">
					      						<h5 class="card-title text-center">Filtros Seleccionados</h5>
					      					</div>
										</div>
					   				</div>
					    			<div class="card-body">
    									<div id="datos-sec">
    										<p>No se han seleccionado filtros para procesar su despiece</p>
										</div>
									</div>
								</div>
                        	</div>
                        	<div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
								<div class="card">
            					    <div class="card-header bg-success">
            					    	<div class="row">
            					    		<div class="col-md-12 col-sm-12 col-lg-12">
					      						<h5 class="card-title text-center">Detalle de Papeles Seleccionados</h5>
					      					</div>
										</div>
					   				</div>
					    			<div class="card-body">
					    				<div id="datos-despieces">
											<p>No se han seleccionado filtros para procesar su corte de papel</p>
										</div>
									</div>
								</div>
							</div>
                       </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
function cargaFiltros(){
	var TabTrigger = document.querySelector('#filsel-tab');
	var tab = new bootstrap.Tab(TabTrigger);
	tab.show();
	$('#datos-sec p').text('Procesando...');
	$('#datos-despieces p').text('Procesando...');
	var intervalo = $('#intervalo').val();
	var inicio = $('#dia_inicial').val();
	if(intervalo != '' && inicio !=''){
		$('#datos-sec').load('./<?=$_GET['sys']?>/secPapelcab.php?ini='+inicio+'&inter='+intervalo+'&usr=<?=$_SESSION['USERID'] ?>');
	} else {
		$('#datos-sec p').text('No se han seleccionado filtros para procesar su corte de papel');
	}
};

function cargaDespieces(){
	var TabTrigger = document.querySelector('#contact-tab');
	var tab = new bootstrap.Tab(TabTrigger);
	tab.show();
	$('#datos-despieces p').text('Procesando...');
	$('#datos-despieces').load('./<?=$_GET['sys']?>/secPapeldet.php?usr=<?=$_SESSION['USERID'] ?>');
};
</script>
