<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

function actualiza(){
	muestraProc();
	$.ajax({
		type: 'POST',
    dataType: "json",
    url : "api/hlp/hlpGetRecetas.php",
    success: function(response) {
    	if (response.resp == 'true') {
    		$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=true');
      } else {
    	  $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=false');
      }
    }
	});
}

function buscar(){
	muestraProc();
	var item = $('#txtCodigo').val();
  $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&itm=' + item);
}

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <div class="row">
	    		<div class="col-md-6 col-sm-12 col-lg-6 text-start">
	      		<h5 class="card-title">Maestro de Recetas.</h5>
	      	</div>
					<div class="col-md-4 col-sm-12 col-lg-4 text-end">
						<span>Ultima actualizaci&oacute;n: <?=fn_getLastFecGet('tb_plan_recetas')?></span>
					</div>
					<?php
				if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])){
					?>
					<div class="col-md-2 col-sm-12 col-lg-2 text-end">
						<a class="btn btn-success btn-sm upd-modal" role="button" id="updBase" onClick="actualiza();"><i class="fa fa-refresh" aria-hidden="true"></i> Actualizar</a>
					</div>
					<?php
				}
				?>
				</div>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
	    			<div class="row py-2">
	    				<div class="col-md-3 col-lg-3 col-sm-12 offset-md-3 offset-lg-3 text-end">
								<label for="itm" class="form-label">Ingrese el C&oacute;digo a Consultar :</label>
							</div>
							<div class="col-md-1 col-lg-1 col-sm-12">
								<input type="text" class="form-control form-control-sm" id="txtCodigo" name="txtCodigo" placeholder="ItemCode">
							</div>
							<div class="col-md-2 col-lg-2 col-sm-12">
								<button type="button" class="btn btn-success btn-sm" onClick="buscar();"><i class="fa fa-search" aria-hidden="true"></i> Buscar</button>
							</div>
						</div>
	    			<div class="row py-1">
	    				<div class="col-md-12 col-lg-12 col-sm-12">
								<table id="result" class="display compact stripe hover" >
									<thead>
										<tr>
											<th align="center" width="5%">C&oacute;digo Padre</th>
											<th align="center" width="15%">Descripci&oacute;n</th>
											<th align="center" width="3%">Cantidad Padre</th>
											<th align="center" width="5%">C&oacute;digo Hijo</th>
											<th align="center" width="15%">Descripci&oacute;n</th>
											<th align="center" width="3%">Cantidad Hijo</th>
											<th align="center" width="3%">Bodega por Defecto</th>
										</tr>
										<tr class="text-center">
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
										</tr>
									</thead>
									<tbody>
										<?php
										if (isset($_GET['itm'])){
											$datos = fn_getRecetaItem($_GET['itm']);
											while($fila = $datos->fetch_assoc()){
										?>
										<tr>
											<td class="text-center"><?=$fila['padre']?></td>
											<td class="text-start"><?=fn_getNombreItem($fila['padre'])?></td>
											<td class="text-end"><?=$fila['cant_padre']?></td>
											<td class="text-center"><?=$fila['hijo']?></td>
											<td class="text-start"><?=$fila['descripcion']?></td>
											<td class="text-end"><?=$fila['cantidad']?></td>
											<td class="text-end"><?=$fila['bodega']?></td>
										</tr>
										<?php
											}
										}
										?>
									</tbody>
								</table>
							</div>
						</div>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>