<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    	scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    	paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
			"info": "Registros visualizados: _TOTAL_ de _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ".",
			"thousands": ",",
			"paginate": {
			"first":      "Primera",
			"last":       "Ultima",
			"next":       "Siguiente",
			"previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

  const valores = window.location.search;
	const urlParams = new URLSearchParams(valores);
	if (urlParams.get('ms') !== null){
		$('#txtCorte').val(urlParams.get('ms'));
		$('#txtDiasProd').val(urlParams.get('dp'));
	}
});

	function actualiza(){
		muestraProc();
		$.ajax({
			url: 'api/hlp/hlpUpdRecetasOF.php',
			dataType: 'json',
			success: function(resp){
				if (resp == 1){
					$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=1');
				} else {
					$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=0');
				}

			}
		});
	}

	function buscar(){
		muestraProc();
		var item = $('#txtCodigo').val();
	  $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&itm=' + item);
	}
</script>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	    	<div class="row">
	    		<div class="col-md-6 col-lg-6 col-sm-12">
	    			<h5 class="card-title">Recetas OF</h5>
	    		</div>
	    		<div class="col-md-6 col-lg-6 col-sm-12 text-end">
	    			<button class="btn btn-success btn-sm" onClick="actualiza();"><i class="fa fa-refresh" aria-hidden="true"></i> Actualizar</button>
	    		</div>
	    	</div>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
						<div class="row py-2">
	    				<div class="col-md-3 col-lg-3 col-sm-12 offset-md-3 offset-lg-3 text-end">
								<label for="itm" class="form-label">Ingrese el C&oacute;digo Padre :</label>
							</div>
							<div class="col-md-1 col-lg-1 col-sm-12">
								<input type="text" class="form-control form-control-sm" id="txtCodigo" name="txtCodigo" placeholder="ItemCode">
							</div>
							<div class="col-md-2 col-lg-2 col-sm-12">
								<button type="button" class="btn btn-success btn-sm" onClick="buscar();"><i class="fa fa-search" aria-hidden="true"></i> Buscar</button>
							</div>
						</div>
	    		</div>
	    	</div>
	    	<div class="row py-1">
    			<div class="col-md-12 col-lg-12 col-sm-12">
						<table id="result" class="display compact stripe hover" >
							<thead>
								<tr>
									<th class="text-center" width="3%">Num. OF</th>
									<th class="text-center" width="3%">Orden L&iacute;nea</th>
									<th class="text-center" width="3%">C&oacute;digo Hijo</th>
									<th class="text-center" width="15%">Descripci&oacute;n</th>
									<th class="text-center" width="5%">Cantidad Base</th>
									<th class="text-center" width="5%">Cantidad Requerida</th>
									<th class="text-center" width="5%">Cantidad Utilizada</th>
									<th class="text-center" width="3%">Bodega por Defecto</th>
								</tr>
								<tr class="text-center">
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
								</tr>
							</thead>
							<tbody>
								<?php
							if (isset($_GET['itm'])){
								$datos = fn_getRecetaOF($_GET['itm']);
								while($fila = $datos->fetch_assoc()){
							?>
							<tr>
								<td class="text-center"><?=$fila['DocEntry']?></td>
								<td class="text-center"><?=$fila['linenum']?></td>
								<td class="text-center"><?=$fila['cod_hijo']?></td>
								<td class="text-start"><?=$fila['itemname']?></td>
								<td class="text-end"><?=$fila['baseqty']?></td>
								<td class="text-end"><?=$fila['plannedqty']?></td>
								<td class="text-end"><?=$fila['issuedqty']?></td>
								<td class="text-end"><?=$fila['warehouse']?></td>
							</tr>
							<?php
								}
							}
							?>
							</tbody>
						</table>
					</div>
				</div>
	    </div>
    </div>
	</div>
</div>