<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
  $('#result').DataTable({
   	dom: 'Bfrtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": true,
		order: [[1, 'asc']],
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });
});
</script>
<div class="row">
  <div class="col-md-12 col-lg-12 col-sm-12">
		<div class="bs-example" data-example-id="panel-with-heading" >
		  <div class="panel panel-success">
		    <div class="panel-heading">
		      <h3 class="panel-title">Ordenes de Producción Vigentes.</h3>
		    </div>
		    <div class="panel-body">
					<table id="result" class="display compact stripe hover" >
						<thead>
							<tr>
								<th align="center" width="5%">N&deg; Dcto.</th>
								<th align="center" width="5%">Fec. Creaci&oacute;n</th>
								<th align="center" width="3%">C&oacute;digo Item</th>
								<th align="center" width="20%">Descripci&oacute;n</th>
								<th align="center" width="3%">Estado</th>
								<th align="center" width="3%">Planificado</th>
								<th align="center" width="3%">Completado</th>
								<th align="center" width="3%">Comentarios</th>
							</tr>
						</thead>
						<tbody>
						<?php
						$req = fn_getofvigentes();
						while($rows = sqlsrv_fetch_array( $req, SQLSRV_FETCH_ASSOC)) {
							if ($rows['Status'] == 'R'){
								$estado = 'Liberado';
							} elseif ($rows['Status'] == 'P'){
								$estado = 'Pendiente';
							}
							?>
								<tr>
									<td align="center"><?=$rows['DocNum']?></td>
									<td align="center"><?=$rows['PostDate']?></td>
									<td align="center"><?=$rows['ItemCode']?></td>
									<td align="left"><?=$rows['ItemName']?></td>
									<td align="center"><?=$estado?></td>
									<td align="right"><?=number_format($rows['PlannedQty'], 0, ',', '.')?></td>
									<td align="right"><?=number_format($rows['CmpltQty'], 0, ',', '.')?></td>
									<td align="left"><?=$rows['Comments']?></td>
								</tr>
							<?php
						}
						?>
						</tbody>
					</table>
				</div>
		  </div>
		</div>
	</div>
</div>