<?php
date_default_timezone_set("America/Santiago");
setlocale(LC_TIME, 'es_CL.UTF-8');

$data2 = fn_getSeparaPlantasDia();
$serieX = array();
$serieY = array();
while($porc = $data2->fetch_assoc()){
    array_push($serieX, $porc['porcentaje']);
    array_push($serieY, intval($porc['dia_quiebre']));
}

?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<script type="text/javascript">
function actualiza(){
	muestraProc();
	$.ajax({
		type: 'POST',
    dataType: "json",
    url : "api/job/midePlantas.php",
    success: function(response) {
    	if (response.resp == 'true') {
    		$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>');
      } else {
    	  $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>');
      }
    }
	});
}
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	    	<div class="row">
	    		<div class="col-md-10 col-lg-10 col-sm-12">
	    			<h5 class="card-title">Distancia entre Plantas (D&iacute;as)</h5>
	    		</div>
	    		<?php
				if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])){
					?>
					<div class="col-md-2 col-sm-12 col-lg-2 text-end">
						<a class="btn btn-success btn-sm upd-modal" role="button" id="actualiza" onClick="actualiza();"><i class="fa fa-refresh" aria-hidden="true"></i> Actualizar</a>
					</div>
					<?php
				}
				?>
	    	</div>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
	    			<div id="graph2"></div>
	    		</div>
	    	</div>
	    	<div class="row py-3">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
					<table id="result" class="display compact stripe hover">
						<thead>
							<tr>
								<th class="text-center">Fecha</th>
								<th class="text-center">Hora</th>
								<th class="text-center">Resultado</th>
								<th class="text-center">%</th>
								<th class="text-center">Tiempo de Proceso</th>
								<th class="text-center">Hora Inicio</th>
								<th class="text-center">Hora T&eacute;rmino</th>
							</tr>
						</thead>
						<tbody>
							<?php
						      $lista = fn_getMidePlantas();
						      while ($fila = $lista->fetch_assoc()){
						          ?>
									<tr>
										<td class="text-center"><?=$fila['fecha'] ?></td>
										<td class="text-center"><?=$fila['hora'] ?></td>
										<td class="text-left"><?=$fila['mensaje'] ?></td>
										<td class="text-center"><?=$fila['porcentaje'] ?></td>
										<td class="text-center"><?=$fila['tiempo'] ?></td>
										<td class="text-center"><?=$fila['hra_inicio'] ?></td>
										<td class="text-center"><?=$fila['hra_termino'] ?></td>
									</tr>
						          <?php
						      }
							?>
						</tbody>
					</table>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>
<script>
var dia = "<?=strftime('%d de %B de %Y') ?>";
$(function() {
	var grafico1 = new Highcharts.chart({
		chart: {
		    type: 'area',
		    renderTo: 'graph2'
		},
		title: {
		    text: 'Variaci&oacute;n '+dia
		},
		xAxis: [{
	    	categories: <?=json_encode($serieX) ?>,
	    	title: {
				text: 'Porcentaje'
	    	},
	    	labels: {
		    	rotation: -45
	    	}
	  	}],
	  	yAxis: [{
		    title: {
		      text: 'D&iacute;as'
		    },
		    visible: true
		}],
		series: [{
			name: 'Distancia entre Plantas (D&iacute;as)',
			data: <?=json_encode($serieY) ?>
		}]
	});
});
</script>