<?php
$params = fn_getParametrosCalculo('prd')->fetch_assoc();
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'Brtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
  <div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Disponibilidad de Despieces (<?= $params['mesesprod'] ?> <?= ($params['mesesprod'] == 1)?'mes':'meses' ?>).</h5>
	    </div>
	    <div class="card-body">
				<table id="result" class="display compact stripe hover" >
					<thead>
						<tr>
							<th align="center" width="5%">C&oacute;digo</th>
							<th align="center" width="25%">Descripci&oacute;n</th>
							<th align="center" width="3%">Stock Actual</th>
							<th align="center" width="3%">Tiene OF</th>
							<th align="center" width="3%">Tiene OC</th>
							<th align="center" width="3%">Estado</th>
							<th align="center" width="3%">Planificado</th>
							<th align="center" width="3%">Completado</th>
							<th align="center" width="3%">Pendiente</th>
							<th align="center" width="3%">Cantidad Requerida <br>(<?= $params['diasprod'] ?> <?= ($params['diasprod'] == 1)?'d&iacute;a':'d&iacute;as' ?>)</th>
							<th align="center" width="3%">Diferencia <br>(<?= $params['diasprod'] ?> <?= ($params['diasprod'] == 1)?'d&iacute;a':'d&iacute;as' ?>)</th>
							<th align="center" width="3%">Cantidad Requerida <br>(<?= $params['mesesprod'] ?> <?= ($params['mesesprod'] == 1)?'mes':'meses' ?>)</th>
							<th align="center" width="3%">Diferencia <br>(<?= $params['mesesprod'] ?> <?= ($params['mesesprod'] == 1)?'mes':'meses' ?>)</th>
						</tr>
						<tr>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
							<td align="center"></td>
						</tr>
					</thead>
					<tbody>
					<?php
					$req = fn_getdispdespiece();
					$pormes = ($params['mesanalisis'] * 100) / $params['mesesprod'];
					$pordia = $params['diasprod'] * 100 / ($params['mesesprod'] * 30);
					while($rows = $req->fetch_assoc()) {
						$stock = fn_getStockDespieceItem($rows['hijo']);
						$dtaof = fn_getofvigdesp($rows['hijo']);
						if (sqlsrv_num_rows($dtaof) > 0){
							$despof = sqlsrv_fetch_array( $dtaof, SQLSRV_FETCH_ASSOC);
							$tiene = 'Si';
							$estado = ($despof['Status'] == 'R')? 'Liberada': 'Pendiente';
							$planif = $despof['planeado'];
							$complet = $despof['Completo'];
							$pendiente = $despof['Pendiente'];
						} else {
							$tiene = '';
							$estado = '---';
							$planif = 0;
							$complet = 0;
							$pendiente = 0;
						}
						$reqan = $rows['cant_despiece'] / $pordia;
						$difan = $stock - $reqan;
						$reqpor = ($rows['cant_despiece'] * $pormes) / 100;
						$difpor = $stock - $reqpor;
						$dif = $stock - $rows['cant_despiece'];
						?>
							<tr>
								<td align="center"><a class="li-modal" href="plan/showdetdesp.php?itm=<?=$rows['hijo']?>&qty=<?=$rows['cant_despiece']?>"><?=$rows['hijo']?></a></td>
								<td align="left"><?=$rows['descripcion']?></td>
								<td align="right"><?=number_format($stock, 0, ',', '.')?></td>
								<td align="center"><?=$tiene?></td>
								<td align="center">--</td>
								<td align="center"><?=$estado?></td>
								<td align="right"><?=number_format($planif, 0, ',', '.')?></td>
								<td align="right"><?=number_format($complet, 0, ',', '.')?></td>
								<td align="right"><?=number_format($pendiente, 0, ',', '.')?></td>
								<td align="right"><?=number_format($reqan, 0, ',', '.')?></td>
								<td align="right"><?=number_format($difan, 0, ',', '.')?></td>
								<td align="right"><?=number_format($rows['cant_despiece'], 0, ',', '.')?></td>
								<td align="right"><?=number_format($dif, 0, ',', '.')?></td>
							</tr>
						<?php
					}
					?>
					</tbody>
				</table>
			</div>
	  </div>
	</div>
</div>