<?php
	if(isset($_GET['code'])){
		if($_GET['code'] == 1){
			?>
				<div class="alert alert-dismissible alert-success text-center" role="alert">
					<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
					<p class="text-success">Los datos han sido actualizados correctamente.</p>
				</div>
			<?php
		} else {
			?>
				<div class="alert alert-dismissible alert-danger text-center" role="alert">
					<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
					<p class="text-danger">Ha ocurrido un error actualizando los datos.</p>
					<p class="text-danger">Verifique la informaci&oacute;n ingresada.</p>
				</div>
			<?php
		}
	}
	if (isset($_GET['upd'])){
		if ($_GET['upd'] == 'true'){
			fn_getCapacidadesProductivas();
		}
	}
	if ((isset($_GET['mes'])) && (isset($_GET['anni']))){
		$fecha = $_GET['mes'] . '-' . $_GET['anni'];
	} else {
		$fecha = date('m-Y');
	}
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	//carga combos
	var fecha = new Date();
	var anni = fecha.getFullYear();
	var opt = "<option value='nada'>&lt;&lt; Seleccione Año &gt;&gt;</option>";
	for(var x = 2022; x <= anni; x++){
		opt += '<option value="'+x+'">'+x+'</option>';
	}
	$('#cboAnni').html(opt);

	//data Table
  $('#result').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
		order: [[0, 'asc'], [2, 'asc']],
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  	const valores = window.location.search;
	const urlParams = new URLSearchParams(valores);
	if (urlParams.get('mes') !== null){
		$('#cboMes').val(urlParams.get('mes'));
		$('#cboAnni').val(urlParams.get('anni'));
	}
});
</script>
<script type="text/javascript">
	function NewFact(item, code){
		if (code == 0){
			var newval = new String(prompt("Ingrese Capacidad Manual: ", ""));
			if(newval.length > 0 && newval != 'null'){
	    	window.location="./api/modcapamanual.php?item="+ item + "&newval=" + newval;
	    }
		} else if (code == 1) {
			var newval = new String(prompt("Ingrese Número de Línea a la que desea unificar: ", ""));
			if(newval.length > 0 && newval != 'null'){
	    	window.location="./api/modunilinea.php?item="+ item + "&newval=" + newval;
	    }
		}
	}
	function getDatosFiltros(){
		muestraProc();
		var par = '';
		if ($('#cboMes').val() != 'nada'){
			par += '&mes='+$('#cboMes').val();
			if ($('#cboAnni').val() != 'nada'){
				par += '&anni='+$('#cboAnni').val();
			} else {
				par = '';
			}
		}
		if (par == ''){
			$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>');
		} else {
			$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>'+par);
		}
	}
</script>
<div class="row">
  <div class="col-md-8 col-lg-8 col-sm-12 offset-md-2 offset-lg-2">
	  <div class="card">
	    <div class="card-header bg-success">
	    	<div class="row">
	    		<div class="col-md-6 col-sm-6 col-lg-6">
	    			<h5 class="card-title">Capacidad de L&iacute;nea</h5>
	    		</div>
	    		<?php
						if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])) {
					?>
					<div class="col-md-6 col-sm-6 col-lg-6 text-end">
						<a class="btn btn-success btn-sm upd-modal" href="?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&upd=true" role="button" id="updBase"><i class="fa fa-refresh" aria-hidden="true"></i> Actualizar</a>
					</div>
					<?php
						}
					?>
	    	</div>
	    </div>
	    <div class="card-body">
	    	<div class="row py-2">
	    		<div class="col-md-3 col-sm-6 col-lg-3 offset-md-2 offset-lg-2">
		    		<select class="form-select form-select-sm" id="cboMes" required>
		    			<option selected value='nada'>&lt;&lt; Seleccione Mes &gt;&gt;</option>
		    			<option value='01'>Enero</option>
		    			<option value='02'>Febrero</option>
		    			<option value='03'>Marzo</option>
		    			<option value='04'>Abril</option>
		    			<option value='05'>Mayo</option>
		    			<option value='06'>Junio</option>
		    			<option value='07'>Julio</option>
		    			<option value='08'>Agosto</option>
		    			<option value='09'>Septiembre</option>
		    			<option value='10'>Octubre</option>
		    			<option value='11'>Noviembre</option>
		    			<option value='12'>Diciembre</option>
						</select>
		    	</div>
		    	<div class="col-md-3 col-sm-6 col-lg-3">
		    		<select class="form-select form-select-sm" id="cboAnni" required>
						</select>
		    	</div>
		    	<div class="col-md-2 col-sm-6 col-lg-2 text-center">
	    			<a class="btn btn-success btn-sm upd-modal" role="button" id="updBase" onClick="getDatosFiltros();"><i class="fa fa-search" aria-hidden="true"></i> Buscar</a>
	    		</div>
	    	</div>
	    	<div class="row py-2">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
			    	<table id="result" class="display compact stripe hover" >
							<thead>
								<tr>
									<th align="center" width="7%">ID L&iacute;nea</th>
									<th align="center" width="20%">Descripci&oacute;n</th>
									<th align="center" width="7%">L&iacute;nea Unificada</th>
									<th align="center" width="20%">Descripci&oacute;n L&iacute;nea Unificada</th>
									<th align="center" width="7%">Capacidad de L&iacute;nea</th>
									<th align="center" width="7%">Capacidad Manual</th>
								</tr>
							</thead>
							<tbody>
							<?php
							$lineas = fn_getCapacidadesLineas($fecha);
							while ($fila = $lineas->fetch_assoc()){
								$linunif = fn_getLineaUnificada($fila['IDLinea']);
								$desclinunif = fn_getNombreLinea($linunif);
							?>
								<tr>
									<td align="center"><?=$fila['IDLinea']?></td>
									<td align="left"><?=$fila['descripcion']?></td>
									<td align="center" onClick="NewFact(<?=$fila['IDLinea']?>, 1)"><?=$linunif?></td>
									<td align="left"><?=$desclinunif?></td>
									<td align="right"><?=$fila['tot_mes']?></td>
									<?php
									if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])) {
									?>
									<td align="right" onClick="NewFact(<?=$fila['IDLinea']?>, 0)"><?=$fila['manual']?></td>
									<?php
									} else {
									?>
									<td align="right"><?=$fila['manual']?></td>
									<?php
									}
									?>
								</tr>
								<?php
							}
							?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
	</div>
</div>
