<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ".",
	  	"thousands": ",",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
  <div class="col-md-12 col-lg-12 col-sm-12">
		  <div class="card">
		    <div class="card-header bg-success">
		      <h5 class="card-title">Estimaci&oacute;n Tiempos de Producci&oacute;n</h5>
		    </div>
		    <div class="card-body">
		    	<table id="result" class="display compact stripe hover" >
						<thead>
							<tr>
								<th align="center" width="2%">L&iacute;nea Unif.</th>
								<th align="center" width="10%">L&iacute;nea</th>
								<th align="center" width="5%">C&oacute;digo</th>
								<th align="center" width="25%">Descripci&oacute;n</th>
								<th align="center" width="5%">Base C&aacute;lculo Mensual (Und.)</th>
								<th align="center" width="3%">Capacidad de L&iacute;nea</th>
								<th align="center" width="5%">Unidades Recomendadas</th>
								<th align="center" width="7%">Tiempo Estimado Item</th>
								<th align="center" width="7%">Tiempo Acumulado L&iacute;nea</th>
							</tr>
							<tr>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
								<td align="center"></td>
							</tr>
						</thead>
						<tbody>
						<?php
							$ventas = fn_getDatosBase();
							$lin = '';
							$tmoLin = 0;
							while($rows = $ventas->fetch_assoc()) {
								$capa = fn_getCapacidadLinea($rows['U_Nivel2'])->fetch_assoc();
								if ($lin != $capa['unif']){
									$tmoLin = 0;
								}
								$tmoItem = $rows['und_recomendada'] / $capa['cap_linea'];
								$tmoLin += $tmoItem;
								?>
									<tr>
										<td align="center"><?=number_format($capa['unif'], 0, ',', '.')?></td>
										<td align="center"><?=fn_getNombreLinea($capa['unif'])?></td>
										<td align="center"><?=$rows['ItemCode']?></td>
										<td align="left"><?=$rows['ItemName']?></td>
										<td align="right"><?=number_format($rows['base_calc_mensual'], 0, ',', '.')?></td>
						        <td align="right"><?=number_format($capa['cap_linea'], 0, ',', '.')?></td>
										<td align="right"><?=number_format($rows['und_recomendada'], 0, ',', '.')?></td>
										<td align="right"><?=number_format($tmoItem, 2, ',', '.')?></td>
										<td align="right"><?=number_format($tmoLin, 2, ',', '.')?></td>
									</tr>
								<?php
								$lin = $capa['unif'];
							}
						?>
						</tbody>
					</table>
				</div>
		  </div>
	</div>
</div>
