
<link rel="stylesheet" type="text/css" href="lib/DataTables/DataTables-1.13.6/css/jquery.dataTables.min.css"/>
<script type="text/javascript" src="lib/DataTables/DataTables-1.13.6/js/jquery.dataTables.min.js"></script>
<!--<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>-->

<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input type="text" />' );
    } );
  var table = $('#result').DataTable({
			dom: 'frtip',
			buttons: ['excel'],
			scrollY: '50vh',
			scrollX: '100%',
			scrollCollapse: true,
			fixedHeader: false,
			loadingRecords: "Cargando...",
			processing: "Procesando....",
			"ordering": true,
			paging: false,
			"pageLength": 100,
			responsive: true,
			"autoWidth": false,
			"language": {
			"info": "Mostrando _TOTAL_ de _MAX_ registros",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
			"thousands": ".",
			"paginate": {
				"first":      "Primera",
				"last":       "Ultima",
				"next":       "Siguiente",
				"previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });

});
</script>
<script type="text/javascript">
function prepAux(){
	$.ajax({
		type: 'POST',
    dataType: "json",
    url : "api/hlp/setAuxProg.php",
    data: {
        fn: 'fn_getDatosparaCalculo',
        pr: 'base'
    },
    success: function(response) {
    	if (response.resp == 'true') {
    		executeProcess(response.total, 0);
      } else {
    	  $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=false');
      }
    }
	});
}

function executeProcess(total, offset, batch = false) {
	if (offset == 0){
		$('#modalCarga').modal('show');
		$('#total').text(total);
    //reset progress bar
        $('.progress-bar').css('width', '0%');
        $('.progress-bar').text('0%');
        $('.progress-bar').attr('aria-valuenow', '0');
	}
    $.ajax({
        type: 'POST',
        dataType: "json",
        url : "api/prg/updBaseCalculo.php",
        success: function(response) {
        	$('.progress-bar').css('width', response.avance+'%');
            $('.progress-bar').text(response.avance+'%');
            $('.progress-bar').attr('aria-valuenow', response.avance);
            $('#cuenta').text(response.item);
            var newOffset = offset + 1;
            if (response.avance == 100) {
            	$('#modalCarga').modal('hide');
            	delAux();
            } else {
                executeProcess(total, newOffset, batch);
            }
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            if (textStatus == 'parsererror') {
                textStatus = 'Technical error: Unexpected response returned by server. Sending stopped.';
            }
            delAux();
            $('#modalCarga').modal('hide');
            alert(textStatus);
       }
    });
}

function delAux(){
	$.ajax({
		type: 'POST',
    dataType: "json",
    url : "api/hlp/delAuxProg.php",
    data: {pr: 'base'},
    success: function(response) {
    	if (response.resp == 'true') {
        $(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&res=true');
      }
    }
	});
}
</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
  	<div class="col-md-12 col-lg-12 col-sm-12">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	    	<div class="row">
    	    		<div class="col-md-7 col-sm-12 col-lg-7 text-start">
    	      		<h5 class="card-title">Base de Calculo Producci&oacute;n.</h5>
    	      	</div>
    	      	<div class="col-md-3 col-sm-8 col-lg-3 text-end">
    						<span>Ultima actualizaci&oacute;n: <?=fn_getLastFullDateMy('tb_plan_base_calculo', 'fec_get')?></span>
    					</div>
    					<?php
    						if (fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid'])) {
    					?>
    					<div class="col-md-2 col-sm-4 col-lg-2 text-center">
    						<a class="btn btn-success btn-sm upd-modal" role="button" id="updBase" onClick="prepAux();"><i class="fa fa-refresh" aria-hidden="true"></i> Actualizar</a>
    					</div>
    					<?php
    						}
    					?>
    				</div>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row">
    	    		<div class="col-sm-12 col-md-12 col-lg-12">
        				<table id="result" class="display compact stripe hover" >
        					<thead>
        						<tr>
        							<th align="center" width="5%">C&oacute;digo</th>
        							<th align="center" width="20%">Descripci&oacute;n</th>
        							<!--<th align="center" width="3%">Base C&aacute;lculo Mensual (Und.)</th>-->
									<th align="center" width="3%">Buffer</th>
        							<th align="center" width="7%">Unidades Recomendadas</th>
        						</tr>
        						<!--<tr>
        							<td align="center"></td>
        							<td align="center"></td>
        							<td align="center"></td>
        							<td align="center"></td>
        						</tr>-->
        					</thead>
        					<tbody>
        					<?php
        					$datos = fn_getDatosBaseCalculada();
        					while ($fila = $datos->fetch_assoc()){
        						?>
        						<tr>
        							<td align="center"><?=$fila['ItemCode']?></td>
        							<td align="center"><?=$fila['ItemName']?></td>
        							<td align="center"><?=number_format($fila['base_calc_mensual'], 0, ',', '.')?></td>
        							<td align="center"><?=number_format($fila['und_recomendada'], 0, ',', '.')?></td>
        						</tr>
        						<?php
        						}
        					?>
        					</tbody>
        				</table>
        			</div>
    			</div>
    			<div class="row">
    	    		<div class="col-sm-12 col-md-12 col-lg-12 text-end">
    	    			<button class="btn btn-success" onClick="genPDF2();"><i class="fa fa-print" aria-hidden="true"></i> Imprimir</button>
						<button type="button" class="btn btn-success" onClick="archivo();"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Exportar</button>
    	    		</div>
    	    	</div>
    		</div>
    	</div>
	</div>
</div>