<?php
// Sección de inicialización y obtención de datos
session_start();

// Obtener permisos del usuario y parámetros de cálculo
$grants = fn_getPermisoUsuario($_SESSION['USERID'], $_GET['pid'])->fetch_assoc();
$params = fn_getParametrosCalculo('prd')->fetch_assoc();
$niveles = fn_getniveles();
$nivelesSinComillas = str_replace("'", "", $niveles);

// Obtener cantidad de filtros para el periodo actual y el periodo no actual
$filtos_si = fn_CantidadFiltrosPeriodo(date("W"), $_SESSION['USERID'], $params['corte_prod'], $niveles);
$filtos_no = fn_CantidadFiltrosnoPeriodo(date("W"), $_SESSION['USERID'], $params['corte_prod'], $niveles);
$filtos_sap = fn_filtos_sap($niveles);

// Actualizar cálculos si se proporciona el parámetro 'update'
if (isset($_GET['update']) && $_GET['update'] == 'ok') {
    fn_setCalculoIntermedio();

    // Actualizar las cantidades de filtros después de la actualización
    $filtos_si = fn_CantidadFiltrosPeriodo(date("W"), $_SESSION['USERID'], $params['corte_prod'], $niveles);
    $filtos_no = fn_CantidadFiltrosnoPeriodo(date("W"), $_SESSION['USERID'], $params['corte_prod'], $niveles);
    $filtos_sap = fn_filtos_sap($niveles);
}

// Mostrar mensajes de resultado según el parámetro 'res' en la URL
if (isset($_GET['res'])) {
    if ($_GET['res'] == 'true') {
        // Mostrar mensaje de éxito si 'res' es 'true'
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
        echo '<p class="text-success">Los datos han sido guardados correctamente.</p>';
        echo '</div>';
    } else {
        // Mostrar mensaje de error si 'res' no es 'true'
        echo '<div class="alert alert-warning alert-dismissible fade show" role="alert">';
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
        echo '<p class="text-danger">Ha ocurrido un error almacenando los datos.</p>';
        echo '<p class="text-danger">Verifique la información ingresada.</p>';
        echo '</div>';
    }
}
?>

<!-- Sección de enlaces y scripts externos -->
<link rel="stylesheet" href="https://site-assets.fontawesome.com/releases/v6.5.1/css/all.css" crossorigin="anonymous">
<link rel="stylesheet" type="text/css" href="lib/DataTables/DataTables-1.13.6/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.js"></script>
<script type="text/javascript" src="lib/DataTables/DataTables-1.13.6/js/jquery.dataTables.min.js"></script>

<?php
// Obtener datos de la tabla tb_plan_base_calculo para mostrar la fecha de la última actualización
$fec_get = fn_fec_get_tb_plan_base_calculo(date("W"));
$row_get = $fec_get->fetch_assoc();
?>

<style>
    .container,
    .container-lg,
    .container-md,
    .container-sm,
    .container-xl,
    .container-xxl {
        max-width: 90%;
    }

    .sweetAlert_sin_stock {
        width: 900px;
    }

    .sweetAlert_ {
        width: 800px;
    }
</style>

<script type="text/javascript">
    // Script para inicializar la tabla DataTable
    $(document).ready(function () {
        // Configuración de DataTable
        $('#result thead td').each(function () {
            var title = $('#result thead td').eq($(this).index()).text();
            $(this).html('<input class="form-control form-control-sm" type="text" />');
        });

        var table = $('#result').removeAttr('width').DataTable({
            dom: '<"msg_tabla">rtip',
            scrollY: '45vh',
            scrollX: '100%',
            scrollCollapse: true,
            fixedHeader: true,
            "ordering": true,
            paging: false,
            "pageLength": 50,
            "autoWidth": false,
            "language": {
                "url": "lib/DataTables/DataTables-1.13.6/js/Spanish.json"
            },
            initComplete: function () {
                // Aplicar los filtros a cada columna
                this.api().columns().every(function () {
                    var that = this;
                    $('input', this.header()).on('keyup change', function () {
                        if (that.search() !== this.value) {
                            that.search(this.value).draw();
                        }
                    });
                });
            }
        });
    });

    // Funciones para manejar modales y procesos
    function prepAux(id_aux, indc_tipofiltro, indc_filtro) {
        // Lógica para preparar el modal
        // ...
    }

    function executeProcess() {
        // Lógica para ejecutar un proceso
        // ...
    }

    function delAux(id_aux) {
        // Lógica para eliminar un elemento auxiliar
        // ...
    }
</script>

<!-- Sección de HTML generada dinámicamente -->
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <!-- Información de la última actualización -->
            <div class="mb-3">
                <span class="text-muted">Fecha de última actualización: <?php echo $row_get['fec_get']; ?></span>
            </div>

            <!-- Tabla principal -->
            <table id="result" class="table table-hover table-bordered">
                <thead>
                    <!-- Cabeceras de la tabla -->
                    <!-- ... -->
                </thead>
                <tbody>
                    <?php
                    // Lógica para generar filas de la tabla dinámicamente
                    // ...
                    ?>
                </tbody>
            </table>

            <!-- Exportar datos a Excel -->
            <div class="mt-3">
                <a href="#" id="exportButton" class="btn btn-primary btn-sm">Exportar a Excel</a>
            </div>
        </div>
    </div>
</div>

<script>
    // Script para exportar datos a Excel
    $("#exportButton").click(function () {
        $("#result").table2excel({
            exclude: ".noExl",
            name: "Report",
            filename: "Report" + new Date().toISOString().replace(/[\-\:\.]/g, "") + ".xls",
            fileext: ".xls",
            exclude_img: true,
            exclude_links: true,
            exclude_inputs: true
        });
    });
</script>

<!-- Animación de parpadeo -->
<style>
    @keyframes blink {
        0%,
        49% {
            opacity: 0;
        }
        50%,
        100% {
            opacity: 1;
        }
    }

    .blinking {
        animation: blink 1s infinite;
    }
</style>
