<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>

<style type="text/css">
	a:link {
	  color: #000000;
	}
	a:visited {
	  color: #000000;
	}
	a:hover {
	  color: #000000;
	}
	a:active {
	  color: #000000;
	}
	body,td,th {
	  color: #000000;
	}
</style>
<script>
$(document).ready(function() {
    $('#result').DataTable( {
        dom: 'frtip',
        buttons: [
            'excel'
        ],
		scrollY:        '68vh',
        scrollCollapse: true,
        paging:         false,
		order: [0, 'desc'],
		"language": {
            "info": "",
			"search":         "Buscar:",
			"zeroRecords":    "No se han encontrado registros",
			"decimal": ".",
            "thousands": ","
        }
    } );
} );
</script>

<div class="card">
  <div class="card-header bg-success" >
		<div class="row">
		  <div class="col-md-6 col-lg-6 col-sm-12 text-start" >
		  	<h6 class="card-title">Resumen de Ordenes de Trabajo Depto. Mantenci&oacute;n</h6>
		  </div>
		  <div class="col-md-6 col-lg-6 col-sm-12 text-end">
		  	<a href="home.php?pid=62&sys=mant&pg=mantcrea&frm=0" class="btn btn-warning btn-sm text-black" role="button">Crear Orden de Trabajo</a>
		  </div>
    </div>
	</div>
	<div class="card-body">
		<table class="table table-hover table-striped" id="result">
			<thead>
				<tr>
		  		<th width="8%" style="text-align: center" scope="col"># OT</th>
		    	<th width="13%" style="text-align: center" scope="col">Fecha</th>
					<th width="37%" style="text-align: center" scope="col">Descripci&oacute;n de la OT</th>
					<th width="11%" style="text-align: center" scope="col">Categoria</th>
					<th width="11%" style="text-align: center" scope="col">Máquina</th>
					<th width="11%" style="text-align: center" scope="col">Depto.</th>
					<th width="9%" style="text-align: center" scope="col">Fch. fin</th>
					<th width="11%" style="text-align: center" scope="col">Estado</th>
					<th width="11%" style="text-align: center" scope="col">Dias</th>
				</tr>
			</thead>
			<tbody>
				<?php
				$res1 = fn_getOrdenesMantencion();
				while($row1 = $res1->fetch_assoc()) {
				$createdate = date_create($row1['createdate']);
				$cierrasolfecha = ($row1['cierrasolfecha'] == null) ? '' : date_format (new DateTime($row1['cierrasolfecha']), 'd-m-Y');

				if($row1['pausa'] == 1){
						$bgcelda = 'bg-danger text-white';
					}else{

						if($row1['cierrasol'] == 1){
							$bgcelda = 'bg-success';

						}else{

							if($row1['mantestado'] == 1){
							$bgcelda = 'bg-danger text-white';

							}elseif($row1['mantestado'] == 2){
							$bgcelda = 'bg-warning';
							}

						}
					}

				?>
	  		<tr>
				  <td align="center"><a href="home.php?pid=62&sys=mant&pg=mantot&ot=<?=$row1['id']?>" target="_self"><?=$row1['id']?></a></td>
				  <td align="center"><?=date_format($createdate, 'd-m-Y H:i')?></td>
				  <td align="left"><?=$row1['deslarga']?></td>
				  <td align="center"><?=$row1['cat1']?></td>
				  <td align="center"><?=$row1['idmaquina']?></td>
				  <td align="center"><?=$row1['deptoname']?></td>
				  <td align="center"><?=$cierrasolfecha?></td>
				  <td align="center" class="<?=$bgcelda?>">
				<?php
				if($row1['pausa'] != 1){
					if($row1['cierrasol'] == 1){
				?>
					Cerrada
				<?php
					}else{
				?>
					  <?=$row1['estadoOT']?>
				<?php
						 }
				}else{
				?>
					En Pausa
				<?php
				}
				?>
			  	</td>
			  	<td align="center"><?=$row1['dias']?></td>
		  	</tr>
				<?php
				}
				?>
	    </tbody>
		</table>
	</div>
</div>