<?php
    $qryE = "SELECT id, name, area FROM mant_tecnicos WHERE area = 'E' AND activo = 'Y' ORDER BY name ASC";
    $resE = $GLOBALS['connmy']->query($qryE);
    $qryM = "SELECT id, name, area FROM mant_tecnicos WHERE area = 'M' AND activo = 'Y' ORDER BY name ASC";
    $resM = $GLOBALS['connmy']->query($qryM);
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
    $(document).ready(function() {
      	var table = $('[id^=result]').removeAttr('width').DataTable({
           	dom: 'rtip',
            buttons: ['excel'],
    		scrollY: '25vh',
    		scrollX: '100%',
        	scrollCollapse: true,
    		fixedHeader: false,
    		"ordering": false,
        	paging: true,
    		"pageLength": 4,
    		responsive: true,
    		"autoWidth": false,
    		"language": {
        		"info": "",
    			"search": "Buscar:",
    			"zeroRecords": "No se han encontrado registros",
    			"decimal": ",",
    	  		"thousands": ".",
    			"paginate": {
    		    	"first":      "Primera",
    	      		"last":       "Ultima",
    	      		"next":       "Siguiente",
    	      		"previous":   "Anterior"
        		}
        	}
      	});
    });
</script>
<style>
	.bg-azul {
	   background-image: linear-gradient(-90deg, rgba(0,40,72,1), rgba(0,75,122,1));
	   color: #FFFFFF;
	}
	.bg-amarillo {
	   background-color: rgba(249, 236, 0, 1);
	   color: rgba(0, 125, 80, 1);
	}
	.bg-naranja {
	   background-color: #fdb819;
	   color: rgba(0, 125, 80, 1);
	}
	.bg-gris {
	   background-color: rgba(238, 238,238, 1);
	   color: rgba(0, 0, 0, 1);
	}
	.head-titulo{
	   font-weight: bold;
	   color: #808080;
	}
</style>
<div class="row">
	<div class="col-md-10 col-lg-10 col-sm-12 offset-md-1 offset-lg-1">
	  <div class="card">
	    <div class="card-header bg-success">
	    	<div class="row">
				<div class="col-md-6 col-lg-6 col-sm-12">
					<h5 class="card-title">Mantenedor de T&eacute;cnicos</h5>
	    		</div>
				<div class="col-md-6 col-lg-6 col-sm-12 text-end">
					<button class="btn btn-sm btn-success" onClick="newTech();"><i class="fa fa-plus" aria-hidden="true"></i> Nuevo T&eacute;cnico</button>
	    		</div>
	    	</div>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
					<div class="row py-1">
						<h5 class="head-titulo">El&eacute;ctrico</h5>
						<hr>
					</div>
					<div class="row py-1">
						<table id="result1" class="table table-sm table-hover table-striped">
							<thead>
								<tr>
									<th width="60%" class="text-start">Nombre</th>
									<th width="20%" class="text-center">Departamento</th>
									<th width="19%" class="text-center">Acciones</th>
								</tr>
							</thead>
							<tbody>
								<?php
								while($fila = $resE->fetch_assoc()){
                                    ?>
                                    <tr>
                                    	<td class="text-start"><?=$fila['name']?></td>
                                    	<td class="text-center"><?=utf8_encode(($fila['area']=='E')?'Elctrico':'Mecnico') ?></td>
                                    	<td class="text-center">
                                    		<div class="row">
                                    			<div class="col"><a href="#" class="text-success" onClick="renameTech(<?=$fila['id']?>, '<?=$fila['name']?>');"><i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a></div>
                                    			<div class="col"><a href="#" class="text-danger" onClick="quitaTech(<?=$fila['id']?>, '<?=$fila['name']?>');"><i class="fa fa-times fa-2x" aria-hidden="true"></i></a></div>
                                    		</div>
                                    	</td>
                                    </tr>
                                    <?php
								}
								?>
							</tbody>
						</table>
					</div>
					<br>
					<div class="row py-1">
						<h5 class="head-titulo">Mec&aacute;nico</h5>
						<hr>
					</div>
					<div class="row py-1">
						<table id="result2" class="table table-sm table-hover table-striped">
							<thead>
								<tr>
									<th width="60%" class="text-start">Nombre</th>
									<th width="20%" class="text-center">Departamento</th>
									<th width="19%" class="text-center">Acciones</th>
								</tr>
							</thead>
							<tbody>
								<?php
								while($fila = $resM->fetch_assoc()){
								    ?>
                                    <tr>
                                    	<td class="text-start"><?=$fila['name']?></td>
                                    	<td class="text-center"><?=utf8_encode(($fila['area']=='E')?'Elctrico':'Mecnico') ?></td>
                                    	<td class="text-center">
                                    		<div class="row">
                                    			<div class="col"><a href="#" class="text-success" onClick="renameTech(<?=$fila['id']?>, '<?=$fila['name']?>');"><i class="fa fa-pencil fa-2x" aria-hidden="true"></i></a></div>
                                    			<div class="col"><a href="#" class="text-danger" onClick="quitaTech(<?=$fila['id']?>, '<?=$fila['name']?>');"><i class="fa fa-times fa-2x" aria-hidden="true"></i></a></div>
                                    		</div>
                                    	</td>
                                    </tr>
                                    <?php
								}
								?>
							</tbody>
						</table>
					</div>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>
<script>
function newTech(){
	var addr = './<?=$_GET['sys']?>/newtecnico.php';
	$('#modalPaginaLG').find('.modal-content').load(addr, function(resp, stat, xhr){
		if(stat == 'success'){
			$('#modalPaginaLG').modal('show');
		} else {
			alert("Error: " + xhr.status + ": " + xhr.statusText);
		}
	});
}

function quitaTech(tech_id, tech_nom){
	console.log(tech_nom);
	if(confirm("Realmente desea inhabilitar al t\xE9cnico " + tech_nom + " permanentemente?")){
		$.ajax({
	        type: "POST",
	        url: "./mant/quitaTech.php",
	        data: {
				id: tech_id
	        },
	        success: function (data) {
	        	alert("T\xE9cnico inhabilitado correctamente.");
	        	location.reload(true);
	    	}
	    });
	}
}

function renameTech(tech_id, tech_nom){
	var addr = './<?=$_GET['sys']?>/moditecnico.php?id='+tech_id;
	$('#modalPaginaLG').find('.modal-content').load(addr, function(resp, stat, xhr){
		if(stat == 'success'){
			$('#modalPaginaLG').modal('show');
		} else {
			alert("Error: " + xhr.status + ": " + xhr.statusText);
		}
	});
}
</script>