<?php
$OFs = fn_getOrdenesFabricacionVigentes();
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.4/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.flash.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.6.4/js/buttons.html5.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'Brtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		<div class="card">
			<div class="card-header bg-success">
				<h5 class="card-title">&Oacute;rdenes para Despiece.</h5>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-md-12 col-lg-12 col-sm-12">
						<table id="result" class="display compact stripe hover" >
							<thead>
								<tr>
									<th align="center" width="5%">Num. OF</th>
									<th align="center" width="5%">Fecha</th>
									<th align="center" width="5%">C&oacute;digo Item</th>
									<th align="center" width="20%">Descripci&oacute;n</th>
									<th align="right" width="5%">Cantidad</th>
								</tr>
								<tr>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
									<td align="center"></td>
								</tr>
							</thead>
							<tbody>
								<?php
								while ($fila = sqlsrv_fetch_array($OFs, SQLSRV_FETCH_ASSOC)){
								if (($fila['Status'] == 'P') && (!fn_getStatusOF($fila['DocNum'], 'desp'))){
								?>
								<tr>
									<td align="center"><a href="?sys=logi&pg=showdesp&itm=<?=$fila['ItemCode']?>&qty=<?=$fila['PlannedQty']?>&op=desp"><?=number_format($fila['DocNum'], 0, ',', '.')?></a></td>
									<td align="center"><?=$fila['PostDate']?></td>
									<td align="center"><?=$fila['ItemCode']?></td>
									<td align="left"><?=$fila['ItemName']?></td>
									<td align="right"><?=number_format($fila['PlannedQty'], 0, ',', '.')?></td>
								</tr>
								<?php
								}
								}
								?>
							</tbody>
						</table>
			</div>
			</div>
			</div>
		</div>
	</div>
</div>