<?php
    if(isset($_GET['id'])){
        $req = $_GET['id'];
    }
    $fecha = date('d-m-Y H:i:s');
    $datosReq = fn_getDatosRequerimiento($req)->fetch_assoc();
?>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  	<div class="card">
    	    <div class="card-header bg-success">
    	    	<div class="row">
        	    	<div class="col-sm-12 col-md-6 col-lg-6">
        	    		<h5 class="card-title">Requerimiento N&deg; <?=$req ?></h5>
        	    	</div>
        	    	<div class="col-sm-12 col-md-6 col-lg-6 text-end">
        	    		<a href="?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=requerimientos" class="btn btn-success btn-sm" role="button"><i class="fa fa-chevron-left"></i> Volver</a>
        	    	</div>
        	    </div>
    	    </div>
    	    <div class="card-body">
    	    	<div class="row py-1">
    	    		<div class="col-md-2 col-lg-2 col-sm-12">
    					<label for="tipoReq">Tipo de Requerimiento :</label>
    	    		</div>
    	    		<div class="col-md-3 col-lg-3 col-sm-12">
    					<select class="form-select form-select-sm" id="tipoReq" name="tipoReq" disabled>
    						<option value="0">&lt;&lt; Seleccione Tipo &gt;&gt;</option>
    						<?php
    						$d1 = fn_getTipoRequerimiento();
    						while($tr = $d1->fetch_assoc()){
    						    if($tr['ID'] == $datosReq['ID']){
    						        ?>
    						         <option value="<?=$tr['ID']?>" selected><?=$tr['tipoRequerimiento']?></option>
    						        <?php
    						    } else {
    				            ?>
    				            	<option value="<?=$tr['ID']?>"><?=$tr['tipoRequerimiento']?></option>
    				            <?php
    						    }
    						}
    						?>
    					</select>
    	    		</div>
    	    		<div class="col-md-2 col-lg-2 col-sm-12 offset-md-1 offset-lg-1">
    					<label>Fecha :</label>
    	    		</div>
    	    		<div class="col-md-4 col-lg-4 col-sm-12">
    	    			<?=$datosReq['fecha_creacion']?>
    	    		</div>
    	    	</div>
    	    	<div class="row py-1">
    	    		<div class="col-md-2 col-lg-2 col-sm-12">
    					<label for="cboUsrSolicita">Usuario Solicitante :</label>
    	    		</div>
    	    		<div class="col-md-3 col-lg-3 col-sm-12">
    					<select class="form-select form-select-sm" id="cboUsrSolicita" name="cboUsrSolicita" disabled>
    						<option value="0">&lt;&lt; Seleccione Usuario &gt;&gt;</option>
    						<?php
    						$d1 = fn_getListaUsuarios();
    						while($tr = $d1->fetch_assoc()){
    						    if($tr['IdUser'] == $datosReq['codUsuarioSolicitante']){
    						        ?>
    						        <option value="<?=$tr['IdUser']?>" selected><?=$tr['Name']?></option>
    						        <?php
    						    } else {
    				            ?>
    				            	<option value="<?=$tr['IdUser']?>"><?=$tr['Name']?></option>
    				            <?php
    						    }
    						}
    						?>
    					</select>
    	    		</div>
    	    		<div class="col-md-2 col-lg-2 col-sm-12 offset-md-1 offset-lg-1">
    					<label for="cboDepto">Departamento :</label>
    	    		</div>
    	    		<div class="col-md-4 col-lg-4 col-sm-12">
    					<select class="form-select form-select-sm" id="cboDepto" name="cboDepto" disabled>
    						<option value="0">&lt;&lt; Seleccione Departamento &gt;&gt;</option>
    						<?php
    						$d1 = fn_getdeptos();
    						while($tr = $d1->fetch_assoc()){
    						    if($tr['id'] == $datosReq['codDepto']){
    						        ?>
    						        <option value="<?=$tr['id']?>" selected><?=$tr['name']?></option>
    						        <?php
    						    } else {
    				            ?>
    				            <option value="<?=$tr['id']?>"><?=$tr['name']?></option>
    				            <?php
    						    }
    						}
    						?>
    					</select>
    	    		</div>
    	    	</div>
    	    	<div class="row py-3">
    	    		<div class="col-md-2 col-lg-2 col-sm-12">
    	    			<label for="txtAsunto">Asunto :</label>
    	    		</div>
    	    		<div class="col-md-3 col-lg-3 col-sm-12">
    					<input id="txtAsunto" name="txtAsunto" type="text" value="<?=$datosReq['asunto'] ?>" class="form-control form-control-sm" disabled>
    	    		</div>
    	    		<div class="col-md-2 col-lg-2 col-sm-12 offset-md-1 offset-lg-1">
    	    			<label>Avance :</label>
    	    		</div>
    	    		<div class="col-md-4 col-lg-4 col-sm-12">
    					<label><?=number_format($datosReq['avance'], 2, ',','.') ?> %</label>
    	    		</div>
    	    	</div>
    	    	<div class="row">
    	    		<div class="col-md-2 col-lg-2 col-sm-12">
    	    			<label for="txtDescripcion">Descripci&oacute;n :</label>
    	    		</div>
    	    		<div class="col-md-6 col-lg-6 col-sm-12">
    					<textarea id="txtDescripcion" name="txtDescripcion" class="form-control form-control-sm" rows="5" disabled><?=$datosReq['descripcion'] ?></textarea>
    	    		</div>
    	    	</div>
    	    	<?php
	    			$tar = fn_getTareasRequerimiento($req);
			    ?>
	    		<hr>
    			<div class="row py-1">
    				<div class="col-sm-12 col-md-12 col-lg-12">
						<table class="table table-sm table-hover table-striped">
							<thead>
								<tr>
									<th class="text-center">#</th>
									<th class="text-center">Titulo</th>
									<th class="text-center">Descripci&oacute;n</th>
									<th class="text-center">Estado</th>
									<th class="text-center">Avance</th>
									<th class="text-center">Inicio</th>
									<th class="text-center">T&eacute;rmino</th>
									<th class="text-center">Acciones</th>
								</tr>
							</thead>
							<tbody>
							<?php
								while($tarea = $tar->fetch_assoc()){
								?>
								<tr class="align-middle">
									<td class="text-start"><?=$tarea['idPaso']?></td>
									<td class="text-start"><?=$tarea['titulo']?></td>
									<td class="text-start text-truncate"  style="max-width: 400px;"><?=$tarea['descripcion']?></td>
									<td class="text-center"><?=$tarea['name']?></td>
									<td class="text-center"><?=$tarea['avance']?> %</td>
									<td class="text-center"><?=$tarea['fecha_inicio']?></td>
									<td class="text-center"><?=$tarea['fecha_termino']?></td>
									<td class="text-center"><a class="li-modal btn btn-sm" href="./info/viewwork.php?id=<?=$req?>&idTar=<?=$tarea['idPaso']?>"><i class="fa fa-eye text-success" aria-hidden="true"></i></a></td>
								</tr>
								<?php
								}
								?>
							</tbody>
						</table>
    				</div>
    			</div>
    	    </div>
    	</div>
	</div>
</div>
<script>
$('#nuevoReq').submit(function (ev) {
	$.ajax({
    type: $('#nuevoReq').attr('method'),
    url: $('#nuevoReq').attr('action'),
    data: $('#nuevoReq').serialize(),
    success: function (dev) {
        var datos = JSON.parse(dev);
		if(datos.resp == 'true'){
			$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&svreq='+datos.resp+'&id='+datos.id);
		} else {
			$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&svreq='+datos.resp);
		}
	}
  });
	ev.preventDefault();
});
</script>