<?php
$agrega = fn_getPermisoAgregar($_SESSION['USERID'], $_GET['pid']);
$edita = fn_getPermisoEditar($_SESSION['USERID'], $_GET['pid']);
$quita = fn_getPermisoQuitar($_SESSION['USERID'], $_GET['pid']);
$ejecuta = fn_getPermisoEjecutar($_SESSION['USERID'], $_GET['pid']);
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	    	<div class="row">
	    		<div class="col-md-6 col-lg-6 col-sm-12">
	     			<h5 class="card-title">Requerimientos de Desarrollo</h5>
	     		</div>
	     		<?php
				    if ($agrega){
				?>
	     		<div class="col-md-6 col-lg-6 col-sm-12 text-end">
	     			<a class="btn btn-sm btn-success" href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=newreq"><i class="fa fa-plus" aria-hidden="true"></i> Nuevo Requerimiento</a>
	     		</div>
	     		<?php
				    }
				?>
	     	</div>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
				<table class="table table-sm table-hover table-striped dataTable no-footer" id="result" aria-describedby="result_info"><thead>
	    			<!--<table class="table table-sm table-hover table-striped" id="result">-->
						

					
	    				<thead>
	    					<tr>
	    						<th class="text-center">#</th>
	    						<th class="text-center">Fecha Creaci&oacute;n</th>
	    						<th class="text-center">Asunto</th>
	    						<th class="text-center">Solicitante</th>
	    						<th class="text-center">Departamento</th>
	    						<th class="text-center">Tareas</th>
	    						<th class="text-center">Avance</th>
	    						<th class="text-center">Estado</th>
	    						<th class="text-center">Fecha Cierre</th>
	    						<th class="text-center">Acciones</th>
	    					</tr>
	    				</thead>
	    				<tbody>
    					<?php
    					$lista = fn_getListaSolicitudesDesarrollo();
    					while($fila = $lista->fetch_assoc()){
    					    ?>
    					    <tr>
    					    	<td class="text-center"><?=$fila['ID'] ?></td>
    					    	<td class="text-center"><?=date('d-m-Y', strtotime($fila['creacion'])) ?></td>
    					    	<td class="text-start"><?=$fila['asunto'] ?></td>
    					    	<td class="text-center"><?=$fila['Solicita'] ?></td>
    					    	<td class="text-center"><?=$fila['Departamento'] ?></td>
    					    	<td class="text-center"><?=$fila['tareas'] ?></td>
    					    	<td class="text-center"><?=number_format($fila['avance'], 2, ',','.') ?> %</td>
    					    	<td class="text-center"><?=$fila['Estado'] ?></td>
    					    	<td class="text-center"><?=$fila['termino'] ?></td>
    					    	<td class="text-center">
    					    		<div class="row">
    					    		<?php
    					    		if($fila['activo'] == 'Y'){
    					    		?>
    					    			<div class="col">
    					    				<a class="btn btn-sm" href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=viewreq&id=<?=$fila['ID'] ?>"><i class="fa fa-eye text-success" aria-hidden="true"></i></a>
    					    			</div>
    					    			<?php
    					    		    if($ejecuta){
    					    		        ?>
    					    			<div class="col">
											<a class="btn btn-sm" href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=exereq&id=<?=$fila['ID'] ?>"><i class="fa fa-code text-primary" aria-hidden="true"></i></a>
    					    			</div>
    					    			<?php
    					    		    }
    					    			if($edita){
    					    			?>
    					    			<div class="col">
											<a class="btn btn-sm" href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=newreq&edt=true&id=<?=$fila['ID'] ?>"><i class="fa fa-pencil-square-o text-warning" aria-hidden="true"></i></a>
    					    			</div>
    					    			<?php
    					    			}
    					    			if($quita){
    					    			?>
    					    			<div class="col">
											<a class="btn btn-sm" onClick="delWork(<?=$fila['ID']?>);"><i class="fa fa-ban text-danger" aria-hidden="true"></i></a>
    					    			</div>
    					    		<?php
    					    		    }
    					    		} else {
    					    		?>
    					    			<div class="col">
    					    				<a class="btn btn-sm" href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=viewreq&id=<?=$fila['ID'] ?>"><i class="fa fa-eye text-success" aria-hidden="true"></i></a>
    					    			</div>
    					    		  <?php
    					    		}
    					    		?>
    					    		</div>
    					    	</td>
    					    </tr>
    					    <?php
    					}
    					?>
						</tbody>
					</table>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>
<script>
function delWork(idProc){
	if(confirm('Se cancelara el requerimiento seleccionado.\rEste proceso no es reversible.\rDesea continuar?')){
    	$.ajax({
    		type: 'POST',
    		url: './api/hlp/delReq.php',
    		data: {
    			idReq: idProc
    		},
    		success: function (resp) {
    			if(resp != 1){
    				alert('Ha ocurrido un error actualizando la tarea.\rRevise la informaci�n');
    			}
    			$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>');
    		}
    	});
	}
}
</script>