<?php
$idSolicitud = $_GET['id'];
$proceso = fn_getDatosRequerimientoSeleccionado($idSolicitud)->fetch_assoc();
$tar = fn_getTareasTotalesRequerimiento($idSolicitud);
?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
  var table = $('#tbTareas').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '25vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
		<div class="card">
	    	<div class="card-header bg-success">
	    		<div class="row">
	    			<div class="col-md-6 col-lg-6 col-sm-12">
	     				<h5 class="card-title">Ejecuci&oacute;n de Tareas - Requerimiento N&deg; <?=$idSolicitud ?></h5>
	     			</div>
        	    	<div class="col-sm-12 col-md-6 col-lg-6 text-end">
        	    		<a href="?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=requerimientos" class="btn btn-success btn-sm" role="button"><i class="fa fa-chevron-left"></i> Volver</a>
        	    	</div>
	     		</div>
	    	</div>
	    	<div class="card-body">
	    		<div class="row py-1">
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				Tipo Requerimiento :
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<?=$proceso['tipoRequerimiento']?>
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				Fecha de Creaci&oacute;n :
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<?=date('d-m-Y H:i:s', strtotime($proceso['fecha_creacion']))?>
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				Estado :
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<select id="estadoReq" name="estadoReq" class="form-select form-select-sm">
    	    					<?php
    	    					$est = fn_getEstados();
    	    					while($fila = $est->fetch_assoc()){
    	    					    if($proceso['codEstado'] == $fila['id']){
    	    					        ?>
    	    					    <option value="<?=$fila['id']?>" selected><?=$fila['name']?></option>
    	    					    <?php
    	    					    } else {
    	    					    ?>
    	    					    <option value="<?=$fila['id']?>"><?=$fila['name']?></option>
    	    					    <?php
    	    					    }
    	    					}
    	    					?>
    	    				</select>
	    			</div>
	    		</div>
	    		<div class="row py-1">
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<label>Asunto :</label>
	    			</div>
	    			<div class="col-md-6 col-lg-6 col-sm-12">
	    				<?=$proceso['asunto']?>
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				Avance :
	    			</div>
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<?=number_format($proceso['avance'], 2, ',','.')?> %
	    			</div>
	    		</div>
	    		<div class="row py-1">
	    			<div class="col-md-2 col-lg-2 col-sm-12">
	    				<label>Descripci&oacute;n :</label>
	    			</div>
	    			<div class="col-md-10 col-lg-10 col-sm-12">
	    				<?=$proceso['descripcion']?>
	    			</div>
	    		</div>
	    		<div class="row py-1">
	    			<div class="col-md-12 col-lg-12 col-sm-12 bg-success border-bottom border-top border-dark border-2">
						<h4>Tareas del Requerimiento</h4>
    	    		</div>
	    		</div>
	    		<div class="row">
	    			<div class="col-md-12 col-lg-12 col-sm-12">
						<table id="tbTareas" class="table table-sm table-hover table-striped">
							<thead>
								<tr>
									<th class="text-center">#</th>
									<th class="text-center">Titulo</th>
									<th class="text-center">Descripci&oacute;n</th>
									<th class="text-center">Estado</th>
									<th class="text-center">Avance</th>
								</tr>
							</thead>
							<tbody>
							<?php
								while($tarea = $tar->fetch_assoc()){
								    if($tarea['activo'] == 'Y'){
								?>
								<tr class="align-middle" onClick="selFila(<?=$tarea['idPaso']?>)" id="fila_<?=$tarea['idPaso']?>">
									<td class="text-start"><?=$tarea['idPaso']?></td>
									<td class="text-start"><?=$tarea['titulo']?></td>
									<td class="text-start text-truncate"  style="max-width: 400px;"><?=$tarea['descripcion']?></td>
									<td class="text-center"><?=$tarea['name']?></td>
									<td class="text-center"><?=$tarea['avance']?></td>
								</tr>
								<?php
								    } else {
								?>
								<tr class="align-middle bg-secondary" style="--bs-bg-opacity: .2;" id="fila_<?=$tarea['idPaso']?>">
									<td class="text-start"><?=$tarea['idPaso']?></td>
									<td class="text-start"><?=$tarea['titulo']?></td>
									<td class="text-start text-truncate"  style="max-width: 400px;"><?=$tarea['descripcion']?></td>
									<td class="text-center"><?=$tarea['name']?></td>
									<td class="text-center"><?=$tarea['avance']?></td>
								</tr>
								<?php
								    }
								}
								?>
							</tbody>
						</table>
	    			</div>
	    		</div>
	    		<hr>
	    		<div class="row">
	    			<div class="col-md-12 col-lg-12 col-sm-12">
						<div id="datosTarea"></div>
	    			</div>
	    		</div>
	    	</div>
    	</div>
	</div>
</div>
<script>
function selFila(fila){
	$('#tbTareas tbody tr').removeClass('bg-success fw-bold');
	$('#fila_'+fila).addClass('bg-success fw-bold');
	$('#datosTarea').load('./<?=$_GET['sys']?>/datosTarea.php?idReq=<?=$idSolicitud?>&idTar='+fila+'&usr=<?=$_SESSION['USERID']?>&pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>');
}

$('#estadoReq').on('change', function(){
	var sel = $(this).val();
	$.ajax({
	    type: 'POST',
	    url: './api/hlp/setUpdReq.php',
	    data: {
	    	idSolicitud: <?=$idSolicitud?>,
	    	idUsuario: <?=$_SESSION['USERID']?>,
	    	estado: sel
	    },
	    success: function (data) {
    		$(location).attr('href','home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=<?=$_GET['pg']?>&id=<?=$idSolicitud ?>');
		  }
	  });
});
</script>