<?php
	ob_start();
	include_once('../lib/dompdf/autoload.inc.php');
	use Dompdf\Dompdf;
	use Dompdf\Exception as DOMException;
	try {
		require_once("../api/conn.php");
		require_once("../api/fngeneral.php");
		$ConnIntra = ConnIntra();
	  $fecha = $_REQUEST['fec'];
	  $usr = $_REQUEST['usr'];
	  $ordenes = $_REQUEST['ordenes'];
	  $dilt =$_REQUEST['dilt'];
	  $dtlt =$_REQUEST['dtlt'];
	  date_default_timezone_set("America/Santiago");
	  setlocale(LC_TIME, 'es_CL','esp');
	  $fecha_prog = strftime('%A %e de %B de %Y', strtotime($fecha));
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<!--<title>ORDEN DE PRODUCCI&Oacute;N DE DESPIECES</title>-->
		<title>SEGUIMIENTO PRODUCCIÓN DESPIECES</title>
		<title>CICLO DE <?=$dilt?> A <?=$dtlt?> </title>
		<style><?=include_once '../lib/bootstrap/css/bootstrap.min.css';?></style>
		<style type="text/css">
			html {
				margin: 0;
			}
			body {
				font-family: Arial, Helvetica, Calibri;
				margin: 10mm 10mm 10mm 10mm;
			}
			body,td,th {
				font-size: 12px;
			}
			table.detalle {
				page-break-after: always;
				-fs-table-paginate: paginate;
			}
			.cuerpo{
				height: auto;
			}
			.cont-info {
				height: auto;
				margin: -10px 10px 20px 10px;
			}
			.back-header {
				background-color: #DFF0D8;
				border-bottom: #cecece solid 1px;
				padding-bottom: 10px;
			}
			.sub-head {
				margin-bottom: -15px;
				padding: 15px 10px -15px 10px;
			}
			.round-5 {
				border: #cecece solid 1px;
				border-radius: 5px;
			}
			.round-10 {
				border: #cecece solid 1px;
				border-radius: 10px;
			}
			.foot {
				bottom: 0px;
				margin-bottom: 30px;
				position: absolute;
				right: 40px;
			}
			.bg-corpgreen {
				background-color: #DFF0D8;
			}
		</style>
	</head>
	<body>
			<table width="100%">
	      <tr>
	        <td class="text-center align-middle" width="20%">
	          <img src="./logo75_2.png" width="100" height="39">
	        </td>
	        <td  class="text-start" width="60%">
	          <address>
	            <strong>J Riveros S.A.I.C.</strong><br>
	            San Nicol&aacute;s 960-912, San Miguel.<br>
	            Santiago - Chile<br>
	            <abbr title="Phone">Tel&eacute;fono:</abbr> +56 2 2397 4444
	          </address>
	        </td>
	        <td  class="text-center align-middle" width="20%">
	          <img src="./logo_mann_filter.png" width="100" height="48">
	        </td>
	      </tr>
	    </table>
			<div class="cuerpo round-5">
	      <table width="100%">
	        <tr>
	          <td colspan="2" width="100%" align="center" class="back-header">
	            <h3><strong>SEGUIMIENTO PRODUCCIÓN DESPIECES</strong></h3>
	          </td>
	        </tr>
	      </table>
      	<div class="sub-head">
	        <table width="100%">
			      <tr>
			        <td class="text-right" width="78%">
			          <p><strong>Fecha: </strong></p>
			        </td>
			        <td class="text-right" width="2%">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			        <td class="text-left" width="20%">
			          <p><strong><?=$fecha_prog?></strong></p>
			        </td>
			      </tr>
			    </table>
			  </div>
			  <hr>
			  <div class="cont-info">
	        <table width="100%" align="center" class="table table-condensed table-striped">
	        	<thead>
					<tr class="bg-corpgreen">
						<th class="text-center" width="10%">SEC. PROD.</th>
						<th class="text-center" width="8%">C&Oacute;DIGO</th>
						<th class="text-center" width="28%">DESCRIPCI&Oacute;N</th>
						<th class="text-center" width="12%">L&Iacute;NEA</th>
						<th class="text-center" width="9%">CUMPLE STOCK</th>
						<th class="text-center" width="9%">UND. A FABRICAR</th>
						<th class="text-center" width="9%">EN OF/OC</th>
						<th class="text-center" width="9%">NIVEL 2</th>
						<th class="text-center" width="9%">NIVEL 3</th>
					</tr>
				</thead>
	         	<tbody>
						<?php
						$prio = 0;
						$cantidad = 0;
						$lin = '';
						$lineas = array();
						foreach($ordenes as $ord){
							$qry = "SELECT * FROM tb_plan_secdespiecesdet where itemcode = '".$ord[0]."' and user=".$usr."";
							$int = $ConnIntra->query($qry);
							$rowDet = $int->fetch_assoc();
							$qry1 = "SELECT Descripcion FROM tb_plan_lineasprod WHERE ID = ".$rowDet['linea'];
							$res1 = $ConnIntra->query($qry1);
							$linea = $res1->fetch_assoc()['Descripcion'];
							$qryniv = "SELECT U_Nivel2, U_Nivel3 FROM tb_plan_maestro where itemcode = '".$ord[0]."'";
							$intniv = $ConnIntra->query($qryniv);
							$rowDetniv = $intniv->fetch_assoc();
							if($lin != $rowDet['linea']){
								$prio = 1;
								$cantidad = 0;
							}

							$enOF = 0;
							$enOC = 0;
							$totBod = $rowDet['stockbodega'];
							$enOF = fn_getOrdenesFabricacionDespiece($ord[0]);
							$enOC = fn_getOrdenesCompraDespiece($ord[0]);
							$val = ($rowDet['U_Nivel1']=='410')?$enOF:$enOC;
							$totBod += $val;
							$cumple = '';
							if ($rowDet['cantnecesaria'] <= $totBod){
								$cumple = 'Sí';
							} else {
								$cumple = 'No';
								//$cuentanocumple++;
							}
						?>
						<tr>
							<td class="text-center"><?=$rowDet['prioridad']?></td>
							<td class="text-center"><?=$rowDet['itemcode']?></td>
							<td class="text-start"><?=$rowDet['itemname']?></td>
							<td class="text-center"><?=$linea?></td>
							<td class="text-center"><?=$cumple?></td>
							<td class="text-center"><?=$ord[1]?></td>
						<?php
						if ( $rowDet['U_Nivel1'] == '410'){
							?>
							<td class="text-center"><?=number_format(fn_getOrdenesFabricacionDespiece($rowDet['itemcode']), 0, ',', '.')?></td>
							<?php
						} else {
							?>
							<td class="text-center"><?=number_format(fn_getOrdenesCompraDespiece($rowDet['itemcode']), 0, ',', '.')?></td>
							<?php
						}
						?>
							<td class="text-center"><?=$rowDetniv['U_Nivel2']?></td>
							<td class="text-center"><?=$rowDetniv['U_Nivel3']?></td>
						</tr>
						<?php
							$cantidad += intval(str_replace(".","", $ord[1]));
							$lineas[$linea] = ['Cuenta' => $prio, 'Cantidad' => $cantidad];
							$lin = $rowDet['linea'];
							$prio++;
						}
						?>
					</tbody>
	        </table>
	        <table width="60%" align="center" border="1">
	        	<thead>
	        		<tr class="bg-success">
	        			<th class="text-center" width="30%">L&iacute;nea</th>
	        			<th class="text-center" width="30%">Cantidad de Piezas</th>
	        			<th class="text-center" width="30%">Cantidad de Unidades</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<?php
	        		$sum_cuenta = 0;
	        		$sum_cantidad = 0;
	        		foreach($lineas as $key => $value){
	        		?>
	        		<tr>
	        			<th class="text-left" style="padding-left: 10px; padding-right: 10px;"><?=$key ?></th>
	        			<td class="text-right" style="padding-left: 10px; padding-right: 10px;"><?=number_format($value['Cuenta'], 0, ',', '.') ?></td>
	        			<td class="text-right" style="padding-left: 10px; padding-right: 10px;"><?=number_format($value['Cantidad'], 0, ',', '.')  ?></td>
	        		</tr>
	        		<?php
	        		$sum_cuenta += $value['Cuenta'];
	        		$sum_cantidad += $value['Cantidad'];
	        		}
	        		?>
	        	</tbody>
	        	<tfoot>
	        		<tr>
	        			<th class="text-right" style="padding-left: 10px; padding-right: 10px;">TOTALES</th>
	        			<th class="text-right" style="padding-left: 10px; padding-right: 10px;"><?=number_format($sum_cuenta, 0, ',', '.') ?></th>
	        			<th class="text-right" style="padding-left: 10px; padding-right: 10px;"><?=number_format($sum_cantidad, 0, ',', '.') ?></th>
	        		</tr>
	        	</tfoot>
	        </table>
	      </div>
    	</div>
	    <div class="foot text-right">
	      <small>&nbsp;&nbsp;&nbsp;JR.7.5.1.GP.R.117 &nbsp;</small>
	    </div>
  </body>
</html>
<?php
	$html = ob_get_clean();
	$nombre = 'OFDespiece_'.$fecha.'.pdf';
	$dompdf = new Dompdf();
	$options = $dompdf->getOptions();
	$options->set('isHtml5ParserEnabled', true);
	$options->set('isRemoteEnabled', TRUE);
	$options->set('isPhpEnabled', true);	//esto no hace nada
	$dompdf->setOptions($options);
	$dompdf->setPaper('Letter','Landscape');
	$dompdf->loadHtml($html);
	$dompdf->render();
	//$dompdf->stream($nombre);
	$archivo = $dompdf->output();
	file_put_contents('../tmp/'.$nombre, $archivo);
	die($nombre);
	} catch (Exception $e){
		echo $e->getMessage();
	} catch (DomException $e){
		echo $e->getMessage();
	}
?>