<?php
	ob_start();
	include_once('../lib/dompdf/autoload.inc.php');
	use Dompdf\Dompdf;
	use Dompdf\Exception as DOMException;
	try {
		require_once("../api/conn.php");
		require("../api/fngeneral.php");
		$GLOBALS['connmy'] = ConnIntra();
		$ot = $_REQUEST['ot'];
		$row1 = fn_getOrdenTrabajoMantencion($ot)->fetch_assoc();
		$res2 = fn_getTecnicosOrdenMantencion($ot);
		$res3 = fn_getObsOrdenMantencion($ot);
		$fecha = $row1['createdate'];
		$fechacierre = $row1['cierrasolfecha'];
		$estado = $row1['mantestado'];
 	    date_default_timezone_set("America/Santiago");
 	    setlocale(LC_TIME, 'es_CL','esp');
 	    $fecha_prog = strftime('%A %e de %B de %Y', strtotime($fecha));
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>ORDEN DE TRABAJO</title>
		<style><?=include_once '../lib/bootstrap/css/bootstrap.min.css';?></style>
		<style type="text/css">
			html {
				margin: 0;
			}
			body {
				font-family: Arial, Helvetica, Calibri;
				margin: 10mm 10mm 10mm 10mm;
			}
			body,td,th {
				font-size: 12px;
			}
			table.detalle {
				page-break-after: always;
				-fs-table-paginate: paginate;
			}
			.cont-info {
				margin: -10px 10px 10px 10px;
			}
			.back-header {
				background-color: #DFF0D8;
				border-bottom: #cecece solid 1px;
				padding-bottom: 10px;
			}
			.sub-head {
				margin-bottom: 15px;
				padding: 15px 10px -15px 10px;
			}
			.round-5 {
				border: #cecece solid 1px;
				border-radius: 5px;
				height: auto;
				margin-bottom: 10px;
				width: 100%;
			}
			.round-10 {
				border: #cecece solid 1px;
				border-radius: 10px;
			}
		</style>
	</head>
	<body>
		<table width="100%">
	      <tr>
	        <td class="text-center align-middle" width="20%">
	          <img src="./logo75_2.png" width="100" height="39">
	        </td>
	        <td  class="text-start" width="60%">
	          <address>
	            <strong>J Riveros S.A.I.C.</strong><br>
	            San Nicol&aacute;s 960-912, San Miguel.<br>
	            Santiago - Chile<br>
	            <abbr title="Phone">Tel&eacute;fono:</abbr> +56 2 2397 4444
	          </address>
	        </td>
	        <td  class="text-center align-middle" width="20%">
	          <img src="./logo_mann_filter.png" width="100" height="48">
	        </td>
	      </tr>
	    </table>
			<div class="round-5">
    	    	<table width="100%">
    	        	<tr>
    	          		<td colspan="2" width="100%" align="center" class="back-header">
    	            		<h3><strong>ORDEN DE TRABAJO #<?=$ot?></strong></h3>
    	          		</td>
    	        	</tr>
    	      	</table>
      			<div class="sub-head">
	        		<table width="100%">
    					<tr>
    					  <td><strong>Solicitado por</strong></td>
    					  <td><?=$row1['namesol']?></td>
    					  <td colspan="2">&nbsp;</td>
    					</tr>
    					<tr>
    						<td width="20%"><strong>Fecha OT</strong></td>
    						<td width="45%"><?=utf8_encode($fecha_prog)?></td>
    						<td width="10%" align="left"><strong>Estado OT</strong></td>
    						<td width="25%">
    							<?php
    							if($row1['pausa'] != 1){
    								if($row1['cierrasol'] == 1){
    									?>
    									Cerrada
    									<?php
    								}else{
    									?>
    									Pendiente
    									<?php
    								}
    							} else {
    								?>
    								En Pausa
    								<?php
    							}
    							?>
    						</td>
    					</tr>
    					<tr>
    					  <td><strong>Depto. Solicitante</strong></td>
    					  <td><?=$row1['deptoname']?></td>
    					</tr>
    					<tr>
    					  <td><strong>Máquina</strong></td>
    					  <td><?=$row1['idmaquina']?></td>
    				  </tr>
    					<tr>
    					  <td><strong>Categoria 1</strong></td>
    						<td><?=$row1['cat1']?></td>
    					</tr>
    					<tr>
    					  <td><strong>Categoria 2</strong></td>
    						<td><?=$row1['cat2']?></td>
    					</tr>
    					<tr>
    					  <td valign="top"><strong>Descripci&oacute;n General</strong></td>
    					  <td colspan="3"><?=$row1['deslarga']?></td>
    					</tr>
    					<?php
    					if($row1['cierrasol'] == 1){
    					    echo '<tr><td colspan="4"><hr></td></tr>';
    					} ?>
    					<tr>
    						<td align="left" ><strong><?=($row1['cierrasol'] == 1)?'Calificaci&oacute;n':''?></strong></td>
    						<td><?=($row1['cierrasol'] == 1)?$row1['calificacion']:''?></td>
    					</tr>
    					<tr>
    						<td valign="top"><strong><?=($row1['cierrasol'] == 1)?'Comentario:':''?></strong></td>
    						<td colspan="3"><?=($row1['cierrasol'] == 1)?$row1["calcomentario"]:''?></td>
    					</tr>
    				</table>
				</div>
    		</div>
    		<?php
    		if(mysqli_num_rows($res2) > 0){
    		?>
			<div class="round-5">
    	    	<table width="100%">
    	        	<tr>
    	          		<td colspan="2" width="100%" align="center" class="back-header">
    	            		<h4><strong>T&Eacute;CNICOS</strong></h4>
    	          		</td>
    	        	</tr>
    	      	</table>
      			<div class="sub-head">
					<table width="100%">
						<?php
						while($row2 = $res2->fetch_assoc()){
						?>
        	        	<tr>
        	          		<td colspan="2" width="100%" align="left"><?=$row2['name']?></td>
        	        	</tr>
        	        	<?php
							}
						?>
        	      	</table>
      			</div>
      		</div>
      		<?php
    		}
    		?>
      		<div class="round-5">
    	    	<table width="100%">
    	        	<tr>
    	          		<td colspan="2" width="100%" align="center" class="back-header">
    	            		<h4><strong>OBSERVACIONES</strong></h4>
    	          		</td>
    	        	</tr>
    	      	</table>
      			<div class="sub-head">
					<table class="table table-striped">
    					<thead>
    						<tr>
    							<td width="10%"><strong>Fecha</strong></td>
    							<td width="81%"><strong>Observaci&oacute;n</strong></td>
    						</tr>
    					</thead>
    					<tbody>
    						<?php
    						if(mysqli_num_rows($res3) > 0){
        						while($row2 = $res3->fetch_assoc()){
        							$fecha2 = date_create($row2['fecha']);
        						?>
        						<tr>
        						  <td><strong><?=date_format($fecha2,"d-m-Y")?></strong></td>
        						  <td><?=$row2['obs']?></td>
        						</tr>
        						<?php
        						}
    						}  else {
                            ?>
                            	<tr>
        						  <td colspan="2" align="center"><strong>Sin Observaciones</strong></td>
        						</tr>
                            <?php
    						}
    						?>
    					</tbody>
    				</table>
      			</div>
      		</div>
      		<?php
      		$buscaImagen = "SELECT nomFile FROM mant_ot_files WHERE id_ot = $ot";
      		$respImagen = $GLOBALS['connmy']->query($buscaImagen);
      		if(mysqli_num_rows($respImagen) > 0){
      		    $img = $respImagen->fetch_all();
      		    $len = count($img);
      		?>
      		<div class="round-5">
    	    	<table width="100%">
    	    		<tr>
    	          		<td colspan="2" width="100%" align="center" class="back-header">
    	            		<h4><strong>IM&Aacute;GENES - ORDEN DE TRABAJO #<?=$ot?></strong></h4>
    	          		</td>
    	        	</tr>
    	        </table>
    	        <div class="sub-head">
    	        	<table width="100%">
    					<?php
    					switch($len){
    					    case 1:
    					        ?>
    					        <tr>
            						<td align="center"><img src="../updimg/<?=$img[0][0]?>" alt="<?=$img[0][0]?>" width="350"></td>
            					</tr>
            					<?php
            					break;
    					    case 2:
    					        ?>
    					        <tr>
            						<td align="center"><img src="../updimg/<?=$img[0][0]?>" alt="<?=$img[0][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[1][0]?>" alt="<?=$img[1][0]?>" width="350"></td>
            					</tr>
            					<?php
            					break;
    					    case 3:
    					        ?>
    					        <tr>
            						<td align="center"><img src="../updimg/<?=$img[0][0]?>" alt="<?=$img[0][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[1][0]?>" alt="<?=$img[1][0]?>" width="350"></td>
            					</tr>
            					<tr>
            						<td align="center"><img src="../updimg/<?=$img[2][0]?>" alt="<?=$img[2][0]?>" width="350"></td>
            					</tr>
            					<?php
            					break;
    					    case 4:
    					        ?>
    					        <tr>
            						<td align="center"><img src="../updimg/<?=$img[0][0]?>" alt="<?=$img[0][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[1][0]?>" alt="<?=$img[1][0]?>" width="350"></td>
            					</tr>
            					<tr>
            						<td align="center"><img src="../updimg/<?=$img[2][0]?>" alt="<?=$img[2][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[3][0]?>" alt="<?=$img[3][0]?>" width="350"></td>
            					</tr>
            					<?php
            					break;
    					    case 5:
    					        ?>
    					        <tr>
            						<td align="center"><img src="../updimg/<?=$img[0][0]?>" alt="<?=$img[0][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[1][0]?>" alt="<?=$img[1][0]?>" width="350"></td>
            					</tr>
            					<tr>
            						<td align="center"><img src="../updimg/<?=$img[2][0]?>" alt="<?=$img[2][0]?>" width="350"></td>
            						<td align="center"><img src="../updimg/<?=$img[3][0]?>" alt="<?=$img[3][0]?>" width="350"></td>
            					</tr>
            					<tr>
            						<td align="center"><img src="../updimg/<?=$img[4][0]?>" alt="<?=$img[4][0]?>" width="350"></td>
            					</tr>
            					<?php
            					break;
    					}
    					?>
      				</table>
      			</div>
      		</div>
      	<?php
      	}
      	?>
	    <div align="right">
	      <small>&nbsp;&nbsp;&nbsp;JR.7.5.1.GP.R.117 &nbsp;</small>
	    </div>
  </body>
</html>
<?php
	$html = ob_get_clean();
	//echo $html;
	$nombre = 'OrdenTrabajo_'.$ot.'_'.date('d-m-Y').'.pdf';
	$dompdf = new Dompdf();
	$options = $dompdf->getOptions();
	$options->set('isHtml5ParserEnabled', true);
	$options->set('isRemoteEnabled', TRUE);
	$options->set('isPhpEnabled', true);	//esto no hace nada
	$dompdf->setOptions($options);
	$dompdf->setPaper('Letter','Portrait');
	$dompdf->loadHtml($html);
	$dompdf->render();
	//$dompdf->stream($nombre);
	$archivo = $dompdf->output();
	file_put_contents('../tmp/'.$nombre, $archivo);
	die($nombre);
	} catch (Exception $e){
		echo $e->getMessage();
	} catch (DomException $e){
		echo $e->getMessage();
	}
?>