<?php
	ob_start();
	include_once('../lib/dompdf/autoload.inc.php');
	use Dompdf\Dompdf;
	use Dompdf\Exception as DOMException;
	include('../lib/qr/vendor/autoload.php');//Llamare el autoload de la clase que genera el QR
	use Endroid\QrCode\QrCode;
	try {
	   $ot = $_REQUEST['idOT'];
	   require_once("../api/conn.php");
	   $ConnIntra = ConnIntra();
	   $Conn = Connect();
	   $qrycab = "SELECT T0.DOCENTRY, T0.ItemCode, T1.ItemName, T0.PlannedQty, T0.PostDate FROM OWOR T0
	               INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode WHERE T0.DocEntry = $ot";
	   $params = array();
	   $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	   $stmt = sqlsrv_query($Conn, $qrycab , $params, $options);
	   $cabecera = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	   $fecha = $cabecera['PostDate']->format('Y-m-d');
	  date_default_timezone_set("America/Santiago");
	  setlocale(LC_TIME, 'es_CL','esp');
	  $fecha_prog = strftime('%A %e de %B de %Y', strtotime($fecha));
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>ORDEN DE PRODUCCI&Oacute;N DE DESPIECES</title>
		<style><?=include_once '../lib/bootstrap/css/bootstrap.min.css';?></style>
		<style type="text/css">
			html {
				margin: 0;
			}
			body {
				font-family: Arial, Helvetica, Calibri;
				margin: 10mm 10mm 10mm 10mm;
			}
			body,td,th {
				font-size: 12px;
			}
			table.detalle {
				page-break-after: always;
				-fs-table-paginate: paginate;
			}
			.cuerpo{
				height: auto;
			}
			.cont-info {
				height: auto;
				margin: -10px 10px 0px 10px;
			}
			.back-header {
				background-color: #DFF0D8;
				border-bottom: #cecece solid 1px;
				padding-bottom: 10px;
			}
			.sub-head {
				margin-bottom: -15px;
				padding: 15px 10px -15px 10px;
			}
			.round-5 {
				border: #cecece solid 1px;
				border-radius: 5px;
				height: 88%;
			}
			.round-10 {
				border: #cecece solid 1px;
				border-radius: 10px;
			}
			.foot {
				bottom: 0px;
				margin-bottom: 30px;
				position: absolute;
				right: 40px;
			}
			.bg-corpgreen {
				background-color: #DFF0D8;
			}
		</style>
	</head>
	<body>
			<table width="100%">
	      <tr>
	        <td class="text-center align-middle" width="20%">
	          <img src="./logo75_2.png" width="100" height="39">
	        </td>
	        <td  class="text-start" width="60%">
	          <address>
	            <strong>J Riveros S.A.I.C.</strong><br>
	            San Nicol&aacute;s 960-912, San Miguel.<br>
	            Santiago - Chile<br>
	            <abbr title="Phone">Tel&eacute;fono:</abbr> +56 2 2397 4444
	          </address>
	        </td>
	        <td  class="text-center align-middle" width="20%">
	          <img src="./logo_mann_filter.png" width="100" height="48">
	        </td>
	      </tr>
	    </table>
			<div class="cuerpo round-5">
	      <table width="100%">
	        <tr>
	          <td colspan="2" width="100%" align="center" class="back-header">
	            <h3><strong>PASOS PRODUCCI&Oacute;N  OF <?=number_format($ot, 0, ',', '.') ?></strong></h3>
	          </td>
	        </tr>
	      </table>
      	<div class="sub-head">
	        <table width="100%">
	        <?php

	        ?>
			    <tr>
			      <td class="text-right" width="15%">
			          <p><strong>Orden de Fabricaci&oacute;n </strong></p>
			        </td>
			        <td class="text-center" width="2%">
			          <p><strong>:</strong></p>
			        </td>
			        <td class="text-left" width="20%">
			          <p><strong><?=number_format($ot, 0, ',', '.') ?></strong></p>
			        </td>
			        <td class="text-right" width="10%">
			          <p><strong>Fecha </strong></p>
			        </td>
			        <td class="text-center" width="2%">
			          <p><strong>:</strong></p>
			        </td>
			        <td class="text-left" width="25%">
			          <p><strong><?=utf8_encode($fecha_prog)?></strong></p>
			        </td>
			    </tr>
			    <tr>
			      <td class="text-right">
			          <p><strong>C&oacute;digo </strong></p>
			        </td>
			        <td class="text-center">
			          <p><strong>:</strong></p>
			        </td>
			        <td class="text-left">
			          <p><strong><?=$cabecera['ItemCode']?></strong></p>
			        </td>
			        <td class="text-right">
			          <p><strong>&nbsp; </strong></p>
			        </td>
			        <td class="text-center">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			        <td class="text-left">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			    </tr>
			    <tr>
			      <td class="text-right">
			          <p><strong>Descripci&oacute;n </strong></p>
			        </td>
			        <td class="text-center">
			          <p><strong>:</strong></p>
			        </td>
			        <td class="text-left" colspan="4">
			          <p><strong><?=utf8_encode($cabecera['ItemName'])?></strong></p>
			        </td>
			    </tr>
			    <tr>
			      <td class="text-right">
			          <p><strong>Cantidad </strong></p>
			        </td>
			        <td class="text-center">
			          <p><strong>:</strong></p>
			        </td>
			        <td class="text-left">
			          <p><strong><?=number_format($cabecera['PlannedQty'], 0, ',', '.')?></strong></p>
			        </td>
			        <td class="text-right">
			          <p><strong>&nbsp; </strong></p>
			        </td>
			        <td class="text-center">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			        <td class="text-left">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			    </tr>
			</table>
		</div>
		<hr>
		<div class="cont-info">
	        <table width="100%" align="center" class="table table-condensed table-striped">
	        	<thead>
					<tr class="bg-corpgreen">
					  <th class="text-center" width="8%">C&Oacute;DIGO</th>
						<th class="text-center" width="28%">DESCRIPCI&Oacute;N</th>
						<th class="text-center" width="9%">QR</th>
				  	</tr>
				</thead>
	          <tbody>
	          		<?php
	          		$qrydet = "SELECT T0.ItemCode, T1.ItemName FROM WOR1 T0 	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
                        WHERE T1.QryGroup33 = 'Y' AND T0.DocEntry = $ot";
	          		$params = array();
	          		$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	          		$stmt = sqlsrv_query($Conn, $qrydet , $params, $options);
	          		while ($detalle = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
    					$qrCode = new QrCode('otid='.$ot.'&step='.$detalle['ItemCode']);//Creo una nueva instancia de la clase
    					$qrCode->setSize(100);//Establece el tamao del qr
    					//header('Content-Type: '.$qrCode->getContentType());
    					$image= $qrCode->writeString();//Salida en formato de texto
    					$imageData = base64_encode($image);//Codifico la imagen usando base64_encode
					?>
					<tr class="align-middle">
						<td class="text-center"><?=$detalle['ItemCode']?></td>
						<td class="text-start"><?=utf8_encode($detalle['ItemName'])?></td>
						<td class="text-center"><img src="data:image/png;base64,<?=$imageData?>"></td>
					</tr>
					<?php
	          		}
	          		?>
				</tbody>
	        </table>
	      </div>
    	</div>
	    <div class="foot text-right">
	      <small>&nbsp;&nbsp;&nbsp;JR.7.5.1.GP.R.117 &nbsp;</small>
	    </div>
  </body>
</html>
<?php
	$html = ob_get_clean();
 	$nombre = 'GenQR-OT'.$ot.'_'.$fecha.'.pdf';
 	$dompdf = new Dompdf();
 	$options = $dompdf->getOptions();
 	$options->set('isHtml5ParserEnabled', true);
 	$options->set('isRemoteEnabled', TRUE);
 	$options->set('isPhpEnabled', true);	//esto no hace nada
 	$dompdf->setOptions($options);
 	$dompdf->setPaper('Letter','Portrait');
 	$dompdf->loadHtml($html);
 	$dompdf->render();
 	//$dompdf->stream($nombre);
 	//$archivo = $dompdf->output();
 	//file_put_contents('../tmp/'.$nombre, $archivo);
	//echo $html;
	//die($nombre);
 	$dompdf->stream('archivo.pdf', array("Attachment" => false));
 	$dompdf->output();
	} catch (Exception $e){
		echo $e->getMessage();
	} catch (DomException $e){
		echo $e->getMessage();
	}
?>