<?php
	ob_start();
	include_once('../lib/dompdf/autoload.inc.php');
	use Dompdf\Dompdf;
	use Dompdf\Exception as DOMException;
	try {
		require_once("../api/conn.php");
		require('../api/fngeneral.php');
		$GLOBALS['connmy'] = ConnIntra();
	  $fecha = date('Y-m-d');
	  date_default_timezone_set("America/Santiago");
	  setlocale(LC_TIME, 'es_CL','esp');
	  $fecha_prog = strftime('%A %e de %B de %Y', strtotime($fecha));
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>PLAN DE PRODUCCIÓN DE FILTROS SELECCIONADOS</title>
		<style><?=include_once '../lib/bootstrap/css/bootstrap.min.css';?></style>
		<style type="text/css">
			html {
				margin: 0;
			}
			body {
				font-family: Arial, Helvetica, Calibri;
				margin: 10mm 10mm 10mm 10mm;
			}
			body,td,th {
				font-size: 12px;
			}
			table.detalle {
				page-break-after: always;
				-fs-table-paginate: paginate;
			}
			.cuerpo{
				height: auto;
			}
			.cont-info {
				height: auto;
				margin: -10px 10px 0px 10px;
			}
			.back-header {
				background-color: #DFF0D8;
				border-bottom: #cecece solid 1px;
				padding-bottom: 10px;
			}
			.sub-head {
				margin-bottom: -15px;
				padding: 15px 10px -15px 10px;
			}
			.round-5 {
				border: #cecece solid 1px;
				border-radius: 5px;
				height: 88%;
			}
			.round-10 {
				border: #cecece solid 1px;
				border-radius: 10px;
			}
			.foot {
				bottom: 0px;
				margin-bottom: 30px;
				position: absolute;
				right: 40px;
			}
			.bg-corpgreen {
				background-color: #DFF0D8;
			}
		</style>
	</head>
	<body>
			<table width="100%">
	      <tr>
	        <td class="text-center align-middle" width="20%">
	          <img src="./logo75_2.png" width="100" height="39">
	        </td>
	        <td  class="text-start" width="60%">
	          <address>
	            <strong>J Riveros S.A.I.C.</strong><br>
	            San Nicol&aacute;s 960-912, San Miguel.<br>
	            Santiago - Chile<br>
	            <abbr title="Phone">Tel&eacute;fono:</abbr> +56 2 2397 4444
	          </address>
	        </td>
	        <td  class="text-center align-middle" width="20%">
	          <img src="./logo_mann_filter.png" width="100" height="48">
	        </td>
	      </tr>
	    </table>
			<div class="cuerpo round-5">
	      <table width="100%">
	        <tr>
	          <td colspan="2" width="100%" align="center" class="back-header">
	            <h3><strong>PLAN DE PRODUCCIÓN DE FILTROS SELECCIONADOS</strong></h3>
	          </td>
	        </tr>
	      </table>
      	<div class="sub-head">
	        <table width="100%">
			      <tr>
			        <td class="text-right" width="68%">
			          <p><strong>Fecha: </strong></p>
			        </td>
			        <td class="text-right" width="2%">
			          <p><strong>&nbsp;</strong></p>
			        </td>
			        <td class="text-left" width="30%">
			          <p><strong><?=utf8_encode($fecha_prog)?></strong></p>
			        </td>
			      </tr>
			    </table>
			  </div>
			  <hr>
			  <div class="cont-info">
	        <table id="result2" class="table table-condensed table-striped">
						<thead>
							<tr>
								<th class="text-center" width="3%">Sec.</th>
								<th class="text-center" width="12%">L&iacute;nea</th>
								<th class="text-center" width="7%">C&oacute;digo</th>
								<th class="text-center" width="30%">Descripci&oacute;n</th>
								<th class="text-center" width="8%">Unid. a Producir</th>
								<th class="text-center" width="8%">Tiempo Est. Item</th>
							</tr>
						</thead>
						<tbody>
							<?php
								$qry = "SELECT * FROM tb_plan_secdespiecescab ORDER BY linea, sec";
								$res = $GLOBALS['connmy']->query($qry);
								while($fila = $res->fetch_assoc()){
									?>
									<tr>
										<td class="text-left">		<?=$fila['sec']?></td>
										<td class="text-center">	<?=fn_getNombreLinea($fila['linea'])?></td>
										<td class="text-center">	<?=$fila['itemcode']?></td>
										<td class="text-left">		<?=$fila['itemname']?></td>
										<td class="text-right">		<?=number_format($fila['unixproducir'], 0, ',', '.')?></td>
										<td class="text-right">		<?=number_format($fila['tiempo'], 2, ',', '.')?></td>
									</tr>
									<?php
								}
							?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="4" class="text-right"><strong>Total Filtros: </strong></td>
								<td colspan="2" class="text-left"><strong><?=mysqli_num_rows($res) ?></strong></td>
							</tr>
						</tfoot>
					</table>
	      </div>
    	</div>
	    <div class="foot text-right">
	      <small>&nbsp;&nbsp;&nbsp;JR.7.5.1.GP.R.117 &nbsp;</small>
	    </div>
  </body>
</html>
<?php
	$html = ob_get_clean();
	$nombre = 'FiltrosParaDespiece_'.$fecha.'.pdf';
	$dompdf = new Dompdf();
	$options = $dompdf->getOptions();
	$options->set('isHtml5ParserEnabled', true);
	$options->set('isRemoteEnabled', TRUE);
	$options->set('isPhpEnabled', true);	//esto no hace nada
	$dompdf->setOptions($options);
	$dompdf->setPaper('Letter','Portrait');
	$dompdf->loadHtml($html);
	$dompdf->render();
	//$dompdf->stream($nombre);
	$archivo = $dompdf->output();
	file_put_contents('../tmp/'.$nombre, $archivo);
	die($nombre);
	} catch (Exception $e){
		echo $e->getMessage();
	} catch (DomException $e){
		echo $e->getMessage();
	}
?>