<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-8 col-lg-8 col-sm-12 offset-md-2 offset-lg-2">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Permisos por P&aacute;gina</h5>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
						<table class="table table-hover table-striped" id="result">
							<thead>
								<tr>
									<th>Tipo Elemento</th>
									<th>Men&uacute;</th>
									<th class="text-end">Cantidad de Usuarios</th>
								</tr>
							</thead>
							<tbody>
								<?php
									$rs = fn_getUsuariosPorMenu();
									while($dato = $rs->fetch_assoc()){
								?>
								<tr>
									<td class="text-start"><?=$dato['tipo']?></td>
									<td><a href="home.php?pid=<?=$_GET['pid']?>&sys=<?=$_GET['sys']?>&pg=detperpagina&mnu=<?=$dato['id']?>"><?=$dato['menu']?></a></td>
									<td class="text-end"><?=$dato['usuarios']?></td>
								</tr>
								<?php
									}
								?>
							</tbody>
						</table>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>