<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.12.1/b-2.2.3/b-html5-2.2.3/b-print-2.2.3/datatables.min.js"></script>
<script>
$(document).ready(function() {
	$('#result thead td').each( function () {
        var title = $('#result thead td').eq( $(this).index() ).text();
        $(this).html( '<input class="form-control form-control-sm" type="text" />' );
    } );
  var table = $('#result').removeAttr('width').DataTable({
   	dom: 'rtip',
    buttons: ['excel'],
		scrollY: '45vh',
		scrollX: '100%',
    scrollCollapse: true,
		fixedHeader: false,
		"ordering": false,
    paging: false,
		"pageLength": 100,
		responsive: true,
		"autoWidth": false,
		"language": {
    	"info": "Registros visualizados: _MAX_",
			"search": "Buscar:",
			"zeroRecords": "No se han encontrado registros",
			"decimal": ",",
	  	"thousands": ".",
			"paginate": {
		    "first":      "Primera",
	      "last":       "Ultima",
	      "next":       "Siguiente",
	      "previous":   "Anterior"
    	}
    }
  });

  table.columns().every( function () {
    var that = this;
    $( 'input', this.header() ).on( 'keyup change', function () {
    	that
        .search( this.value )
        .draw();
    });
  });
});

</script>
<style>
	thead input {
	  width: 100%;
	}
</style>
<div class="row">
	<div class="col-md-12 col-lg-12 col-sm-12">
	  <div class="card">
	    <div class="card-header bg-success">
	      <h5 class="card-title">Solicitud de Compras</h5>
	    </div>
	    <div class="card-body">
	    	<div class="row">
	    		<div class="col-md-12 col-lg-12 col-sm-12">
	    			<table class="table table-sm table-hover table-striped" id="result">
	    				<thead>
	    					<tr>
	    						<th class="text-center">Nro. Solicitud</th>
	    						<th class="text-center">Fecha Creaci&oacute;n</th>
	    						<th class="text-center">Descripci&oacute;n</th>
	    						<th class="text-center">Solicitante</th>
	    						<th class="text-center">Departamento</th>
	    						<th class="text-center">Estado</th>
	    						<th class="text-center">Fecha Cierre</th>
	    					</tr>
	    				</thead>
	    				<tbody>
    					<?php
    					$lista = fn_getListaSolicitudesCompra();
    					while($fila = $lista->fetch_assoc()){
    					    ?>
    					    <tr>
    					    	<td class="text-center"><?=$fila['ID'] ?></td>
    					    	<td class="text-center"><?=$fila['creacion'] ?></td>
    					    	<td class="text-start"><?=$fila['descripcion'] ?></td>
    					    	<td class="text-center"><?=$fila['Solicita'] ?></td>
    					    	<td class="text-center"><?=$fila['Estado'] ?></td>
    					    	<td class="text-center"><?=$fila['Departamento'] ?></td>
    					    	<td class="text-center"><?=$fila['termino'] ?></td>
    					    </tr>
    					    <?php
    					}
    					?>
						</tbody>
					</table>
	    		</div>
	    	</div>
	    </div>
    </div>
	</div>
</div>