<?php
    include("../../liblist.php");
    $ConnIntra = ConnIntra();
    date_default_timezone_set("America/Santiago");

    $qryRevisa = "SELECT ID FROM tb_plan_mideplantas WHERE fecha = DATE_FORMAT(NOW(), '%Y-%m-%d')";
    $interRevisa = $ConnIntra->query($qryRevisa);
    if (mysqli_num_rows($interRevisa) > 0){
        $qryLimpia = "DELETE FROM tb_plan_mideplantas WHERE fecha = DATE_FORMAT(NOW(), '%Y-%m-%d')";
        $ConnIntra->query($qryLimpia);
    }

    $param = fn_getParametrosCalculo('prd')->fetch_assoc();
    $fecha = date("W");

    $porc = (($param['mesesprod'] * $param['segfactor'])/100);
    $hora_ini = date_create(date('Y-m-d H:i:s'));

    for ($porCompara = 10; $porCompara <= 100; $porCompara += 10){

        $sw = true;
        $val_base = 10;
        $val_maximo = 60;
        $mensaje = array();

        for ($indice = $val_base; $indice <= ($indice+1); $indice++){
            $qry_ppal = "SELECT * FROM tb_plan_calcfinal WHERE dias_sobre_minimo BETWEEN $indice AND ".($indice+1)." AND semana = $fecha";
            $inter_ppal = $ConnIntra->query($qry_ppal);
            while ($filtros = $inter_ppal->fetch_assoc()){
                if(fn_getBuffer($filtros['ItemCode']) != 0){
                    $buffer = fn_getBuffer($filtros['ItemCode']);
                } else {
                    $buffer = fn_getBufferVentas2($filtros['ItemCode']);
                }
                $receta = fn_getRecetaItem410($filtros['ItemCode']);
                if ($buffer < $param['piso_buffer']){
                    $factor =  $param['mesesprodalt'] + $porc;
                } else {
                    $factor = $param['mesesprod'] + $porc;
                }
                $factor *= $buffer;
                while ($pieza = $receta->fetch_assoc()){
                    $cant_OF = fn_getOrdenesFabricacionDespiece($pieza['hijo']);
                    $cant_necesaria = $pieza['cantidad']*$factor;
                    $stock = fn_getStockDespieceItem($pieza['hijo']);
                    $valCompara = $cant_necesaria*($porCompara/100);
                    if ($valCompara > $stock){
                        array_push($mensaje,  'Item: ('.$pieza['hijo'].') '.$pieza['descripcion'].'<br>D&iacute;a de quiebre: '.$indice.'<br>Cantidad Requerida: '.number_format($cant_necesaria, 0, ',','.').'<br>Cantidad Disponible: '.number_format($stock, 0, ',','.').'<br>Cantidad en OF: '.number_format($cant_OF, 0, ',', '.'));
                        $sw = false;
                    }
                }
            }
            if(!$sw){
                break;
            }
            if ($indice == $val_maximo){
                array_push($mensaje, 'No se encontraron despieces insuficientes.');
                break;
            }
        }
        $hora_ter = date_create(date('Y-m-d H:i:s'));
        $tiempo = date_diff($hora_ini, $hora_ter);
        $minutos = $tiempo->days * 24 * 60;
        $minutos += $tiempo->h * 60;
        $minutos += $tiempo->i;
        $segundos = $tiempo->s;
        if($minutos == 1 && $segundos == 0){
            $comp = ' minuto';
        } elseif ($minutos == 0) {
            $comp = ' segundos';
        } else {
            $comp = ' minutos';
        }
        $min = '00';
        if ($minutos < 10){
            $min = '0'.$minutos;
        } else {
            $min = $minutos;
        }
        $seg = '00';
        if ($segundos < 10){
            $seg = '0'.$segundos;
        } else {
            $seg = $segundos;
        }
        $res_tiempo =  ' '.$min.':'.$seg.$comp;
        foreach($mensaje as $msg){
            $qry = "INSERT INTO tb_plan_mideplantas (fecha, hora, mensaje, porcentaje, dia_quiebre, tiempo, hra_inicio, hra_termino)
                values (DATE_FORMAT(NOW(), '%Y-%m-%d'), DATE_FORMAT(NOW(), '%H:%i:%s'), '$msg', $porCompara, $indice,'$res_tiempo', '".date_format($hora_ini, 'Y-m-d H:i:s')."','".date_format($hora_ter, 'Y-m-d H:i:s')."')";
            $ConnIntra->query($qry);
        }
    }

    $resp = array(
        'resp' => 'true'
    );
    echo json_encode($resp);
?>