<?php
    include("../../liblist.php");
    $GLOBALS['ConnIntra'] = ConnIntra();
    $GLOBALS['Conn'] = Connect();
    $logDir = "./logs/";
    $logfileName = "ProgramaMensualLog_".date('dmYHis').".txt";
    $fullFileName = $logDir . $logfileName;

    echo 'Creando archivo de registro de proceso: ' . $logfileName, PHP_EOL;
    $logfile = fopen($fullFileName, "a") or die("Error creando archivo " . $logfileName);
    $_SESSION['logfile'] = $logfile;
    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tInicio de proceso mensual\r\n") or die("Error escribiendo en el archivo\r\n");

    /*actualizaRecetasOF();
    actualizaMaestroArticulos();
    actualizaMaestroRecetas();
    actualizaCapacidadesLinea();
    actualizaVentaAnual();
    actualizaVentaTrimestral();
    actualizaProduccionAnual();
    actualizaProduccionTrimestral();
    actualizaVentaMensual();
    actualizaBaseDeCalculo();*/
    actualizaBaseDeCalculoFiltros();

    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tProceso finalizado") or die("Error escribiendo en el archivo");
    fclose($_SESSION['logfile']);

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                            Error Handler                                                                                                                                       */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

    set_error_handler('exceptions_error_handler');

    function exceptions_error_handler($severity, $message, $filename, $lineno) {
        if (error_reporting() == 0) {
            return;
        }
        if (error_reporting() & $severity) {
            $mensaje = "Severidad: ".$severity."\r\n\t\t\t\t";
            $mensaje .= "Archivo: ".$filename."\r\n\t\t\t\t";
            $mensaje .= "L�nea Nro.: ".$lineno."\r\n\t\t\t\t";
            $mensaje .= "Error: ".$message;
            fwrite($_SESSION['logfile'] , "".date("d/m/Y H:i:s")." -\t".$mensaje."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo $mensaje, PHP_EOL;
        }
    }

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                      Actualiza Recetas OF                                                                                                                              */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    function actualizaRecetasOF(){
    try {
        $cls = "DELETE FROM tb_plan_receta_of";
        $GLOBALS['ConnIntra']->query($cls);
        $tsql = "SELECT T1.DocEntry, T0.ItemCode[Cod_Padre], T1.Linenum, T1.ItemCode[Cod_Hijo], T1.BaseQty, T1.PlannedQty, T1.IssuedQty,
    			T1.IssueType, T1.wareHouse FROM OWOR T0 INNER JOIN WOR1 T1 ON T0.DocEntry = T1.DocEntry WHERE T0.Status IN ('P','R')";
        $params = array();
        $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
        $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options );
        while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
            $qry = "INSERT INTO tb_plan_receta_of (DocEntry, cod_padre, linenum, cod_hijo, BaseQty, PlannedQty, IssuedQty, IssueType,
    				wareHouse) VALUES (".$fila['DocEntry'].",'".$fila['Cod_Padre']."',".$fila['Linenum'].",'".$fila['Cod_Hijo']."',
    				".$fila['BaseQty'].",".$fila['PlannedQty'].",".$fila['IssuedQty'].",'".$fila['IssueType']."','".$fila['wareHouse']."')";
            $GLOBALS['ConnIntra']->query($qry);
        }
        echo 'Recetas OF = true', PHP_EOL;;
        fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tRecetas OF calculado correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
    } catch (Exception $e) {
        fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Recetas OF\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
        echo 'Recetas OF = false', PHP_EOL;;
    }
}

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                            Actualiza Maestro de Art�culos                                                                                                                    */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaMaestroArticulos(){
   try{
       $tsql = "SELECT ItemCode, ItemName, isnull(U_Nivel1, '') as U_Nivel1, U_Descripcion1, isnull(U_Nivel2, '') as U_Nivel2, U_Descripcion2,
		isnull(U_Nivel3, '') as U_Nivel3, U_Descripcion3, isnull(U_Nivel4, '') as U_Nivel4,
		U_Descripcion4, DfltWH, isnull(U_BAJA, 'N') as U_BAJA
		FROM OITM WHERE validFor = 'Y' AND U_Nivel1 IN (100, 150, 170, 200, 250, 410, 420, 430, 500, 510, 511, 550, 551, 553, 560, 900)";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $bsc = "DELETE FROM tb_plan_maestro";
           $GLOBALS['ConnIntra']->query($bsc);
           while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               $qry = "INSERT INTO tb_plan_maestro (ItemCode, ItemName, U_Nivel1, U_Descripcion1, U_Nivel2, U_Descripcion2,
					U_Nivel3, U_Descripcion3, U_Nivel4, U_Descripcion4, DefWH, U_BAJA, fec_get) VALUES ('".$rowDet['ItemCode']."','".$rowDet['ItemName']."','".$rowDet['U_Nivel1']."',
          '".$rowDet['U_Descripcion1']."','".$rowDet['U_Nivel2']."','".$rowDet['U_Descripcion2']."',
					'".$rowDet['U_Nivel3']."','".$rowDet['U_Descripcion3']."','".$rowDet['U_Nivel4']."','".$rowDet['U_Descripcion4']."',
					'".$rowDet['DfltWH']."','".$rowDet['U_BAJA']."',DATE_FORMAT(NOW(), '%m-%Y'));";
               $GLOBALS['ConnIntra']->query($qry);
               
           }
       }
       echo 'Maestro de Articulos = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tMaestro de articulos calculado correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Maestro de articulos\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Maestro de Articulos = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                                             Actualiza Maestro de Recetas                                                                                                                     */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
function actualizaMaestroRecetas(){
   try {
       $tsql = "SELECT a.father, b.qauntity, a.childnum, a.code, c.Itemname, a.quantity, a.warehouse FROM ITT1 a	INNER JOIN OITT b ON a.Father = b.code
            INNER JOIN OITM c ON a.Code = c.ItemCode ORDER BY a.father, a.childnum";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $bsc = "DELETE FROM tb_plan_recetas";
           $GLOBALS['ConnIntra']->query($bsc);
           while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               if (fn_getexclude($fila['code']) === false){
                   $iqry = "INSERT INTO tb_plan_recetas (padre, cant_padre, corr_hijo, hijo, descripcion, cantidad, bodega, fec_get)
			VALUES ('".$fila['father']."',".$fila['qauntity'].",".$fila['childnum'].",'".$fila['code']."',
				'".$fila['Itemname']."',".$fila['quantity'].",'".$fila['warehouse']."','".date('m-Y')."')";
                   $GLOBALS['ConnIntra']->query($iqry);
               }
           }
       }
       echo 'Maestro de Recetas = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tMaestro de Recetas calculado correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Maestro de recetas\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Maestro de Recetas = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                                             Actualiza Capacidades de L�nea                                                                                                                  */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaCapacidadesLinea(){
   try {
       $sql = "SELECT DISTINCT fec_get FROM tb_plan_capaprod WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
       $val = $GLOBALS['ConnIntra']->query($sql);
       if (mysqli_num_rows($val) == 0){
           $mes = date('n')-1;
           if ($mes == 0){
               $mes = 12;
               $anni = date('Y')-1;
           } else {
               $anni = date('Y');
           }
           $qrydp = "SELECT U_DiasProd FROM tb_plan_param_diasprod WHERE U_Anio = $anni and U_Mes = $mes";
           $res1 =$GLOBALS['ConnIntra']->query($qrydp);
           $dias = $res1->fetch_assoc()['U_DiasProd'];
           $tsql = "WITH
	      capa AS (SELECT T0.[DocNum], T0.[PostDate],  T0.[ItemCode] item1, T0.[PlannedQty], T0.[CmpltQty], T2.[DocEntry] doc1, T1.[DocEntry] doc2,
	      		T2.[DocDate], T1.[ShipDate], T1.[BaseRef], T1.[BaseType], T1.[ItemCode] item2, T1.[Quantity], T3.[U_Nivel2]
	      	FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
	      		INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
	      		INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
	      	WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
	      		AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1))
	      SELECT U_Nivel2, SUM(Quantity) AS capacidad
	      FROM capa
	      GROUP BY U_Nivel2
	      ORDER BY U_Nivel2";
           $params = array();
           $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
           $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
           if($stmt === false){
               die(print_r(sqlsrv_errors(), true));
           } else {
               while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
                   $qry = "SELECT manual FROM tb_plan_capaprod WHERE IDlinea = ".$rowDet['U_Nivel2']." AND
						fec_get = (SELECT DISTINCT fec_get FROM tb_plan_capaprod WHERE IDlinea = ".$rowDet['U_Nivel2']." ORDER BY fec_get DESC LIMIT 1)";
                   $res1 = $GLOBALS['ConnIntra']->query($qry);
                   $manual = $res1->fetch_assoc()['manual'];
                   $tot_anni = $rowDet['capacidad'] / 12;
                   $tot_mes = $tot_anni / $dias;
                   if (mysqli_num_rows($res1) > 0){
                       $qry = "INSERT INTO tb_plan_capaprod (IDlinea, tot_prod, tot_anni, tot_mes, manual, fec_get)
		          VALUES (".$rowDet['U_Nivel2'].",".$rowDet['capacidad'].",".$tot_anni.",".$tot_mes.",".$manual.",DATE_FORMAT(NOW(), '%m-%Y'));";
                       $GLOBALS['ConnIntra']->query($qry);
                   } else {
                       $qry = "INSERT INTO tb_plan_capaprod (IDlinea, tot_prod, tot_anni, tot_mes, manual, fec_get)
		          VALUES (".$rowDet['U_Nivel2'].",".$rowDet['capacidad'].",".$tot_anni.",".$tot_mes.",0,DATE_FORMAT(NOW(), '%m-%Y'));";
                       $GLOBALS['ConnIntra']->query($qry);
                   }
               }
           }
       }
       echo 'Capacidades de Linea = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tCapacidades de linea calculado correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Capacidades de linea\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Capacidades de Linea = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                            Actualiza Datos de Filtros (Venta Anual)                                                                                                                 */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaVentaAnual(){
    try {
        $tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
        $params = array();
        $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
        $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
        if($stmt === false){
            die(print_r(sqlsrv_errors(), true));
        } else {
            $qry = "SELECT * FROM tb_plan_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
            $ver = $GLOBALS['ConnIntra']->query($qry);
            if (mysqli_num_rows($ver) > 0){
                $qry = "DELETE FROM tb_plan_venta_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
                $GLOBALS['ConnIntra']->query($qry);
            }
            while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
                $qry = "INSERT INTO tb_plan_venta_anual (anni, mes, ItemCode, und_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
                $GLOBALS['ConnIntra']->query($qry);
            }
        }
        echo 'Venta Anual = true', PHP_EOL;
        fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tVenta anual calculada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
    } catch (Exception $e) {
        fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Venta anual\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Venta Anual = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                       Actualiza Datos de Filtros (Venta Trimestral)                                                                                                             */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaVentaTrimestral(){
   try {
       $tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -4)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $qry = "SELECT * FROM tb_plan_venta_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
           $ver = $GLOBALS['ConnIntra']->query($qry);
           if (mysqli_num_rows($ver) > 0){
               $qry = "DELETE FROM tb_plan_venta_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
               $GLOBALS['ConnIntra']->query($qry);
           }
           while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               $qry = "INSERT INTO tb_plan_venta_trim (anni, mes, ItemCode, und_trim, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
               $GLOBALS['ConnIntra']->query($qry);
           }
       }
       echo 'Venta Trimestral = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tVenta trimestral calculada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Venta trimestral\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Venta Trimestral = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                      Actualiza Datos de Filtros (Producci�n Anual)                                                                                                            */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaProduccionAnual(){
   try {
       $tsql = "SELECT YEAR(T1.[ShipDate]) as anni, MONTH(T1.[ShipDate]) as mes, T0.[ItemCode], sum(T1.[Quantity]) AS prod_anual
			FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
			INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
			INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
			WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
			AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -13)) AND EOMONTH(GETDATE(), -1)
			GROUP BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $qry = "SELECT * FROM tb_plan_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
           $ver = $GLOBALS['ConnIntra']->query($qry);
           if (mysqli_num_rows($ver) > 0){
               $qry = "DELETE FROM tb_plan_produccion_anual WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
               $GLOBALS['ConnIntra']->query($qry);
           }
           while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               $qry = "INSERT INTO tb_plan_produccion_anual (anni, mes, ItemCode, prod_anual, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['prod_anual'].",DATE_FORMAT(NOW(), '%m-%Y'));";
               $GLOBALS['ConnIntra']->query($qry);
           }
       }
       echo 'Produccion Anual = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tProduccion anual calculada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Produccion anual\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Produccion Anual = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                  Actualiza Datos de Filtros (Producci�n Trimestral)                                                                                                       */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaProduccionTrimestral(){
   try {
       $tsql = "SELECT YEAR(T1.[ShipDate]) as anni, MONTH(T1.[ShipDate]) as mes, T0.[ItemCode], sum(T1.[Quantity]) AS prod_anual
			FROM OWOR T0 INNER JOIN IGN1 T1 ON T1.[BaseRef] = T0.[DocNum] INNER JOIN OIGN T2 ON T2.[DocEntry] = T1.[DocEntry]
			INNER JOIN OITM T3 ON T3.[ItemCode]= T1.[ItemCode]
			INNER JOIN OITM T4 ON T4.[ItemCode] = T0.[ItemCode]
			WHERE T1.[BaseType] = '202' AND T3.[U_Nivel1] IN (100, 150, 170, 200, 250) AND T4.[U_Nivel1] IN (100, 150, 170, 200, 250)
			AND T2.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -4)) AND EOMONTH(GETDATE(), -1)
			GROUP BY YEAR(T1.[ShipDate]), MONTH(T1.[ShipDate]), T0.ItemCode";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $qry = "SELECT * FROM tb_plan_produccion_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
           $ver = $GLOBALS['ConnIntra']->query($qry);
           if (mysqli_num_rows($ver) > 0){
               $qry = "DELETE FROM tb_plan_produccion_trim WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
               $GLOBALS['ConnIntra']->query($qry);
           }
           while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               $qry = "INSERT INTO tb_plan_produccion_trim (anni, mes, ItemCode, prod_trim, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['prod_anual'].",DATE_FORMAT(NOW(), '%m-%Y'));";
               $GLOBALS['ConnIntra']->query($qry);
           }
       }
       echo 'Produccion Trimestral = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tProduccion trimestral calculada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Produccion trimestral\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Produccion Trimestral = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                         Actualiza Datos de Filtros (Venta Mensual)                                                                                                              */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaVentaMensual(){
   try {
       $tsql = "SELECT YEAR(T0.[DocDate]) AS anni, MONTH(T0.[DocDate]) AS mes, T0.[ItemCode], SUM(T0.[Quantity]) AS UNID
	    FROM INV1 T0 INNER JOIN OITM T1 ON T1.[ItemCode] = T0.[ItemCode]
	    WHERE T0.[DocDate] BETWEEN DATEADD(DAY, 1, EOMONTH(GETDATE(), -2)) AND EOMONTH(GETDATE(), -1) AND T1.[U_Nivel1] IN (100, 150, 170, 200, 250)
	    GROUP BY YEAR(T0.[DocDate]), MONTH(T0.[DocDate]), T0.[ItemCode]";
       $params = array();
       $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
       $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options);
       if($stmt === false){
           die(print_r(sqlsrv_errors(), true));
       } else {
           $qry = "SELECT * FROM tb_plan_venta_mes WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
           $ver = $GLOBALS['ConnIntra']->query($qry);
           if (mysqli_num_rows($ver) > 0){
               $qry = "DELETE FROM tb_plan_venta_mes WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
               $GLOBALS['ConnIntra']->query($qry);
           }
           while ($rowDet = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
               $qry = "INSERT INTO tb_plan_venta_mes (anni, mes, ItemCode, und_dia, fec_get)
          VALUES ('".$rowDet['anni']."','".$rowDet['mes']."','".$rowDet['ItemCode']."',".$rowDet['UNID'].",DATE_FORMAT(NOW(), '%m-%Y'));";
               $GLOBALS['ConnIntra']->query($qry);
           }
       }
       echo 'Venta Mensual = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tVenta mensual calculada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Venta mensual\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Venta Mensual = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                         Actualiza Datos de Filtros (Base de Calculo)                                                                                                             */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaBaseDeCalculo(){
     /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                         Actualiza Datos de Filtros (Base de Calculo)                                                                                                             */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

   try {
       $niveles = fn_getniveles();
       $qry = "SELECT a.ItemCode, (select ifnull(sum(b.und_anual), 0) FROM tb_plan_venta_anual b WHERE b.ItemCode = a.ItemCode and b.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_anual,
				 (SELECT ifnull(sum(c.und_trim), 0) FROM tb_plan_venta_trim c WHERE c.ItemCode = a.ItemCode and c.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_trim,
				 (SELECT ifnull(sum(d.prod_anual), 0) FROM tb_plan_produccion_anual d WHERE d.ItemCode = a.ItemCode and d.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) prod_anual,
				 (SELECT ifnull(sum(e.prod_trim), 0) FROM tb_plan_produccion_trim e WHERE e.ItemCode = a.ItemCode and e.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) prod_trim,
				 (SELECT ifnull(sum(f.und_dia), 0) FROM tb_plan_venta_mes f WHERE f.ItemCode = a.ItemCode and f.fec_get = DATE_FORMAT(NOW(), '%m-%Y')) und_dia
				FROM tb_plan_maestro a WHERE a.U_Nivel1 IN (".$niveles.") AND NOT a.U_BAJA = 'Y'";
       $resp = $GLOBALS['ConnIntra']->query($qry);

       $qry = "SELECT * FROM tb_plan_movimiento_item WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
       $resp1 = $GLOBALS['ConnIntra']->query($qry);
       if (mysqli_num_rows($resp1) > 0){
           $qry = "DELETE FROM tb_plan_movimiento_item WHERE fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
           $GLOBALS['ConnIntra']->query($qry);
       }
       while($fila = $resp->fetch_assoc()){
           $prom = fn_getDiasVentas($fila['ItemCode']);
           $und_anual_mes = round($fila['und_anual'] / 12);
           $und_trim_mes = round($fila['und_trim'] / 3);
           $prod_anual_mes = round($fila['prod_anual'] / 12);
           $prod_trim_mes = round($fila['prod_trim'] / 3);
           if ($prom == 0){
               $und_mes_dia = 0;
           } else {
               $und_mes_dia = round($fila['und_dia'] / $prom);
           }

           //if (fn_getBuffer($fila['ItemCode']) == 0){
               $buffervta2 = fn_getBufferVentas2($fila['ItemCode']);
           /*} else {
               $buffervta2 = fn_getBuffer($fila['ItemCode']);
           }*/

           $qry = "INSERT INTO tb_plan_movimiento_item (ItemCode, und_anual, und_trim, und_mes, prod_anual, prod_trim, mayor, fec_get) VALUES
				('".$fila['ItemCode']."',".$und_anual_mes.",".$und_trim_mes.",".$und_mes_dia.",".$prod_anual_mes.",".$prod_trim_mes.",".$buffervta2.",DATE_FORMAT(NOW(), '%m-%Y'))";

           $GLOBALS['ConnIntra']->query($qry);
       }
       echo 'Datos de filtros = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tDatos de filtros calculados correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError calculando Datos de filtros\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Datos de filtros = false', PHP_EOL;
   }
}

   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
   /*                                                                                                                                                                                                                                                                                              */
   /*                                                                                                    Actualiza Base de C�lculo Filtros                                                                                                                        */
   /*                                                                                                                                                                                                                                                                                              */
   /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function actualizaBaseDeCalculoFiltros(){
   try {
       $params = fn_getParametrosCalculo('prd')->fetch_assoc();
       $niveles = fn_getniveles();
       $qryppal = "SELECT ItemCode, ItemName FROM tb_plan_maestro WHERE U_Nivel1 IN (".$niveles.") AND NOT U_BAJA = 'Y'";
       $resppal = $GLOBALS['ConnIntra']->query($qryppal);
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tSELECT ItemCode, ItemName FROM tb_plan_maestro WHERE U_Nivel1 IN (".$niveles.") AND NOT U_BAJA = 'Y'\r\n") or die("Error escribiendo en el archivo\r\n");
        while ($fila = $resppal->fetch_assoc()){
            echo $fila['ItemCode'], PHP_EOL;
        $qryd = "SELECT ItemCode FROM tb_plan_base_calculo WHERE ItemCode = '".$fila['ItemCode']."'";
        $rd = $GLOBALS['ConnIntra']->query($qryd);

           if (mysqli_num_rows($rd) != 0){
               $qryd = "DELETE FROM tb_plan_base_calculo WHERE ItemCode = '".$fila['ItemCode']."'";
              $GLOBALS['ConnIntra']->query($qryd);
           }
             /* se comenta porque la consulta se repite en la linea 520 */   


         /* if (fn_getBuffer($fila['ItemCode']) != 0){
               $buffer = fn_getBuffer($fila['ItemCode']);
           } else {*/
               $buffer = fn_getBufferVentas2($fila['ItemCode']);
           //}

            if($buffer == 0){$buffer=1;}

                $inter = fn_getOrdenesFabricacionItem($fila['ItemCode']);
                if (sqlsrv_num_rows($inter) == 0){
                    $enOF = 0;
                } else {
                    $OFs = sqlsrv_fetch_array( $inter, SQLSRV_FETCH_ASSOC);
                    $enOF = $OFs['PlannedQty'] - $OFs['CmpltQty'];
                }

                $stock = fn_getStockItem($fila['ItemCode']) + $enOF;
                $stkbuff = $stock/$buffer;
                $und_a_producir = 0;

                if($stkbuff <= $params['corte_prod']){
                    if($buffer > $params['piso_buffer']){
                       //$und_a_producir = ( ( $params['mesesprod'] + $params['segfactor'] + $params['corte_prod'] )-( $stkbuff ) ) * $buffer;
                        $und_a_producir = (  $params['mesesprod'] + $params['segfactor']  ) * $buffer;
                    } else {
                      // $und_a_producir = ( ( $params['mesesprodalt'] + $params['segfactor'] + $params['corte_prod'] )-( $stkbuff ) ) * $buffer;
                        $und_a_producir = (  $params['mesesprodalt'] + $params['segfactor']  ) * $buffer;
                    }
                }

                $unid_recomendadas = fn_getValorRedondeado($fila['ItemCode'], $und_a_producir);


                $qry = "SELECT ItemCode FROM tb_plan_base_calculo WHERE ItemCode = '".$fila['ItemCode']."'";
                fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\t$qry\r\n") or die("Error escribiendo en el archivo\r\n");
                $r = $GLOBALS['ConnIntra']->query($qry);
                if (mysqli_num_rows($r) == 0){
                    $qry = "INSERT INTO tb_plan_base_calculo (ItemCode, base_calc_mensual, und_recomendada, fec_get)
                        VALUES ('".$fila['ItemCode']."',".$buffer.",".$unid_recomendadas.",DATE_FORMAT(NOW(), '%Y-%m-%d %H:%i:%s'))";
                         
                    $GLOBALS['ConnIntra']->query($qry);

                    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tINSERT INTO tb_plan_base_calculo (ItemCode, base_calc_mensual, und_recomendada, fec_get) VALUES ('".$fila['ItemCode']."',".$buffer.",".$unid_recomendadas.",DATE_FORMAT(NOW(), '%Y-%m-%d %H:%i:%s'))\r\n") or die("Error escribiendo en el archivo\r\n");

                } else {
                    $qry = "UPDATE tb_plan_base_calculo SET base_calc_mensual = ".$buffer.", und_recomendada = ".$unid_recomendadas.", fec_get = DATE_FORMAT(NOW(), '%Y-%m-%d %H:%i:%s')
                    WHERE ItemCode = '".$fila['ItemCode']."'";
                    $GLOBALS['ConnIntra']->query($qry);
                }

                $qry = "SELECT ItemCode FROM tb_plan_base_calculo_hist WHERE ItemCode = '".$fila['ItemCode']."' and fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
                $r = $GLOBALS['ConnIntra']->query($qry);
                if (mysqli_num_rows($r) == 0){
                    $qry = "INSERT INTO tb_plan_base_calculo_hist (ItemCode, base_calc_mensual, und_recomendada, fec_get)
                        VALUES ('".$fila['ItemCode']."',".$buffer.",".$unid_recomendadas.",DATE_FORMAT(NOW(), '%m-%Y'))";
                    $GLOBALS['ConnIntra']->query($qry);
                } else {
                    $qry = "UPDATE tb_plan_base_calculo SET base_calc_mensual = ".$buffer.", und_recomendada = ".$unid_recomendadas.", fec_get = DATE_FORMAT(NOW(), '%m-%Y')
                    WHERE ItemCode = '".$fila['ItemCode']."' and fec_get = DATE_FORMAT(NOW(), '%m-%Y')";
                    $GLOBALS['ConnIntra']->query($qry);
                }
            //}
        }
       echo 'Base Calculo = true', PHP_EOL;
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tBase de calculo realizada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
   } catch (Exception $e) {
       fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError procesando la Base de calculo\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
       echo 'Base Calculo = false', PHP_EOL;
   }
}
?>