<?php
    include("../../liblist.php");
    $GLOBALS['ConnIntra'] = ConnIntra();
    $GLOBALS['Conn'] = Connect();
    $logDir = "./logs/";
    $logfileName = "Problamiento TB_JOB_FILTROS ".date('dmYHis').".txt";
    $fullFileName = $logDir . $logfileName;

    echo 'Creando archivo de registro de proceso: ' . $logfileName, PHP_EOL;
    $logfile = fopen($fullFileName, "a") or die("Error creando archivo " . $logfileName);
    $_SESSION['logfile'] = $logfile;
    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tInicio de proceso mensual\r\n") or die("Error escribiendo en el archivo\r\n");

    JobSaveRecetas();
    JobSaveDataFiltros();
    JobSaveStockDiario();
   

    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tProceso finalizado") or die("Error escribiendo en el archivo");
    fclose($_SESSION['logfile']);

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                            Error Handler                                                                                                                                       */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

    set_error_handler('exceptions_error_handler');

    function exceptions_error_handler($severity, $message, $filename, $lineno) {
        if (error_reporting() == 0) {
            return;
        }
        if (error_reporting() & $severity) {
            $mensaje = "Severidad: ".$severity."\r\n\t\t\t\t";
            $mensaje .= "Archivo: ".$filename."\r\n\t\t\t\t";
            $mensaje .= "L�nea Nro.: ".$lineno."\r\n\t\t\t\t";
            $mensaje .= "Error: ".$message;
            fwrite($_SESSION['logfile'] , "".date("d/m/Y H:i:s")." -\t".$mensaje."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo $mensaje, PHP_EOL;
        }
    }

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                      Actualiza Tabla Tb_job_Filtros                                                                                                                              */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    

    function JobSaveDataFiltros(){
        $fecha = date('Y-m-d');  // Formato: AAAA-MM-DD
        $hora = date('H:i:s'); 
        try {

            $tsql = "WITH ProjectedStock AS (
                SELECT
                    itm.ItemCode AS ItemCode,
                    itm.ITEMNAME AS ITEMNAME,
                    SUM(DISTINCT whs.OnHand) AS StockBodegasActivas,
                    COALESCE(
                        SUM(
                            DISTINCT wor.PlannedQty - wor.CmpltQty
                        ),
                        0
                    ) AS PENDIENTE,
                  
                    COALESCE(SUM(DISTINCT CASE WHEN wor.Status = 'P' THEN wor.PlannedQty  ELSE 0 END),0) AS Planificado,
                    
                    COALESCE(CASE WHEN wor.Status = 'R' THEN  COALESCE(SUM(DISTINCT wor.PlannedQty - wor.CmpltQty), 0)  ELSE 0 END, 0) AS StockEnOf,
                     
                    COALESCE(SUM(DISTINCT CASE WHEN wor.Status = 'R' THEN wor.PlannedQty  ELSE 0 END),0) AS Liberado,
                    
                    wor.PlannedQty,
                    wor.CmpltQty,
            
                    COALESCE(
                        AVG(
                            DISTINCT CASE WHEN manual.BufferVTA = 0 THEN vta.BufferVTA ELSE manual.BufferVTA END
                        ),
                        0.1
                    ) AS BUFFER
                FROM
                    OITM itm
                    LEFT JOIN BufferVTA vta ON vta.ItemCode = itm.ItemCode
                    LEFT JOIN OITW whs ON whs.ItemCode = itm.ItemCode
                    AND whs.WhsCode IN ('1', '97')
                    LEFT JOIN OWOR wor ON wor.ItemCode = itm.ItemCode
                    AND wor.Status IN ('P', 'R')
                    LEFT JOIN BufferVTA_Manual manual ON itm.ItemCode = manual.ItemCode
                WHERE
                    itm.ValidFor = 'Y'
                    AND itm.U_NIVEL1 in ('100','170')
                    AND (
                        itm.U_BAJA IS NULL
                        OR itm.U_BAJA = 'N'
                    )
                GROUP BY
                    itm.ItemCode,
                    itm.ITEMNAME,
                    wor.PlannedQty,
                    wor.CmpltQty,
                    wor.Status 
            )
            
            SELECT
                ItemCode as ItemCode,
                ITEMNAME as ItemName,
                AVG(BUFFER) AS [Buffer],
                StockBodegasActivas StockBodegasActivas,
                SUM(StockEnOf) AS StockEnOf,
                (StockBodegasActivas)+SUM(StockEnOf) AS StockProyectado,
                SUM(Planificado) AS OfPlanificada,
                SUM(Liberado) AS OfLiberada,
                SUM(CmpltQty) AS OfCompletada,
                SUM(PENDIENTE) AS OfPendiente
            FROM
                ProjectedStock
            GROUP BY
                ItemCode,
                ItemName,
                StockBodegasActivas
            Order by ItemCode asc;";//AND itm.U_NIVEL1 in ('100','170')
          
            $params = array();
            $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
            $stmt1 = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options );
            $count=0;
            $fecha = date("Y-m-d"); // Obtener la fecha actual en formato yyyy-mm-dd
            $hora = date("H:i:s");  // Obtener la hora actual en formato hh:mm:ss

            // Consulta preparada
            $deleteQuery = "DELETE FROM tb_job_filtros WHERE fecha = ?";
            $statement = $GLOBALS['ConnIntra']->prepare($deleteQuery);

            // Vincular parámetro
            $statement->bind_param("s", $fecha);

            // Ejecutar la consulta
            $deleteResult = $statement->execute();

            // Verificar el resultado
            if ($deleteResult) {
                echo "La eliminación se realizó correctamente.";
            } else {
                echo "Error al intentar eliminar: " . $GLOBALS['ConnIntra']->error;
            }
            while ($fila = sqlsrv_fetch_array( $stmt1, SQLSRV_FETCH_ASSOC)){

                
                $busca = "SELECT *, (CEIL(((ciclo_produccion * factor_fab) * " . $fila['Buffer'] . ") / und_redondeo) * und_redondeo) AS UnidadesRecomendadas, ((( " . $fila['StockProyectado'] . " / " . $fila['Buffer'] . " ) - punto_activacion )* 21) as DiasActivacion, now() FROM tb_plan_parametros WHERE itemcode = '" . $fila['ItemCode']."'";
                echo "\nBUSCA :".$busca;
                try {
                    $b1 = $GLOBALS['ConnIntra']->query($busca);

                    if (!$b1) {
                        throw new Exception("Error en la consulta SELECT: " . $GLOBALS['ConnIntra']->error);
                    }

                    fwrite($_SESSION['logfile'], "$busca\r\n") or die("Error escribiendo en el archivo\r\n");

                    while ($rowb1 = $b1->fetch_assoc()) {
                        $count++;
                        
                        $upd = 'INSERT INTO tb_job_filtros (ItemCode, ItemName, StockBodegasActivas, Pendiente, StockEnOf, StockProyectado, OfPlanificada, Ofliberada, OfCompletada, OfPendiente, Buffer, und_redondeo, prod_minima, buffer_manual, stock_max, punto_activacion, ciclo_produccion, factor_fab, mult_ciclos, comentarios, UnidadesRecomendadas, DiasActivacion, fecha, hora) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
                        $stmt = $GLOBALS['ConnIntra']->prepare($upd);
                        if ($stmt) {
                            $stmt->bind_param("ssssssssssssssssssssssss", 
                                            $fila["ItemCode"], 
                                            $fila["ItemName"], 
                                            $fila["StockBodegasActiva"], 
                                            $fila["Pendiente"], 
                                            $fila["StockEnOf"],
                                            $fila["StockProyectado"], 
                                            $fila["OfPlanificada"], 
                                            $fila["OfLiberada"], 
                                            $fila["OfCompletada"], 
                                            $fila["OfPendiente"], 
                                            $fila["Buffer"], 
                                            $rowb1["und_redondeo"], 
                                            $rowb1["prod_minima"], 
                                            $rowb1["buffer_manual"], 
                                            $rowb1["stock_max"], 
                                            $rowb1["punto_activacion"], 
                                            $rowb1["ciclo_produccion"], 
                                            $rowb1["factor_fab"], 
                                            $rowb1["mult_ciclos"], 
                                            $rowb1["comentarios"], 
                                            $rowb1["UnidadesRecomendadas"], 
                                            $rowb1["DiasActivacion"], 
                                            $fecha, 
                                            $hora);

                            $stmt->execute();

                            if ($stmt->affected_rows > 0) {
                                echo "\n Inserción exitosa";
                            } else {
                                echo "Error en la inserción: " . $stmt->error;
                            }

                            $stmt->close();
                        } else {
                            echo "Error en la preparación de la consulta: " . $GLOBALS['ConnIntra']->error;
                        }
                      
                    }
                    
                } catch (Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                

            }
            echo 'Filtros : ' . $count, PHP_EOL;
            
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tTabla Parametros realizada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
        }catch (Exception $e) {
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError Actualziando Tabla Parametros\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo 'Datos de Filtros = false', PHP_EOL;
        }
    }
    function JobSaveStockDiario(){
        
        try {

            $tsql = "SELECT itemcode,WhsCode,OnHand FROM OITW T0 WHERE  T0.[OnHand] > 0";
          
            $params = array();
            $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
            $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options );
            $count=0;
            $fecha = date("Y-m-d"); // Obtener la fecha actual en formato yyyy-mm-dd
            $hora = date("H:i:s");  // Obtener la hora actual en formato hh:mm:ss

            // Consulta preparada
            $deleteQuery = "DELETE FROM tb_job_stockDiario WHERE fecha = ?";
            $statement = $GLOBALS['ConnIntra']->prepare($deleteQuery);

            // Vincular parámetro
            $statement->bind_param("s", $fecha);

            // Ejecutar la consulta
            $deleteResult = $statement->execute();

            // Verificar el resultado
            if ($deleteResult) {
                echo "La eliminación se realizó correctamente.";
            } else {
                echo "Error al intentar eliminar: " . $GLOBALS['ConnIntra']->error;
            }
            while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
                $count++;
                $upd = "INSERT INTO tb_job_stockDiario (itemcode, WhsCode, OnHand, fecha, hora)
                VALUES
                    ('".$fila['itemcode']."', '".$fila['WhsCode']."', '".$fila['OnHand']."', '$fecha', '$hora')";
                $result = $GLOBALS['ConnIntra']->query($upd);

                if (!$result) {
                    throw new Exception("Error en la consulta INSERT: " . $GLOBALS['ConnIntra']->error);
                }
            }
            echo 'Registros : ' . $count, PHP_EOL;
            
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tTabla Parametros realizada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
        }catch (Exception $e) {
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError Actualziando Tabla Parametros\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo 'Datos de Parametros = false', PHP_EOL;
        }
    }
    function JobSaveRecetas(){
        
        try {

            $tsql = "SELECT T0.[Code] AS Padre, T1.[Code] As Componente, (T1.[Quantity]/T0.[Qauntity]) As Consumo
            FROM OITT T0  INNER JOIN ITT1 T1 ON T0.[Code] = T1.[Father] INNER JOIN OITM T2 ON T2.ItemCode = T1.Code
            WHERE T2.[InvntItem] = 'Y'";
          
            $params = array();
            $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
            $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options );
            $count=0;
            $fecha = date("Y-m-d"); // Obtener la fecha actual en formato yyyy-mm-dd
            

            // Consulta preparada
            $deleteQuery = "DELETE FROM tb_job_recetas";
            $statement = $GLOBALS['ConnIntra']->prepare($deleteQuery);

            // Ejecutar la consulta
            $deleteResult = $statement->execute();

            // Verificar el resultado
            if ($deleteResult) {
                echo "La eliminación se realizó correctamente.";
            } else {
                echo "Error al intentar eliminar: " . $GLOBALS['ConnIntra']->error;
            }
            while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
                $count++;
                $upd = "INSERT INTO tb_job_recetas (Padre, Componente, Consumo) VALUES ('".$fila['Padre']."', '".$fila['Componente']."', ".$fila['Consumo'].")";
                
                $result = $GLOBALS['ConnIntra']->query($upd);

                if (!$result) {
                    throw new Exception("Error en la consulta INSERT: " . $GLOBALS['ConnIntra']->error);
                }
            }
            echo 'Recetas  : ' . $count, PHP_EOL;
            
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tTabla Parametros realizada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
        }catch (Exception $e) {
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError Actualziando Tabla Parametros\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo 'Datos de Recetas = false', PHP_EOL;
        }
    }
    ?>