<?php

function calcind1(){
  $tsql = "SELECT [SlpCode],[SlpName],[cumplimiento],[cobranza],[deudaatrasada],[CLIENTES12MESEeS],[CLIENTES33MESEeS]
        ,[CLIENTESNUEVOS],[cumpAmalie] FROM [BaseModelo].[dbo].[JR_Indicators]";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function calcind2(){
  $tsql = "SELECT diaprod, seg1, seg2 FROM JR_Cumplimiento WHERE diaprod = dbo.TraeDiasProductivosMes_New()";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_calcven(){
  $tsql ="SELECT T0.VentaDiaria FROM Vista_VentaDiaria T0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function ent_x_fact(){
  $tsql ="SELECT SUM(A0.NETO)[NETO] FROM (SELECT DISTINCT (T0.DocTotal - T0.VatSum)[NETO] FROM ODLN T0
    INNER JOIN DLN1 T1 ON T0.DocEntry = T1.DocEntry WHERE T1.BaseType = 17 AND T0.DocStatus = 'O') A0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function pedconstock(){
  $tsql ="SELECT SUM((T0.DocRate * T1.Price) * T1.OpenCreQty)[TPendiente]	FROM ORDR T0
    INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
    WHERE T1.LineStatus = 'O' AND T0.DocStatus = 'O' AND T0.Confirmed = 'Y' AND T0.CANCELED = 'N'
    AND T2.OnHand > 0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function pedsinstock(){
  $tsql ="SELECT SUM((T0.DocRate * T1.Price) * T1.OpenCreQty)[TStock0]FROM ORDR T0
    INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode
    AND T2.WhsCode = '1' WHERE T1.LineStatus = 'O' AND T0.DocStatus = 'O' AND T0.Confirmed = 'Y'
    AND T0.CANCELED = 'N' AND T2.OnHand = 0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function pedsinauto(){
  $tsql ="SELECT SUM(T0.DocTotal - T0.VatSum) AS Neto FROM ORDR AS T0
  WHERE (T0.DocStatus = 'O') AND (T0.CANCELED = 'N') AND (T0.Confirmed = 'N')";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function pedcreahoy(){
  $tsql ="SELECT T0.SlpCode
      , T0.SlpName
      , (SELECT TOP 1 CASE WHEN LEN(R0.DocTime) = 3 THEN CONCAT('  ',LEFT(R0.DocTime,1),':',RIGHT(R0.DocTime,2)) ELSE CONCAT(LEFT(R0.DocTime,2),':',RIGHT(R0.DocTime,2)) END
        FROM ORDR R0
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.DocManClsd = 'N'
        ORDER BY R0.DocEntry ASC)[1_NV_DIA]
      , (SELECT TOP 1 CASE WHEN LEN(R0.DocTime) = 3 THEN CONCAT(LEFT(R0.DocTime,1),':',RIGHT(R0.DocTime,2)) ELSE CONCAT(LEFT(R0.DocTime,2),':',RIGHT(R0.DocTime,2)) END
        FROM ORDR R0
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.DocManClsd = 'N'
        ORDER BY R0.DocEntry DESC)[ult_NV_DIA]
      , (SELECT COUNT(DISTINCT R0.CardCode)
        FROM ORDR R0
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.UserSign = 1)[CANT_NV_VEND]
      , (SELECT L0.CantNVVendedorMes
        FROM JR_CANTNVVEND_MES L0
        WHERE L0.SlpCode = T0.SlpCode)[CANT_NV_VEND_MES]
      , (SELECT COUNT(R0.DocEntry)
        FROM ORDR R0
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE())  AND R0.UserSign IN (42, 43, 117, 38, 90, 65, 141, 140))[CANT_NV_OFI]
      ,(SELECT SUM((((R0.DocTotal - R0.VatSum) + R0.DiscSum) + CASE WHEN R0.RoundDif < 0 THEN ABS(R0.RoundDif) ELSE -R0.RoundDif END - R0.DiscSum) * CASE WHEN R0.CANCELED = 'C' THEN -1 ELSE 1 END)
        FROM ORDR R0
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.DocManClsd = 'N' AND R0.CANCELED = 'N' )[TOTAL_NETO],
        (SELECT K0.FacturacionMensual FROM [JR_VendorsIndicators] K0 WHERE K0.SlpCode = T0.SlpCode) [FACTMENSUAL],
        (SELECT E0.FacturacionMensualLub FROM [JR_VendorsIndicators] E0 WHERE E0.SlpCode = T0.SlpCode) [FACTMENSUALLUB],
        (SELECT E0.FacturacionMensualFil FROM [JR_VendorsIndicators] E0 WHERE E0.SlpCode = T0.SlpCode) [FACTMENSUALFIL],
        (SELECT COUNT(DISTINCT R0.CardCode)	FROM ORDR R0 WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.UserSign IN (1) AND ISNULL(R0.U_BOC_Correlativo,'')<>'')[CANT_CLI_VEND],
        (SELECT ISNULL(STUFF((SELECT ', '  + R1.U_NAME FROM ORDR R0	INNER JOIN OUSR R1 ON R0.UserSign = R1.USERID
        WHERE R0.SlpCode = T0.SlpCode AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.UserSign IN (42, 43, 117, 38, 90, 65, 141, 140)
        FOR XML PATH('')),1, 2, ''),'') As VendOficina)[VendOficina] FROM OSLP T0 WHERE T0.Active = 'Y' AND T0.Locked = 'N' AND T0.SlpCode NOT IN (21, 93, 94, 100, 101,25)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function entxfact(){
  $tsql = "SELECT A0.Fecha, A0.CardCode, A0.CardName, A0.Neto, A0.SlpName, A0.DocNum, A0.BaseRef
    FROM (SELECT DISTINCT CONVERT(DATE,T0.DocDate,105)[Fecha], T0.CardCode,
    T0.CardName, (T0.DocTotal - T0.VatSum)[Neto], T2.SlpName, T0.DocNum, T1.BaseRef
    FROM ODLN T0 INNER JOIN DLN1 T1 ON T0.DocEntry = T1.DocEntry INNER JOIN OSLP T2 ON T0.SlpCode = T2.SlpCode
    WHERE T1.BaseType = 17 AND T0.DocStatus = 'O') A0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function pedidosnoauto(){
  $tsql = "SELECT   T0.DocNum, T0.CardCode, left(T1.CardName,30) AS CardName, CONVERT(DATE, T0.DocDate, 103)
                           AS [Fecha], T2.SlpName
               , convert(int, round((T0.DocTotal - T0.VatSum),0)) [Neto]
               , convert(int, round((T0.VatSum),0)) [VatSum]
               , convert(int, round((T0.DocTotal),0))[DocTotal]
               , CASE T0.U_EstadoNV WHEN 'Procesado' THEN 'Autorizada' WHEN 'No_Procesado' THEN 'Pendiente Autorizacion' WHEN 'Morosidad' THEN 'Cliente Moroso' WHEN 'Morosidad_LC' THEN 'Moroso/Credito' WHEN
                            'Linea_Credito' THEN 'Excede Linea Credito' WHEN 'Procesado_N' THEN 'No Autorizado' WHEN 'Condicion' THEN 'Condicion de Pago' WHEN 'Otras' THEN 'Otras Causas' WHEN 'PC-1' THEN 'Procesado C-1' WHEN
                            'MEC-1' THEN 'Morosidad Elevada C-1' WHEN 'PC-2' THEN 'Procesado C-2' WHEN 'PC-3' THEN 'Procesado C-3' WHEN 'PC-4' THEN 'Procesado C-4' WHEN 'PC-5' THEN 'Procesado C-5' WHEN 'MEC-5' THEN 'Morosidad Elevada C-5'
                            WHEN 'PC-6' THEN 'Procesado C-6' WHEN 'PC-7' THEN 'Procesado C-7' WHEN 'PC-8' THEN 'Procesado C-8' WHEN 'PC-9' THEN 'Procesado C-9' WHEN 'MESCC-9' THEN 'Morosidad Elevada/Sin Credito C-9' WHEN
                            'PC-10' THEN 'Procesado C-10' WHEN 'MSCC-10' THEN 'Morosidad /Sin Credito C-10' WHEN 'PC-11' THEN 'Procesado C-11' WHEN 'SCC-11' THEN 'Sin Credito C-11' WHEN 'PC-12' THEN 'Procesado C-12' WHEN 'SCC-12'
                            THEN 'Sin Credito C-12' WHEN 'JRIV02NC' THEN 'JRIV02 No Corresponde' WHEN 'Protestos' THEN 'Protestos' WHEN 'JRIV03NC' THEN 'JRIV03 No Corresponde' ELSE 'Otras Causas' END AS [EstadoPedido]
              , T3.PymntGroup
  FROM  ORDR AS T0
      INNER JOIN OCRD AS T1 ON T0.CardCode = T1.CardCode
      INNER JOIN OSLP AS T2 ON T0.SlpCode = T2.SlpCode
      INNER JOIN OCTG AS T3 ON T0.GroupNum = T3.GroupNum
  WHERE        (T0.DocStatus = 'O') AND (T0.CANCELED = 'N') AND (T0.Confirmed = 'N')
  ORDER BY T2.SlpName, T0.DocDate";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function ped_con_stock(){
  $tsql = "SELECT t0.DocNum, convert(varchar, t0.DocDate, 103)[Fecha], t0.CardCode,
  left(t0.CardName,30)[CardName], t1.ItemCode, t1.Dscription, convert(int, t1.Quantity)[Quantity],
  convert(int, t1.OpenCreQty)[OpenCreQty], FORMAT(round(t1.Price * t0.DocRate,0),'C','es-Us') [Price],
  CONVERT(INT,t2.OnHand)[OnHand], convert(int, round((t1.Price * t0.DocRate) * T1.OpenCreQty,0))[TStock0]
  FROM ORDR T0
    INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
  WHERE T1.LineStatus = 'O'
    AND T0.DocStatus = 'O'
    AND T0.Confirmed = 'Y'
    AND T0.CANCELED = 'N'
    AND T2.OnHand > 0
  ORDER BY T0.CardCode";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function cant_ped_picking(){
  $tsql = "SELECT DISTINCT T0.DocNum FROM ORDR T0 INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
    WHERE T1.LineStatus = 'O'	AND T0.DocStatus = 'O' AND T0.Confirmed = 'Y'
    AND T0.CANCELED = 'N'	AND T2.OnHand > 0 GROUP BY T0.DocNum";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function ped_sin_picking(){
  $tsql = "SELECT T0.U_VK_StatusDoc, CASE WHEN T0.U_VK_StatusDoc IN (1,2,3) THEN SUM((T0.DocRate * T1.Price) * T1.OpenCreQty) END [TOTAL]
    FROM ORDR T0 INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
    WHERE T1.LineStatus = 'O'	AND T0.DocStatus = 'O' 	AND T0.Confirmed = 'Y' AND T0.CANCELED = 'N'
    AND T2.OnHand > 0 GROUP BY T0.U_VK_StatusDoc";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function cant_ped(){
  $tsql = "SELECT T0.U_VK_StatusDoc, CASE WHEN T0.U_VK_StatusDoc IN (1,2,3) THEN COUNT(DISTINCT T0.DocNum) END [TOTAL]
  FROM ORDR T0
    INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
  WHERE T1.LineStatus = 'O'
    AND T0.DocStatus = 'O'
    AND T0.Confirmed = 'Y'
    AND T0.CANCELED = 'N'
    AND T2.OnHand > 0
  GROUP BY T0.U_VK_StatusDoc";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function ped_sin_stock(){
  $tsql = "SELECT t0.DocNum, convert(varchar, t0.DocDate, 103)[Fecha], t0.CardCode,
    left(t0.CardName,30)[CardName], t1.ItemCode, t1.Dscription, convert(int, t1.Quantity)[Quantity],
    convert(int, t1.OpenCreQty)[OpenCreQty], FORMAT(round(t1.Price * t0.DocRate,0),'C','es-Us') [Price],
    CONVERT(INT,t2.OnHand)[OnHand], convert(int, round((t1.Price * t0.DocRate) * T1.OpenCreQty,0))[TStock0]
    FROM ORDR T0
      INNER JOIN RDR1 T1 ON T0.DocEntry = T1.DocEntry
      INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
    WHERE T1.LineStatus = 'O'
      AND T0.DocStatus = 'O'
      AND T0.Confirmed = 'Y'
      AND T0.CANCELED = 'N'
      AND T2.OnHand = 0
    ORDER BY T0.CardCode";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_listvendorcode(){
  $tsql = "SELECT T0.SlpCode, T0.SlpName FROM OSLP T0
            WHERE T0.Active = 'Y' AND T0.Locked = 'N' AND T0.SlpCode NOT IN (21,93,94,100,101,25,91)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_geotab($cod){
  $qry1 = "SELECT vendedor, latitud, longitud, fecha, hora, info
    FROM geolocalizacion WHERE vendedor = $cod ORDER BY fecha desc, hora desc LIMIT 10 ";
    $res1 = $GLOBALS['connmy']->query($qry1);
    return $res1;
}

function fn_findvendor($cod){
  $qry1 = "SELECT T0.IdUser, T0.Code, T0.Name, T0.Email, T0.SlpCode FROM vendors AS T0 WHERE T0.SlpCode =  '$cod'";
  $res1 = $GLOBALS['connmy']->query($qry1);
  return $res1;
}

function fn_getListaClientesAtendidos($de){
	if($de == 912){
		$tsql = "SELECT T0.DocEntry, T0.DocNum, T0.DocTime, T0.CardName, (T0.DocTotal/1.19) [DocTotal], T0.CreadoPor, T0.Status
FROM (
SELECT R0.DocEntry, R0.DocNum, R0.DocTime, R0.CardName, R0.DocTotal, 'Vendedor'[CreadoPor], (CASE WHEN R0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END) [Status]
FROM ORDR R0
WHERE R0.SlpCode = $de AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.UserSign IN (1) AND ISNULL(R0.U_BOC_Correlativo,'')<>'' --AND R0.DocManClsd = 'N'

UNION ALL

SELECT R0.DocEntry, R0.DocNum, R0.DocTime, R0.CardName, R0.DocTotal, 'Oficina', (CASE WHEN R0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END) [Status]
FROM ORDR R0
WHERE R0.SlpCode = $de AND R0.DocDate = CONVERT(date, GETDATE()) AND ISNULL(R0.U_BOC_Correlativo,'')='' AND R0.DocManClsd = 'N'
) AS T0";

	}else{

		$tsql = "SELECT T0.DocEntry, T0.DocNum, T0.DocTime, T0.CardName, (T0.DocTotal/1.19) [DocTotal], T0.CreadoPor, T0.Status
FROM (
SELECT R0.DocEntry, R0.DocNum, R0.DocTime, R0.CardName, R0.DocTotal, 'Vendedor'[CreadoPor], (CASE WHEN R0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END) [Status]
FROM ORDR R0
WHERE R0.SlpCode = $de AND R0.DocDate = CONVERT(date, GETDATE()) AND R0.UserSign IN (1) AND ISNULL(R0.U_BOC_Correlativo,'')<>'' and R0.docnum not in (612500, 612506) --AND R0.DocManClsd = 'N'

UNION ALL

SELECT R0.DocEntry, R0.DocNum, R0.DocTime, R0.CardName, R0.DocTotal, R1.U_NAME, (CASE WHEN R0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END) [Status]
FROM ORDR R0
	INNER JOIN OUSR R1 ON R0.UserSign = R1.INTERNAL_K
WHERE R0.SlpCode = $de AND R0.DocDate = CONVERT(date, GETDATE()) AND ISNULL(R0.U_BOC_Correlativo,'')='' AND R0.DocManClsd = 'N' AND R0.UserSign <> 1 and R0.docnum not in (612500, 612506)
) AS T0";
	}
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	return $stmt;
}

function fn_getCabeceraListaClientesAtendidos($de){
	$tsql = "SELECT T0.DocEntry, T0.DocNum, T0.NumAtCard, T0.LicTradNum, CONVERT(DATE, T0.DocDate, 103)[Fecha], T0.DocTime, T3.SlpName, T0.CardName, T0.DocTotal, T1.Descr[Picking], T2.Descr, T4.PymntGroup, (CASE WHEN T0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END) AS Status, T0.DocTotal
		FROM ORDR T0
		INNER JOIN UFD1 T1 ON T0.U_VK_StatusDoc = T1.FldValue AND T1.TableID = 'ORDR' AND T1.FieldID = 85
		INNER JOIN UFD1 T2 ON T0.U_EstadoNV		= T2.FldValue AND T2.TableID = 'ORDR' AND T2.FieldID = 76
		INNER JOIN OSLP T3 ON T0.SlpCode		= T3.SlpCode
		INNER JOIN OCTG T4 ON T0.GroupNum		= T4.GroupNum
		WHERE T0.DocEntry =".$de;
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getDetalleListaClientesAtendidos($de){
	$tsql = "SELECT T1.ItemCode, T1.Dscription, T1.Quantity, T1.PriceBefDi, T1.LineTotal, T1.LineStatus, T1.OpenCreQty, T2.OnHand
								FROM ORDR T0
									INNER JOIN RDR1 T1 ON T1.DocEntry = T0.DocEntry
									INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
								WHERE     T0.DocEntry = $de";

	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getSeguimientoOrdenVentas($de){
	$GLOBALS['conn'] = Connect();
	$tsql = "SELECT 'Orden de Venta'[Tipo Documento], T0.DocNum, T0.DocDate[Fecha], T0.DocTime [Hora], T1.Descr [Estado]
		FROM ORDR T0 LEFT JOIN UFD1 T1 ON T0.U_EstadoNV = T1.FldValue AND T1.TableID = 'ORDR' AND T1.FieldID = 76 WHERE T0.DocNum = $de";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getSeguimientoPicking($de){
	$GLOBALS['conn'] = Connect();
	$tsql = "SELECT DISTINCT 'Picking'[Tipo Documento], T0.AbsEntry [DocNum], T0.PickDate [Fecha], '' [Hora],
		'ORDEN EN PREPARACION' [Estado] FROM OPKL AS T0 INNER JOIN PKL1 T1 ON T0.AbsEntry = T1.AbsEntry WHERE T1.OrderEntry = $de";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getSeguimientoGuiaDespacho($de){
	$GLOBALS['conn'] = Connect();
	$tsql = "SELECT DISTINCT 'Guia de Despacho' [Tipo Documento], ISNULL(T0.FolioNum,0) [DocNum], T1.DocDate [Fecha],
			T0.DocTime [Hora], 'POR FACTURAR' [Estado] FROM ODLN T0 INNER JOIN RDR1 T1 ON T0.DocEntry = T1.TrgetEntry
		WHERE (T1.DocEntry = $de) ";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getSeguimientoFacturaVenta($de){
	$GLOBALS['conn'] = Connect();
	$tsql = "SELECT 'Factura de Venta'[Tipo Documento], T2.FolioNum [DocNum], T2.DocDate [Fecha], T2.DocTime [Hora],
		CASE WHEN T2.U_INV_Enviada = 'S' THEN 'IMPRESO' ELSE 'NO IMPRESO' END [Estado] FROM DLN1 T1
		INNER JOIN OINV T2 ON T1.TrgetEntry = T2.DocEntry WHERE (T1.BaseEntry  = $de)
		GROUP BY  T2.FolioNum, T2.DocDate, T2.DocTime, T2.U_INV_Enviada";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getSeguimientoHojaRuta($de){
	$GLOBALS['conn'] = Connect();
	$tsql = "SELECT DISTINCT 'Hoja de Ruta' [Tipo Documento], T0.DocEntry [DocNum], T1.CreateDate [Fecha], T1.CreateTime [Hora],
			T4.Name [Estado] FROM [@INV_0013_HR_D] AS T0 INNER JOIN [@INV_0013_HR_H] AS T1 ON T0.DocEntry = T1.DocEntry
		  INNER JOIN OINV AS T3 ON T0.U_DocNum = T3.DocNum INNER JOIN [@INV_0013_TRANSP] AS T4 ON T3.U_Codigo = T4.Code
			INNER JOIN DLN1 T5 ON T3.DocEntry  = T5.TrgetEntry INNER JOIN ORDR T6 ON T5.BaseEntry  = T6.DocNum	WHERE T6.DocNum = $de";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getRankingMetaAmalie(){
	$tsql4 = "SELECT [Codigo],[Vendedor],[Meta],[Vendido],[Porj] FROM [BaseModelo].[dbo].[JR_MetaAmalie]";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt4 = sqlsrv_query($GLOBALS['conn'], $tsql4 , $params, $options );
	return $stmt4;
}

function fn_getNotasVentaHoy(){
	$tsql = "SELECT T0.DocEntry, T0.DocNum, T0.LICTRADNUM, CONVERT(DATE, T0.DocDate, 103)[Fecha], T0.DocTime, T3.SlpName, T0.CardName,
			(T0.DocTotal / 1.19)[DocTotal], T1.Descr[Picking], T2.Descr, (CASE WHEN T0.DocStatus = 'C' THEN 'Cerrada' ELSE 'Abierta' END)
			AS Status
		FROM ORDR T0
			INNER JOIN UFD1 T1 ON T0.U_VK_StatusDoc = T1.FldValue AND T1.TableID = 'ORDR' AND T1.FieldID = 85
			INNER JOIN UFD1 T2 ON T0.U_EstadoNV		= T2.FldValue AND T2.TableID = 'ORDR' AND T2.FieldID = 76
			INNER JOIN OSLP T3 ON T0.SlpCode		= T3.SlpCode
		WHERE T0.DocDate = CONVERT(date, GETDATE()) AND T0.SlpCode = ".$_SESSION['SlpCode']." AND T0.DocManClsd = 'N'
			AND T0.CANCELED = 'N'
		ORDER BY T0.DocEntry ASC";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_getTusMetas(){
	$tsql2 = "SELECT T0.Code, T0.U_META[Meta], dbo.CantAMALIVendidoXVendedorAlMes(T0.Code, year(getdate()), month(getdate()))[VarAlDiaAmalie]
		FROM [@COMIS] T0 WHERE T0.Code = ".$_SESSION['SlpCode'];
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt2 = sqlsrv_query($GLOBALS['conn'], $tsql2 , $params, $options );
	return $stmt2;
}

function fn_getListaMetas(){
	$tsql5 = "SELECT A0.TipoDoc, A0.ItemCode, A0.Dscription, A0.Quantity, A0.FolioNum, A0.CardCode, A0.CardName, A0.DocDate
		FROM (
			SELECT 'FV'[TipoDoc], T4.ItemCode, T4.Dscription, T4.Quantity, T0.FolioNum, T0.CardCode, T0.CardName, T0.DocDate -- FACTURADO
			FROM OINV AS T0 INNER JOIN
				INV1 AS T4 ON T4.DocEntry = T0.DocEntry INNER JOIN
				OITM AS T5 ON T4.ItemCode = T5.ItemCode INNER JOIN
				OSLP AS T6 ON  T0.SlpCode =  T6.SlpCode
			WHERE	(T6.SlpCode = ".$_SESSION['SlpCode']." -- VENDEDOR
				AND (YEAR(T0.DocDate) = YEAR(GETDATE())) -- A�O
				AND (MONTH(T0.DocDate) = MONTH(GETDATE())) -- MES
				AND (T0.DocType = 'I')
				AND (T0.CANCELED = 'N')
				AND (T0.DocSubType IN ('--', 'IE'))
				AND (T5.U_Nivel1 = 300) -- Accesorios
				AND (T5.U_Nivel2 = 98)  -- Lubricantes
				AND (T5.U_Nivel3 = 30)) -- AMALIE
		UNION ALL
		SELECT 'NC', T4.ItemCode, T4.Dscription, T4.Quantity, T0.FolioNum, T0.CardCode, T0.CardName, T0.DocDate  -- MENOS NOTA DE CREDITO
		FROM ORIN AS T0 INNER JOIN
			RIN1 AS T4 ON T4.DocEntry = T0.DocEntry INNER JOIN
			OITM AS T5 ON T4.ItemCode = T5.ItemCode INNER JOIN
			OSLP AS T6 ON  T0.SlpCode =  T6.SlpCode
		WHERE	(T6.SlpCode = ".$_SESSION['SlpCode']." -- VENDEDOR
			AND (YEAR(T0.DocDate) = YEAR(GETDATE())) -- A�O
			AND (MONTH(T0.DocDate) = MONTH(GETDATE())) -- MES
			AND (T0.DocType = 'I')
			AND (T0.CANCELED = 'N')
			AND (T0.DocSubType IN ('--', 'IE'))
			AND (T5.U_Nivel1 = 300) -- Accesorios
			AND (T5.U_Nivel2 = 98)  -- Lubricantes
			AND (T5.U_Nivel3 = 30)) -- AMALIE
	) A0";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt5 = sqlsrv_query($GLOBALS['conn'], $tsql5 , $params, $options );
	return $stmt5;
}

function fn_getRankingCumplimiento(){
	$tsql3 = "SELECT a0.Codigo, a0.Vendedor, a0.Meta, a0.Vendido,
			ROUND(CAST((CAST(a0.Vendido AS decimal(6,3)) / CAST(a0.Meta AS decimal(6,3))) AS DECIMAL(6,3)),2)*100 [Porj]
		FROM (
			SELECT T0.SlpCode[Codigo], T0.SlpName[Vendedor], T1.U_META[Meta], dbo.CantAMALIVendidoXVendedorAlMes(T0.SlpCode, year(getdate()), month(getdate()))[Vendido]
			FROM OSLP T0 INNER JOIN [@COMIS] T1 ON T1.Code = T0.SlpCode WHERE T0.Active = 'Y' ";
	if($_SESSION['SlpCode'] == '1' ||
		 $_SESSION['SlpCode'] == '2' ||
		 $_SESSION['SlpCode'] == '3' ||
		 $_SESSION['SlpCode'] == '6' ||
		 $_SESSION['SlpCode'] == '7' ||
		 $_SESSION['SlpCode'] == '8' ||
		 $_SESSION['SlpCode'] == '9' ){
		$tsql3.=" AND T0.SlpCode IN (1, 2, 3, 6, 7, 8, 9) ";
	}	else {
		$tsql3.=" AND T0.SlpCode IN (4, 10, 11, 12, 13, 14, 15, 16, 18, 19, 22, 30, 38, 40, 49, 50, 51) ";
	}
	$tsql3.=" ) A0
		ORDER BY ROUND(CAST((CAST(a0.Vendido AS decimal(6,3)) / CAST(a0.Meta AS decimal(6,3))) AS DECIMAL(6,3)),2) DESC ";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt3 = sqlsrv_query($GLOBALS['conn'], $tsql3 , $params, $options );
	return $stmt3;
}

function fn_qry1(){
	$tsql = "SELECT T0.VtaEspMensual, T0.VtaPotM1, T0.VtaPotM2, T0.VtaPotM3, T0.TotalCerosXLinea30, T0.TotalCerosXLinea15
		FROM [JR_indicadores03_IMP] T0";
	$params = array();
	$options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql, $params, $options);
	return $stmt;
}

function fn_qry2($vtaMensual){
	$tsql = "SELECT T0.U_Descripcion2, T0.ItemStockCero, T0.CantItem, ROUND((T0.VtaEspMensual / $vtaMensual)*100,0)[Importancia],
		T0.Disponibilidad*100 Disponibilidad, ROUND((1-(T0.VtaPotM1 / (T0.VtaEspMensual * 1)))*100,0)[VtaMes1],
		ROUND((1-(T0.VtaPotM2 / (T0.VtaEspMensual * 2)))*100,0)[VtaMes2], ROUND((1-(T0.VtaPotM3 / (T0.VtaEspMensual * 3)))*100,0)[VtaMes3]
	FROM [JR_indicadores02_IMP] T0";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	return $stmt;
}

function fn_qry3($descripcion){
	$tsql = "SELECT ISNULL(STUFF((SELECT top 3 ', '  + T1.CodeBars FROM [JR_Indicadores01_IMP] T0
		INNER JOIN OITM T1 ON T0.ItemCode =	T1.ItemCode WHERE T0.U_Descripcion2 = '".$descripcion."' ORDER BY T0.VtaPotM1 DESC
		FOR XML PATH('')), 1, 2, ''),'') [res]";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	return $stmt;
}

function fn_qry4(){
	$tsql = "SELECT T0.VtaEspMensual, T0.VtaPotM1, T0.VtaPotM2, T0.VtaPotM3, T0.TotalCerosXLinea30, T0.TotalCerosXLinea15
		FROM [JR_indicadores03_OTROS] T0";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql, $params, $options);
	return $stmt;
}

function fn_qry5($vtaMensual){
	$tsql = "SELECT T0.U_Descripcion2, T0.ItemStockCero, T0.CantItem, ROUND((T0.VtaEspMensual / $vtaMensual)*100,0)[Importancia],
		T0.Disponibilidad*100 Disponibilidad, ROUND((1-(T0.VtaPotM1 / (T0.VtaEspMensual * 1)))*100,0)[VtaMes1],
		ROUND((1-(T0.VtaPotM2 / (T0.VtaEspMensual * 2)))*100,0)[VtaMes2], ROUND((1-(T0.VtaPotM3 / (T0.VtaEspMensual * 3)))*100,0)[VtaMes3]
		FROM [JR_indicadores02_OTROS] T0";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
	return $stmt;
}

function fn_qry6($descripcion){
	$tsql = "SELECT ISNULL(STUFF((SELECT top 3 ', '  + T1.CodeBars FROM [JR_Indicadores01_OTROS] T0
		INNER JOIN OITM T1 ON T0.ItemCode =	T1.ItemCode	WHERE T0.U_Descripcion2 = '".$descripcion."' ORDER BY T0.VtaPotM1 DESC
		FOR XML PATH('')), 1, 2, ''),'') [res]";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query( $GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_qry7($firmname){
	$tsql = "SELECT CASE WHEN T0.U_COR_CLOUD_IGNORE = 'N' THEN 'X' ELSE '' END [X], T0.ItemCode, T0.ItemName, T1.BufferVta,
		T0.FirmCode, T2.FirmName, (SELECT F0.OnHand	FROM OITW F0 WHERE F0.WhsCode = '1' AND F0.ItemCode = T0.ItemCode)[Stock],
		(SELECT ISNULL(SUM(H1.Quantity),0) FROM OPCH H0	INNER JOIN PCH1 H1 ON H0.DocEntry = H1.DocEntry
		WHERE H1.LineStatus = 'O' AND H1.TargetType = -1 AND H1.ItemCode = T0.ItemCode)[StockTransito],
		T0.OnOrder - (SELECT ISNULL(SUM(H1.Quantity),0)	FROM OPCH H0 INNER JOIN PCH1 H1 ON H0.DocEntry = H1.DocEntry
		WHERE H1.LineStatus = 'O' AND H1.TargetType = -1 AND H1.ItemCode = T0.ItemCode) [BO], T0.AvgPrice [Costo],
		CASE WHEN (SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode) = 0 THEN 0
			ELSE (((SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode) - T0.AvgPrice) /
			(SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode))*100 END [Margen]
		FROM OITM T0 LEFT JOIN BufferVTA T1 ON T0.ItemCode = T1.ItemCode INNER JOIN OMRC T2 ON T0.FirmCode = T2.FirmCode
		WHERE T0.SellItem = 'Y'	AND T0.validFor = 'Y'	AND T2.FirmName = '$firmname'";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query( $GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

function fn_qry8(){
	$tsql = "SELECT T0.ItemCode, T0.ItemName, T1.BufferVta, T0.FirmCode, T2.FirmName, T0.U_Descripcion2,
	(SELECT F0.OnHand	FROM OITW F0 WHERE F0.WhsCode = '1' AND F0.ItemCode = T0.ItemCode)[Stock],
	(SELECT L0.Num FROM [JR_PrioridadNAC] L0 WHERE L0.ItemCode = T0.ItemCode)[Prioridad],
	CASE WHEN (SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode) = 0 THEN 0 ELSE
		(((SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode) - T0.AvgPrice) /
		(SELECT D0.Price FROM ITM1 D0 WHERE D0.PriceList = 1 AND D0.ItemCode = T0.ItemCode))*100 END [Margen]
	FROM OITM T0 inner JOIN BufferVTA T1 ON T0.ItemCode = T1.ItemCode	INNER JOIN OMRC T2 ON T0.FirmCode = T2.FirmCode
	WHERE T0.SellItem = 'Y'	AND T0.U_COR_CLOUD_IGNORE = 'N'	AND T0.validFor = 'Y'
	AND T2.FirmName IN ('MHDE','MHKR','SURE FILTER','MHBR','YUIL','MHCN','MHAR','GUD','LUCAS','MHI')";
	$params = array();
	$options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
	$stmt = sqlsrv_query( $GLOBALS['conn'], $tsql , $params, $options );
	return $stmt;
}

?>
