<?php

function fn_plansindesp(){
  $tsql = "SELECT sum(T0.[PlannedQty])[PlanificadoS] FROM OFsSinStock T0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_plancondesp(){
  $tsql = "SELECT  SUM(T0.PlannedQty)[PlanificadoC]
  FROM OWOR T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  WHERE T0.DocNum NOT IN (SELECT G0.DOCNUM FROM OFsSinStock G0)
  	AND T0.Status = 'P' AND T1.U_Nivel1 IN ('100', '150', '200')";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_liberahoy(){
  $tsql = "SELECT SUM(T0.PlannedQty - T0.CmpltQty)[PlannedQty]
  FROM OWOR T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  WHERE T0.Status = 'R'
  	AND T0.PostDate > EOMONTH(getdate(),-36)
  	AND T1.U_Nivel1 IN (100, 150, 200, 250)
  	AND (T0.PlannedQty - T0.CmpltQty) > 0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_entregahoy(){
  $tsql = "SELECT SUM(T1.Quantity)[Quantity]
  FROM OIGN T0
  	INNER JOIN IGN1 T1 ON T0.DocEntry = T1.DocEntry
  	INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode
  WHERE 1 = 1
  	AND T1.BaseType = 202
  	AND CONVERT(DATE, T0.DocDate) = CONVERT(DATE, GETDATE())
  	AND T2.U_Nivel1 IN (100, 150, 200)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_prod30dias(){
  $tsql = "SELECT SUM(T0.Quantity)[cantidad]
  FROM JR_DetFabricacionDiaria T0
  WHERE CONVERT(DATE, T0.FechaEntrega) >=  CONVERT(DATE, DATEADD( MONTH,-1,GETDATE()))";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_sin_nombre(){
  $tsql = "SELECT TOP 1 D0.StartDate
  FROM OMSN D0
  ORDER BY AbsEntry DESC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_filtrobusca($itemcode){
  $tsql = "SELECT T0.ItemCode, T0.ItemName, T1.Num, CONVERT(INT, T2.OnHand)[OnHand], T0.U_Descripcion2
    FROM OITM T0
    INNER JOIN [JR_PrioridadNAC] T1 ON T0.ItemCode = T1.ItemCode
    INNER JOIN OITW T2 ON T1.ItemCode = T2.ItemCode AND T2.WhsCode = '1'
    WHERE T0.ItemCode = '$itemcode'";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detbuscado($itemcode){
  $tsql = "SELECT T0.DocNum, CONVERT(DATE,T0.PostDate)[PostDate]
,CASE
  WHEN T0.Status = 'P' THEN 'Planificado'
  WHEN T0.Status = 'R' THEN 'Liberado'
ELSE ''
END AS DocStatus
, CONVERT(INT,T0.PlannedQty)[PlannedQty], CONVERT(INT, T0.PlannedQty - T0.CmpltQty)[Pendiente]
, CASE WHEN T0.OriginType = 'M' THEN 'Manual' ELSE 'MRP' END [Origen]
, CONVERT(DATE,T0.RlsDate)[RlsDate]
FROM OWOR T0
WHERE T0.ItemCode = '$itemcode'
AND T0.Status IN ('P', 'R') AND CONVERT(DATE,T0.PostDate) >= '01-01-2019'
ORDER BY T0.DocNum ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_catgrafico(){
  $tsql = "SELECT convert(date,Expr1)Expr1, convert(int,cantidad)[cantidad] FROM JR_VW_FiltrosDiarios order by convert(date,Expr1)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_serie1grafico(){
  $tsql = "SELECT convert(date,Expr1)Expr1, convert(int,cantidad)[cantidad] FROM JR_VW_FiltrosDiarios order by convert(date,Expr1)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_serie2grafico(){
  $tsql = "SELECT convert(date,Expr1)Expr1, convert(int,cantidad)[cantidad] FROM JR_VW_FiltrosDiariosVALOR order by convert(date,Expr1)";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detdesp960(){
  $tsql = "SELECT T0.ItemCode, T0.ItemName, ISNULL(T0.[Prioridad],999) Prioridad, T0.PENDIENTE, T0.U_NIVEL1, T0.U_NIVEL2, T0.U_NIVEL3,
    (SELECT ISNULL(SUM(T1.OnHand),0)
    	FROM OITW T1
    	WHERE T1.WhsCode IN ('86','900','10','5','2','999') AND T1.ItemCode = T0.ItemCode)[Disponible],
    (SELECT ISNULL(SUM(D0.PlannedQty),0)
    	FROM OWOR D0
    	WHERE D0.Status='R' AND D0.ItemCode = T0.ItemCode)[requerida960],
    (SELECT ISNULL(SUM(E0.PlannedQty-E0.CmpltQty),0)
    	FROM OWOR E0
    	WHERE E0.Status='R' AND E0.ItemCode = T0.ItemCode)[pendiente912]
    FROM [JR_PRODUCCION04] T0
    WHERE T0.U_Nivel1 = 410
    ORDER BY T0.Prioridad";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detqreq($despiece){
  $tsql = "SELECT T3.Num, T0.DOCNUM, CASE WHEN T0.Status = 'R' THEN 'LIBERADO' ELSE 'PLANIFICADO' END [ESTADO]  ,  T0.ItemCode, T2.ItemName,T1.PlannedQty - T1.IssuedQty[Cantidad]
  FROM OWOR T0
  	INNER JOIN WOR1 T1 ON T0.DocEntry = T1.DocEntry
  	INNER JOIN OITM T2 ON T0.ItemCode = T2.ItemCode
  	left JOIN [JR_PRIORIDADESPRODUC] T3 ON T0.ItemCode = T3.ItemCode
  WHERE T1.ItemCode = '$despiece'
  	AND T0.Status IN ('R','P')
  	AND (T1.PlannedQty - T1.IssuedQty) > 0
  ORDER BY T3.Num ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detplansindesp(){
  $tsql = "SELECT distinct T0.[DocNum],T0.[ItemCode],T0.[ItemName],CONVERT(INT,T0.[PlannedQty])[PlannedQty]
	   ,ISNULL(T1.[Num],999)[Prioridad],T2.PostDate,T3.U_Descripcion2,T3.AvgPrice,
     CONVERT(INT,T0.[PlannedQty] * T3.AvgPrice)[CTOTOTAL]
    FROM [OF_ComponentesYEstados] T0
    	LEFT JOIN [JR_PrioridadNAC] T1 ON T0.ItemCode = T1.ItemCode
    	LEFT JOIN OWOR T2 ON T0.DocNum = T2.DocNum
    	LEFT JOIN OITM T3 ON T0.ItemCode = T3.ItemCode
    where T0.[QuantityReq] > T0.[StockOfLiberado]";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detplancondesp(){
  $tsql = "SELECT T0.DocNum, T0.ItemCode,T1.[ItemName], CONVERT(INT,T0.[PlannedQty])[PlannedQty],
      ISNULL(T2.[Num],999)[Prioridad], T0.PostDate, T1.U_Descripcion2, CONVERT(INT,T1.AvgPrice)[AvgPrice],
      CONVERT(INT,T0.[PlannedQty] * T1.AvgPrice)[CTOTOTAL]
    FROM OWOR T0
    	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
    	LEFT JOIN [JR_PrioridadNAC] T2 ON T0.ItemCode = T2.ItemCode
    WHERE T0.DocNum NOT IN (SELECT G0.DOCNUM FROM OFsSinStock G0)
    	AND T0.Status = 'P' AND T1.U_Nivel1 IN ('100', '150', '200')
    order by T2.[Num]";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_detplancondesp70(){
  $tsql = "SELECT T0.DocNum, T0.ItemCode,T1.[ItemName], CONVERT(INT,T0.[PlannedQty])[PlannedQty],
      CONVERT(INT,(((T0.[PlannedQty]*70)/100)))[Al70], ISNULL(T2.[Num],999)[Prioridad], T0.PostDate,
      T1.U_Descripcion2, CONVERT(INT,T1.AvgPrice)[AvgPrice], CONVERT(INT,T0.[PlannedQty] * T1.AvgPrice)[CTOTOTAL]
    FROM OWOR T0
    	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
    	LEFT JOIN [JR_PrioridadNAC] T2 ON T0.ItemCode = T2.ItemCode
    WHERE T0.DocNum NOT IN (SELECT G0.DOCNUM FROM JR_OFsAl70 G0)
    	AND T0.Status = 'P' AND T1.U_Nivel1 IN ('100', '150', '200')
    order by T2.[Num]";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_ordplansindesphead($of){
  $tsql = "SELECT T0.DocNum, T0.ItemCode, T1.ItemName, CONVERT(INT,T0.PlannedQty)[PlannedQty], CONVERT(DATE,T0.DueDate)[DueDate],
      ISNULL(T2.CardName,'')[CLIENTE], CASE WHEN T0.Status = 'R' THEN 'Liberada' ELSE CASE WHEN T0.Status = 'P' THEN 'Planificada' ELSE 'Cerrada' END END AS [STATUS]
    FROM OWOR T0 INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode LEFT JOIN OCRD T2 ON T0.CardCode = T2.CardCode
    WHERE T0.DocNum = $of";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_ordplansindesp($of){
  $tsql = "SELECT T0.DocNum, T2.Code, T5.ItemName AS Descripcion, CONVERT(DECIMAL(19,2),T0.PlannedQty * (T2.Quantity / 1000)) AS QuantityReq,
    (SELECT (SELECT SUM(OITW_1.OnHand) AS Expr1 FROM OITW AS OITW_1 INNER JOIN OITM ON OITW_1.ItemCode = OITM.ItemCode AND OITW_1.WhsCode = OITM.DfltWH
  		WHERE (OITW_1.ItemCode = T2.Code))- ISNULL((SUM(WOR1.PlannedQty)- SUM(WOR1.IssuedQty)),0) AS STOCK
      FROM  WOR1 INNER JOIN OWOR ON WOR1.DocEntry = OWOR.DocEntry INNER JOIN OITW ON WOR1.ItemCode = OITW.ItemCode INNER JOIN
      OITM ON OITW.WhsCode = OITM.DfltWH AND OITW.ItemCode = OITM.ItemCode WHERE (OWOR.Status = 'R') AND (OITW.ItemCode = T2.Code))StockOfLiberado
    FROM dbo.OWOR AS T0 INNER JOIN dbo.OITT AS T1 ON T0.ItemCode = T1.Code INNER JOIN dbo.ITT1 AS T2 ON T1.Code = T2.Father INNER JOIN
      dbo.OITW AS T3 ON T2.Code = T3.ItemCode INNER JOIN dbo.OITM AS T5 ON T2.Code = T5.ItemCode
    WHERE (T0.Status = 'P') AND (T3.WhsCode IN ('7', '86', '2', '9', '5')) AND T2.Code NOT LIKE '850%' AND T2.Code NOT LIKE '900%' AND T0.DocNum = $of
    GROUP BY T0.DocNum, T0.ItemCode, T0.PlannedQty, T2.Code, T5.ItemName, T2.Quantity
    ORDER BY T0.DocNum, T2.Code";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_liberahoypg(){
  $tsql = "SELECT T0.DocNum, T0.ItemCode, left(T1.ItemName,25)[ItemName], T0.PlannedQty, T0.CmpltQty
  , (T0.PlannedQty - T0.CmpltQty)[CANTPENDIENTE], T0.PostDate, T0.RlsDate, T1.U_Descripcion2, ISNULL(T2.[Num],999)[Prioridad]
  , CONVERT(INT, T1.AvgPrice)[CTOUNI], CONVERT(INT,T0.[PlannedQty] * T1.AvgPrice)[CTOTOTAL], ROW_NUMBER() OVER(ORDER BY T0.ItemCode ASC) Fila
  , DATEDIFF(DAY, T0.RlsDate, GETDATE())[DIAS]
  FROM OWOR T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  	LEFT JOIN [JR_PrioridadNAC] T2 ON T0.ItemCode = T2.ItemCode
  WHERE T0.Status = 'R'
  	AND T0.PostDate > EOMONTH(getdate(),-36)
  	AND T1.U_Nivel1 IN (100, 150, 200, 250)
  	AND (T0.PlannedQty - T0.CmpltQty) > 0";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_entregahoypg(){
  $tsql = "SELECT A0.ItemCode, left(A0.Dscription,25)[Dscription], A0.U_Descripcion2, A0.PlannedQty, A0.RlsDate, A0.PostDate, A0.QTYPENDIENTE, A0.DocNum, A0.Quantity, A0.LineTotal
      ,(SELECT COUNT(DISTINCT F0.DocDate) FROM OIGN F0 INNER JOIN IGN1 F1 ON F0.DocEntry = F1.DocEntry WHERE F1.BaseRef = A0.DocNum)[CONTADOR]
      ,ISNULL(A1.[Num],999)[Prioridad] FROM (SELECT T1.ItemCode, T1.Dscription, T2.U_Descripcion2, T3.PlannedQty, T3.RlsDate, T3.PostDate, ((T3.PlannedQty) - (T3.CmpltQty))[QTYPENDIENTE],
      T3.DocNum, SUM(T1.Quantity)[Quantity], SUM(T1.LineTotal)[LineTotal] FROM OIGN T0 INNER JOIN IGN1 T1 ON T0.DocEntry = T1.DocEntry INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode
  	  INNER JOIN OWOR T3 ON T1.BaseRef = T3.DocEntry WHERE 1 = 1 AND T1.BaseType = 202 AND CONVERT(DATE, T0.DocDate) = CONVERT(DATE, GETDATE())
  	  AND T2.U_Nivel1 IN (100, 150, 200) GROUP BY T1.ItemCode, T1.Dscription, T2.U_Descripcion2, T3.PlannedQty, T3.RlsDate, T3.PostDate, (T3.PlannedQty - T3.CmpltQty), T3.DocNum
    ) A0 LEFT JOIN [JR_PrioridadNAC] A1 ON A0.ItemCode = A1.ItemCode";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_ent30d(){
  $tsql = "SELECT A0.ItemCode, A0.Dscription, A0.U_Descripcion2, A0.PlannedQty, A0.RlsDate, A0.PostDate,
      A0.QTYPENDIENTE, A0.DocNum, A0.Quantity, A0.LineTotal, ISNULL(A0.[Prioridad],999)[Prioridad], A0.CONTADOR,
      A0.FechaEntrega, A0.Fila
    FROM (SELECT T0.* FROM JR_DetFabricacionDiaria T0 WHERE CONVERT(DATE, T0.FechaEntrega) >= CONVERT(DATE, DATEADD( MONTH,-1,GETDATE()))) A0
    left JOIN [JR_PrioridadNAC] A1 ON A0.ItemCode = A1.ItemCode
    ORDER BY A0.FechaEntrega ASC, A0.Fila ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_priofabnac(){
  $tsql = "SELECT T0.ItemCode, T0.Num, T1.ItemName, T1.U_Descripcion2,
  (SELECT G0.BufferVta
  FROM [BufferVTA] G0
  WHERE G0.ItemCode = T0.ItemCode
  )[BUFFER],
  (SELECT ISNULL(SUM(Z0.PlannedQty) - SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[QTYPENDIENTE],
  (SELECT ISNULL(SUM(Z0.PlannedQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoTotal],
  (SELECT ISNULL(SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoEntregado],
  (SELECT ISNULL(SUM(F0.PlannedQty),0)
  FROM OWOR F0
  WHERE 1 = 1
  	AND F0.Status = 'P'
  	AND F0.ItemCode = T0.ItemCode
  )[PLANIF]
  , (SELECT TOP 1 DATEDIFF(DAY, G0.DocDate, GETDATE()) [DIAS]
  FROM OIGN G0
  	INNER JOIN IGN1 G1 ON G0.DocEntry = G1.DocEntry
  WHERE G1.ItemCode = T0.ItemCode
  	AND G1.BaseType = 202
  ORDER BY DocNum DESC)LastDayEntry
  FROM [JR_PrioridadNAC] T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  ORDER BY T0.Num ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_priofabimp(){
  $tsql = "SELECT T0.ItemCode, T0.Num, T1.ItemName, T1.U_Descripcion2,
  (SELECT G0.BufferVta
  FROM [BufferVTA] G0
  WHERE G0.ItemCode = T0.ItemCode
  )[BUFFER],
  (SELECT ISNULL(SUM(Z0.PlannedQty) - SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[QTYPENDIENTE],
  (SELECT ISNULL(SUM(Z0.PlannedQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoTotal],
  (SELECT ISNULL(SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoEntregado],
  (SELECT ISNULL(SUM(F0.PlannedQty),0)
  FROM OWOR F0
  WHERE 1 = 1
  	AND F0.Status = 'P'
  	AND F0.ItemCode = T0.ItemCode
  )[PLANIF]
  FROM [JR_PrioridadIMP] T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  ORDER BY T0.Num ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_priofabesp(){
  $tsql = "SELECT T0.ItemCode, T0.Num, T1.ItemName, T1.U_Descripcion2,
  (SELECT G0.BufferVta
  FROM [BufferVTA] G0
  WHERE G0.ItemCode = T0.ItemCode
  )[BUFFER],
  (SELECT ISNULL(SUM(Z0.PlannedQty) - SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[QTYPENDIENTE],
  (SELECT ISNULL(SUM(Z0.PlannedQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoTotal],
  (SELECT ISNULL(SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoEntregado],
  (SELECT ISNULL(SUM(F0.PlannedQty),0)
  FROM OWOR F0
  WHERE 1 = 1
  	AND F0.Status = 'P'
  	AND F0.ItemCode = T0.ItemCode
  )[PLANIF],
  (SELECT TOP 1 F0.DueDate
  FROM OWOR F0
  WHERE 1 = 1
  	AND F0.Status IN ('P','R')
  	AND F0.ItemCode = T0.ItemCode
  )[FchCreacion]
  FROM [JR_PrioridadESP] T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  ORDER BY T0.Num ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_priofabdes(){
  $tsql = "SELECT T0.ItemCode, T0.Num, T1.ItemName, T1.U_Descripcion2,
  (SELECT G0.BufferVta
  FROM [BufferVTA] G0
  WHERE G0.ItemCode = T0.ItemCode
  )[BUFFER],
  (SELECT ISNULL(SUM(Z0.PlannedQty) - SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[QTYPENDIENTE],
  (SELECT ISNULL(SUM(Z0.PlannedQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoTotal],
  (SELECT ISNULL(SUM(Z0.CmpltQty),0)
  FROM OWOR Z0
  WHERE 1 = 1
  	AND Z0.Status = 'R'
  	AND Z0.ItemCode = T0.ItemCode
  )[LiberadoEntregado],
  (SELECT ISNULL(SUM(F0.PlannedQty),0)
  FROM OWOR F0
  WHERE 1 = 1
  	AND F0.Status = 'P'
  	AND F0.ItemCode = T0.ItemCode
  )[PLANIF]
  FROM [JR_PrioridadDESC] T0
  	INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
  ORDER BY T0.Num ASC";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_getlineaprod($linea){
  $tsql = "SELECT * FROM JR_LineasProducivasCapacidad WHERE idlinea = $linea";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_getordlinea($linea){
  $tsql = "SELECT T0.DocEntry, T0.ItemCode, T1.ItemName, T0.PlannedQty, T1.U_Descripcion2
    FROM OWOR T0 INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
    WHERE T0.Status = 'R' AND T0.PostDate >= '01-01-2021' AND T1.U_Nivel1 IN (100, 150, 200) AND T1.U_Nivel2 = $linea";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_getofxprint($cod){
  $qry1 = "SELECT DocEntry FROM ofliberadasximprimir WHERE DocEntry = $cod";
    $res1 = $GLOBALS['connmy']->query($qry1);
    return $res1;
}

function fn_getofrelxprint(){
  $qry1 = "SELECT * FROM ofliberadasximprimir_cab";
    $res1 = $GLOBALS['connmy']->query($qry1);
    return $res1;
}

function fn_getoldofxprint($id){
  $qry1 = "SELECT * FROM ofliberadasximprimir_cab WHERE id = $id";
    $res1 = $GLOBALS['connmy']->query($qry1);
    return $res1;
}

function fn_getoldofdet($id){

  $qry1 = "SELECT * FROM ofliberadasximprimir WHERE id_cab = $id";
    $res1 = $GLOBALS['connmy']->query($qry1);
    return $res1;
}

function fn_oldxprntdetqtycmplt($ordenF){
  $tsql = "SELECT T0.CmpltQty FROM OWOR T0 WHERE T0.DocEntry = $ordenF";
  $params = array();
  $options = array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $stmt = sqlsrv_query($GLOBALS['conn'], $tsql , $params, $options);
  if($stmt === false){
    die(print_r(sqlsrv_errors(), true));
  } else {
    return $stmt;
  }
}

function fn_revdespiece($numOF){
	$qry = "SELECT * FROM tb_plan_estadoof WHERE numOF = $numOF AND codProc IN ('desp', 'cut')";
	$res1 = $GLOBALS['connmy']->query($qry);
	if (mysqli_num_rows($res1) == 2){
		return true;
	} else {
		return false;
	}
}

?>
